/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import java.util.Collection;
import java.util.Set;

public class SearchEngineHelperUtil {
    private static volatile SearchEngineHelper _searchEngineHelper = ServiceProxyFactory.newServiceTrackedInstance(SearchEngineHelper.class, SearchEngineHelperUtil.class, "_searchEngineHelper", false);
    private static volatile SearchPermissionChecker _searchPermissionChecker = ServiceProxyFactory.newServiceTrackedInstance(SearchPermissionChecker.class, SearchEngineHelperUtil.class, "_searchPermissionChecker", false);

    public static void flushQueuedSearchEngine() {
        _searchEngineHelper.flushQueuedSearchEngine();
    }

    public static void flushQueuedSearchEngine(String searchEngineId) {
        _searchEngineHelper.flushQueuedSearchEngine(searchEngineId);
    }

    public static String getDefaultSearchEngineId() {
        return _searchEngineHelper.getDefaultSearchEngineId();
    }

    public static String[] getEntryClassNames() {
        return _searchEngineHelper.getEntryClassNames();
    }

    public static SearchEngine getSearchEngine(String searchEngineId) {
        return _searchEngineHelper.getSearchEngine(searchEngineId);
    }

    public static SearchEngineHelper getSearchEngineHelper() {
        return _searchEngineHelper;
    }

    public static String getSearchEngineId(Collection<Document> documents) {
        return _searchEngineHelper.getSearchEngineId(documents);
    }

    public static String getSearchEngineId(Document document) {
        return _searchEngineHelper.getSearchEngineId(document);
    }

    public static Set<String> getSearchEngineIds() {
        return _searchEngineHelper.getSearchEngineIds();
    }

    public static SearchEngine getSearchEngineSilent(String searchEngineId) {
        return _searchEngineHelper.getSearchEngineSilent(searchEngineId);
    }

    public static SearchPermissionChecker getSearchPermissionChecker() {
        return _searchPermissionChecker;
    }

    public static String getSearchReaderDestinationName(String searchEngineId) {
        return _searchEngineHelper.getSearchReaderDestinationName(searchEngineId);
    }

    public static String getSearchWriterDestinationName(String searchEngineId) {
        return _searchEngineHelper.getSearchWriterDestinationName(searchEngineId);
    }

    public static void initialize(long companyId) {
        _searchEngineHelper.initialize(companyId);
    }

    public static void removeCompany(long companyId) {
        _searchEngineHelper.removeCompany(companyId);
    }

    public static SearchEngine removeSearchEngine(String searchEngineId) {
        return _searchEngineHelper.removeSearchEngine(searchEngineId);
    }

    public static void setDefaultSearchEngineId(String defaultSearchEngineId) {
        _searchEngineHelper.setDefaultSearchEngineId(defaultSearchEngineId);
    }

    public static void setQueueCapacity(int queueCapacity) {
        _searchEngineHelper.setQueueCapacity(queueCapacity);
    }

    public static void setSearchEngine(String searchEngineId, SearchEngine searchEngine) {
        _searchEngineHelper.setSearchEngine(searchEngineId, searchEngine);
        searchEngine.initialize(0L);
    }
}

