/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.RelatedSearchResult;
import com.liferay.portal.kernel.search.Summary;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SearchResult {
    private final String _className;
    private long _classPK;
    private final List<RelatedSearchResult<Comment>> _commentRelatedSearchResults = new ArrayList<RelatedSearchResult<Comment>>();
    private final List<RelatedSearchResult<FileEntry>> _fileEntryRelatedSearchResults = new ArrayList<RelatedSearchResult<FileEntry>>();
    private Summary _summary;
    private final List<String> _versions = new ArrayList<String>();

    public SearchResult(String className, long classPK) {
        this._className = className;
        this._classPK = classPK;
    }

    public void addComment(Comment comment, Summary summary) {
        this._commentRelatedSearchResults.add(new RelatedSearchResult<Comment>(comment, summary));
    }

    public void addFileEntry(FileEntry fileEntry, Summary summary) {
        this._fileEntryRelatedSearchResults.add(new RelatedSearchResult<FileEntry>(fileEntry, summary));
    }

    public void addVersion(String version) {
        this._versions.add(version);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SearchResult)) {
            return false;
        }
        SearchResult searchResult = (SearchResult)object;
        return this._classPK == searchResult._classPK && Objects.equals(this._className, searchResult._className);
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public List<RelatedSearchResult<Comment>> getCommentRelatedSearchResults() {
        return this._commentRelatedSearchResults;
    }

    public List<RelatedSearchResult<FileEntry>> getFileEntryRelatedSearchResults() {
        return this._fileEntryRelatedSearchResults;
    }

    public Summary getSummary() {
        return this._summary;
    }

    public List<String> getVersions() {
        return this._versions;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (long)this._classPK);
        return HashUtil.hash((int)hash, (Object)this._className);
    }

    public void setSummary(Summary summary) {
        this._summary = summary;
    }
}

