/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.auth.ScreenNameValidator;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultScreenNameValidator
implements ScreenNameValidator {
    public static final String POSTFIX = "postfix";
    private static final Pattern _escapeRegexPattern = Pattern.compile("[-+\\\\\\[\\]]");
    private String _jsEscapedSpecialChars;
    private String _specialChars;
    private String _specialCharsRegex;

    @Override
    public String getAUIValidatorJS() {
        return "function(val) {var pattern = new RegExp('[^A-Za-z0-9" + this.getJSEscapedSpecialChars() + "]');if (val.match(pattern)) {return false;}return true;}";
    }

    @Override
    public String getDescription(Locale locale) {
        return LanguageUtil.format(locale, "the-screen-name-cannot-be-an-email-address-or-a-reserved-word", (Object[])new String[]{POSTFIX, this.getSpecialChars()}, false);
    }

    @Override
    public boolean validate(long companyId, String screenName) {
        return !Validator.isEmailAddress(screenName) && !StringUtil.equalsIgnoreCase(screenName, POSTFIX) && !this.hasInvalidChars(screenName);
    }

    protected String getJSEscapedSpecialChars() {
        if (this._jsEscapedSpecialChars == null) {
            this._jsEscapedSpecialChars = HtmlUtil.escapeJS(this.getSpecialCharsRegex());
        }
        return this._jsEscapedSpecialChars;
    }

    protected String getSpecialChars() {
        if (this._specialChars == null) {
            String specialChars = PropsUtil.get("users.screen.name.special.characters");
            this._specialChars = StringUtil.removeChar(specialChars, '/');
        }
        return this._specialChars;
    }

    protected String getSpecialCharsRegex() {
        if (this._specialCharsRegex == null) {
            Matcher matcher = _escapeRegexPattern.matcher(this.getSpecialChars());
            this._specialCharsRegex = matcher.replaceAll("\\\\$0");
        }
        return this._specialCharsRegex;
    }

    protected boolean hasInvalidChars(String screenName) {
        return !screenName.matches("[A-Za-z0-9" + this.getSpecialCharsRegex() + "]+");
    }
}

