/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.membershippolicy;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicy;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseOrganizationMembershipPolicy
implements OrganizationMembershipPolicy {
    @Override
    public void checkRoles(List<UserGroupRole> addUserGroupRoles, List<UserGroupRole> removeUserGroupRoles) throws PortalException {
    }

    @Override
    public boolean isMembershipAllowed(long userId, long organizationId) throws PortalException {
        try {
            this.checkMembership(new long[]{userId}, new long[]{organizationId}, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isMembershipProtected(PermissionChecker permissionChecker, long userId, long organizationId) throws PortalException {
        if (permissionChecker.isOrganizationOwner(organizationId)) {
            return false;
        }
        Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
        Group group = organization.getGroup();
        Role organizationAdministratorRole = RoleLocalServiceUtil.getRole(permissionChecker.getCompanyId(), "Organization Administrator");
        if (UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, group.getGroupId(), organizationAdministratorRole.getRoleId())) {
            return true;
        }
        Role organizationOwnerRole = RoleLocalServiceUtil.getRole(permissionChecker.getCompanyId(), "Organization Owner");
        return UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, group.getGroupId(), organizationOwnerRole.getRoleId());
    }

    @Override
    public boolean isMembershipRequired(long userId, long organizationId) throws PortalException {
        try {
            this.checkMembership(new long[]{userId}, null, new long[]{organizationId});
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isRoleAllowed(long userId, long organizationId, long roleId) throws PortalException {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
        UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole(0L);
        userGroupRole.setUserId(userId);
        userGroupRole.setGroupId(organization.getGroupId());
        userGroupRole.setRoleId(roleId);
        userGroupRoles.add(userGroupRole);
        try {
            this.checkRoles(userGroupRoles, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isRoleProtected(PermissionChecker permissionChecker, long userId, long organizationId, long roleId) throws PortalException {
        if (permissionChecker.isOrganizationOwner(organizationId)) {
            return false;
        }
        Role role = RoleLocalServiceUtil.getRole(roleId);
        String roleName = role.getName();
        if (!roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner")) {
            return false;
        }
        Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
        Group group = organization.getGroup();
        return UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, group.getGroupId(), role.getRoleId());
    }

    @Override
    public boolean isRoleRequired(long userId, long organizationId, long roleId) throws PortalException {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        Organization organization = OrganizationLocalServiceUtil.getOrganization(organizationId);
        UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole(0L);
        userGroupRole.setUserId(userId);
        userGroupRole.setGroupId(organization.getGroupId());
        userGroupRole.setRoleId(roleId);
        userGroupRoles.add(userGroupRole);
        try {
            this.checkRoles(null, userGroupRoles);
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    @Override
    public void propagateRoles(List<UserGroupRole> addUserGroupRoles, List<UserGroupRole> removeUserGroupRoles) {
    }

    @Override
    public void verifyPolicy() throws PortalException {
        ActionableDynamicQuery organizationActionableDynamicQuery = OrganizationLocalServiceUtil.getActionableDynamicQuery();
        organizationActionableDynamicQuery.setPerformActionMethod(organization -> {
            this.verifyPolicy((Organization)organization);
            ActionableDynamicQuery userGroupRoleActionableDynamicQuery = UserGroupRoleLocalServiceUtil.getActionableDynamicQuery();
            userGroupRoleActionableDynamicQuery.setGroupId(organization.getGroupId());
            userGroupRoleActionableDynamicQuery.setPerformActionMethod(userGroupRole -> this.verifyPolicy(userGroupRole.getRole()));
            userGroupRoleActionableDynamicQuery.performActions();
        });
        organizationActionableDynamicQuery.performActions();
    }

    @Override
    public void verifyPolicy(Organization organization) throws PortalException {
        this.verifyPolicy(organization, null, null, null, null);
    }

    @Override
    public void verifyPolicy(Role role) {
    }

    @Override
    public void verifyPolicy(Role role, Role oldRole, Map<String, Serializable> oldExpandoAttributes) {
    }
}

