/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class DynamicServletRequest
extends HttpServletRequestWrapper {
    public static final String DYNAMIC_QUERY_STRING = "DYNAMIC_QUERY_STRING";
    private final boolean _inherit;
    private final Map<String, String[]> _params = new HashMap<String, String[]>();

    public static HttpServletRequest addQueryString(HttpServletRequest httpServletRequest, Map<String, String[]> parameterMap, String queryString) {
        return DynamicServletRequest.addQueryString(httpServletRequest, parameterMap, queryString, true);
    }

    public static HttpServletRequest addQueryString(HttpServletRequest httpServletRequest, Map<String, String[]> parameterMap, String queryString, boolean inherit) {
        String[] parameters = StringUtil.split(queryString, '&');
        if (parameters.length == 0) {
            return httpServletRequest;
        }
        parameterMap = new HashMap<String, String[]>(parameterMap);
        for (String parameter : parameters) {
            String[] values;
            String[] parameterParts = StringUtil.split(parameter, '=');
            String name = parameterParts[0];
            String value = "";
            if (parameterParts.length == 2) {
                value = parameterParts[1];
            }
            if ((values = parameterMap.get(name)) == null) {
                parameterMap.put(name, new String[]{value});
                continue;
            }
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            parameterMap.put(name, newValues);
        }
        httpServletRequest = new DynamicServletRequest((HttpServletRequest)httpServletRequest, parameterMap, inherit);
        httpServletRequest.setAttribute(DYNAMIC_QUERY_STRING, (Object)queryString);
        return httpServletRequest;
    }

    public static HttpServletRequest addQueryString(HttpServletRequest httpServletRequest, String queryString) {
        return DynamicServletRequest.addQueryString(httpServletRequest, new HashMap<String, String[]>(), queryString, true);
    }

    public static HttpServletRequest addQueryString(HttpServletRequest httpServletRequest, String queryString, boolean inherit) {
        return DynamicServletRequest.addQueryString(httpServletRequest, new HashMap<String, String[]>(), queryString, inherit);
    }

    public DynamicServletRequest(HttpServletRequest httpServletRequest) {
        this(httpServletRequest, null, true);
    }

    public DynamicServletRequest(HttpServletRequest httpServletRequest, boolean inherit) {
        this(httpServletRequest, null, inherit);
    }

    public DynamicServletRequest(HttpServletRequest httpServletRequest, Map<String, String[]> params) {
        this(httpServletRequest, params, true);
    }

    public DynamicServletRequest(HttpServletRequest httpServletRequest, Map<String, String[]> params, boolean inherit) {
        super(httpServletRequest);
        this._inherit = inherit;
        if (params != null) {
            this._params.putAll(params);
        }
        if (this._inherit && httpServletRequest instanceof DynamicServletRequest) {
            DynamicServletRequest dynamicRequest = (DynamicServletRequest)httpServletRequest;
            dynamicRequest.injectInto(this);
            params = dynamicRequest.getDynamicParameterMap();
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                String name = entry.getKey();
                String[] oldValues = entry.getValue();
                String[] curValues = this._params.get(name);
                if (curValues == null) {
                    this._params.put(name, oldValues);
                    continue;
                }
                String[] newValues = ArrayUtil.append(oldValues, curValues);
                this._params.put(name, newValues);
            }
        }
    }

    public void appendParameter(String name, String value) {
        String[] values = this._params.get(name);
        if (values == null) {
            values = new String[]{value};
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            values = newValues;
        }
        this._params.put(name, values);
    }

    public Map<String, String[]> getDynamicParameterMap() {
        return this._params;
    }

    public String getParameter(String name) {
        Object[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameter(name);
        }
        if (ArrayUtil.isNotEmpty(values)) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (this._inherit) {
            map.putAll(super.getParameterMap());
        }
        map.putAll(this._params);
        return map;
    }

    public Enumeration<String> getParameterNames() {
        if (this._params.isEmpty()) {
            if (this._inherit) {
                return super.getParameterNames();
            }
            return Collections.emptyEnumeration();
        }
        Set<String> names = null;
        if (this._inherit) {
            Enumeration enumeration = super.getParameterNames();
            while (enumeration.hasMoreElements()) {
                if (names == null) {
                    names = new LinkedHashSet<String>();
                }
                names.add((String)enumeration.nextElement());
            }
        }
        if (names == null) {
            names = this._params.keySet();
        } else {
            names.addAll(this._params.keySet());
        }
        return Collections.enumeration(names);
    }

    public String[] getParameterValues(String name) {
        String[] values = this._params.get(name);
        if (this._inherit && values == null) {
            return super.getParameterValues(name);
        }
        return values;
    }

    public void setParameter(String name, String value) {
        this._params.put(name, new String[]{value});
    }

    public void setParameterValues(String name, String[] values) {
        this._params.put(name, values);
    }

    protected void injectInto(DynamicServletRequest dynamicServletRequest) {
        dynamicServletRequest.setRequest(this.getRequest());
    }
}

