/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Enumeration;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class RequestDispatcherUtil {
    public static ObjectValuePair<String, Long> getContentAndLastModifiedTime(RequestDispatcher requestDispatcher, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        LastModifiedCacheServletResponse bufferCacheServletResponse = new LastModifiedCacheServletResponse(httpServletResponse);
        requestDispatcher.include((ServletRequest)new HttpServletRequestWrapper(httpServletRequest){

            public long getDateHeader(String name) {
                if (name.equals("If-Modified-Since")) {
                    return -1L;
                }
                return super.getDateHeader(name);
            }

            public String getHeader(String name) {
                if (name.equals("If-Modified-Since") || name.equals("If-None-Match") || name.equals("Last-Modified")) {
                    return null;
                }
                return super.getHeader(name);
            }

            public Enumeration<String> getHeaders(String name) {
                if (name.equals("If-Modified-Since") || name.equals("If-None-Match") || name.equals("Last-Modified")) {
                    return null;
                }
                return super.getHeaders(name);
            }

            public String getMethod() {
                return "GET";
            }
        }, (ServletResponse)bufferCacheServletResponse);
        return new ObjectValuePair<String, Long>(bufferCacheServletResponse.getString(), GetterUtil.getLong(((MetaInfoCacheServletResponse)bufferCacheServletResponse).getHeader("Last-Modified"), -1L));
    }

    public static String getEffectivePath(HttpServletRequest httpServletRequest) {
        DispatcherType dispatcherType = httpServletRequest.getDispatcherType();
        if (dispatcherType.equals((Object)DispatcherType.FORWARD)) {
            return (String)httpServletRequest.getAttribute("javax.servlet.forward.servlet_path");
        }
        if (dispatcherType.equals((Object)DispatcherType.INCLUDE)) {
            return (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        }
        return httpServletRequest.getServletPath();
    }

    public static long getLastModifiedTime(RequestDispatcher requestDispatcher, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        LastModifiedCacheServletResponse metaInfoCacheServletResponse = new LastModifiedCacheServletResponse(httpServletResponse);
        requestDispatcher.include((ServletRequest)new HttpServletRequestWrapper(httpServletRequest){

            public String getMethod() {
                return "HEAD";
            }
        }, (ServletResponse)metaInfoCacheServletResponse);
        return GetterUtil.getLong(((MetaInfoCacheServletResponse)metaInfoCacheServletResponse).getHeader("Last-Modified"), -1L);
    }

    private static class LastModifiedCacheServletResponse
    extends BufferCacheServletResponse {
        private String _lastModified;

        public LastModifiedCacheServletResponse(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        @Override
        public void addDateHeader(String name, long value) {
            if (StringUtil.equalsIgnoreCase(name, "Last-Modified")) {
                this._lastModified = String.valueOf(value);
                return;
            }
            super.addDateHeader(name, value);
        }

        @Override
        public void addHeader(String name, String value) {
            if (StringUtil.equalsIgnoreCase(name, "Last-Modified")) {
                this._lastModified = value;
                return;
            }
            super.addHeader(name, value);
        }

        @Override
        public String getHeader(String name) {
            if (StringUtil.equalsIgnoreCase(name, "Last-Modified")) {
                return this._lastModified;
            }
            return super.getHeader(name);
        }

        @Override
        public void setDateHeader(String name, long value) {
            if (StringUtil.equalsIgnoreCase(name, "Last-Modified")) {
                this._lastModified = String.valueOf(value);
                return;
            }
            super.setDateHeader(name, value);
        }

        @Override
        public void setHeader(String name, String value) {
            if (StringUtil.equalsIgnoreCase(name, "Last-Modified")) {
                this._lastModified = value;
                return;
            }
            super.setHeader(name, value);
        }
    }
}

