/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.internal.util.ContextResourcePathsUtil;
import com.liferay.portal.kernel.servlet.FileTimestampUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletContext;

public class ServletContextUtil {
    public static final String PATH_WEB_INF = "/WEB-INF";
    public static final String URI_ATTRIBUTE = ServletContextUtil.class.getName() + ".rootURI";
    private static final String _EXT_CLASS = ".class";
    private static final String _EXT_JAR = ".jar";

    public static Set<String> getClassNames(ServletContext servletContext) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        ServletContextUtil._getClassNames(servletContext, "/WEB-INF/classes", classNames);
        ServletContextUtil._getClassNames(servletContext, "/WEB-INF/lib", classNames);
        return classNames;
    }

    public static long getLastModified(ServletContext servletContext) {
        return ServletContextUtil.getLastModified(servletContext, "/");
    }

    public static long getLastModified(ServletContext servletContext, String path) {
        return ServletContextUtil.getLastModified(servletContext, path, false);
    }

    public static long getLastModified(ServletContext servletContext, String path, boolean cache) {
        String lastModifiedCacheKey = null;
        if (cache) {
            lastModifiedCacheKey = ServletContextUtil.class.getName();
            Long lastModified = (Long)servletContext.getAttribute(lastModifiedCacheKey = StringBundler.concat((String[])new String[]{lastModifiedCacheKey, ".", path}));
            if (lastModified != null) {
                return lastModified;
            }
        }
        long lastModified = ServletContextUtil._getLastModified(servletContext, path);
        if (cache) {
            servletContext.setAttribute(lastModifiedCacheKey, (Object)lastModified);
        }
        return lastModified;
    }

    public static String getResourcePath(URL url) throws URISyntaxException {
        URI uri = ServletContextUtil.getResourceURI(url);
        return uri.toString();
    }

    public static URI getResourceURI(URL url) throws URISyntaxException {
        return new URI(url.getProtocol(), url.getPath(), null);
    }

    public static String getRootPath(ServletContext servletContext) throws MalformedURLException {
        URI rootURI = ServletContextUtil.getRootURI(servletContext);
        return rootURI.toString();
    }

    public static URI getRootURI(ServletContext servletContext) throws MalformedURLException {
        URI rootURI = (URI)servletContext.getAttribute(URI_ATTRIBUTE);
        if (rootURI != null) {
            return rootURI;
        }
        try {
            URL rootURL = servletContext.getResource(PATH_WEB_INF);
            String path = rootURL.getPath();
            int index = path.indexOf(PATH_WEB_INF);
            if (index < 0) {
                throw new MalformedURLException("Invalid URL " + rootURL);
            }
            path = index == 0 ? "/" : path.substring(0, index);
            rootURI = new URI(rootURL.getProtocol(), path, null);
            servletContext.setAttribute(URI_ATTRIBUTE, (Object)rootURI);
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new MalformedURLException(uriSyntaxException.getMessage());
        }
        return rootURI;
    }

    private static String _getClassName(String rootPath, String path) {
        String className = path.substring(0, path.length() - _EXT_CLASS.length());
        if (rootPath != null) {
            className = className.substring(rootPath.length() + 1);
        }
        return StringUtil.replace(className, '/', '.');
    }

    private static void _getClassNames(ServletContext servletContext, String rootPath, Set<String> classNames) throws IOException {
        ServletContextUtil._getClassNames(servletContext, rootPath, servletContext.getResourcePaths(rootPath), classNames);
    }

    private static void _getClassNames(ServletContext servletContext, String rootPath, Set<String> paths, Set<String> classNames) throws IOException {
        if (paths == null) {
            return;
        }
        for (String path : paths) {
            if (path.endsWith(_EXT_CLASS)) {
                String className = ServletContextUtil._getClassName(rootPath, path);
                classNames.add(className);
                continue;
            }
            if (path.endsWith(_EXT_JAR)) {
                JarInputStream jarFile = new JarInputStream(servletContext.getResourceAsStream(path));
                Throwable throwable = null;
                try {
                    JarEntry jarEntry;
                    while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                        String jarEntryName = jarEntry.getName();
                        if (!jarEntryName.endsWith(_EXT_CLASS)) continue;
                        String className = ServletContextUtil._getClassName(null, jarEntryName);
                        classNames.add(className);
                    }
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                    continue;
                }
            }
            if (!path.endsWith("/")) continue;
            ServletContextUtil._getClassNames(servletContext, rootPath, servletContext.getResourcePaths(path), classNames);
        }
    }

    private static long _getLastModified(ServletContext servletContext, String path) {
        Long lastModifiedLong = ContextResourcePathsUtil.visitResources(servletContext, path, null, enumeration -> {
            long lastModified = 0L;
            if (enumeration == null) {
                return lastModified;
            }
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                String curPath = url.getPath();
                if (curPath.charAt(curPath.length() - 1) == '/') continue;
                try {
                    long curLastModified = URLUtil.getLastModifiedTime(url);
                    if (curLastModified <= lastModified) continue;
                    lastModified = curLastModified;
                }
                catch (IOException iOException) {}
            }
            return lastModified;
        });
        if (lastModifiedLong != null) {
            return lastModifiedLong;
        }
        String curPath = null;
        long lastModified = 0L;
        LinkedList<String> pathQueue = new LinkedList<String>();
        pathQueue.offer(path);
        while ((curPath = (String)pathQueue.poll()) != null) {
            if (curPath.charAt(curPath.length() - 1) == '/') {
                Set pathSet = servletContext.getResourcePaths(curPath);
                if (pathSet == null) continue;
                pathQueue.addAll(pathSet);
                continue;
            }
            long curLastModified = FileTimestampUtil.getTimestamp(servletContext, curPath);
            if (curLastModified <= lastModified) continue;
            lastModified = curLastModified;
        }
        return lastModified;
    }
}

