/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TemplateResourceLoaderUtil {
    private static final TemplateResourceLoaderUtil _templateResourceLoaderUtil = new TemplateResourceLoaderUtil();
    private final ServiceTracker<TemplateResourceLoader, TemplateResourceLoader> _serviceTracker;
    private final Map<String, TemplateResourceLoader> _templateResourceLoaders = new ConcurrentHashMap<String, TemplateResourceLoader>();

    public static void clearCache() {
        _templateResourceLoaderUtil._clearCache();
    }

    public static void clearCache(String templateResourceLoaderName) throws TemplateException {
        _templateResourceLoaderUtil._clearCache(templateResourceLoaderName);
    }

    public static void clearCache(String templateResourceLoaderName, String templateId) throws TemplateException {
        _templateResourceLoaderUtil._clearCache(templateResourceLoaderName, templateId);
    }

    public static TemplateResource getTemplateResource(String templateResourceLoaderName, String templateId) throws TemplateException {
        return _templateResourceLoaderUtil._getTemplateResource(templateResourceLoaderName, templateId);
    }

    public static TemplateResourceLoader getTemplateResourceLoader(String templateResourceLoaderName) throws TemplateException {
        return _templateResourceLoaderUtil._getTemplateResourceLoader(templateResourceLoaderName);
    }

    public static Set<String> getTemplateResourceLoaderNames() {
        return _templateResourceLoaderUtil._getTemplateResourceLoaderNames();
    }

    public static boolean hasTemplateResource(String templateResourceLoaderName, String templateId) throws TemplateException {
        return _templateResourceLoaderUtil._hasTemplateResource(templateResourceLoaderName, templateId);
    }

    public static boolean hasTemplateResourceLoader(String templateResourceLoaderName) {
        return _templateResourceLoaderUtil._hasTemplateResourceLoader(templateResourceLoaderName);
    }

    private TemplateResourceLoaderUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(TemplateResourceLoader.class, (ServiceTrackerCustomizer)new TemplateResourceLoaderTrackerCustomizer());
        this._serviceTracker.open();
    }

    private void _clearCache() {
        for (TemplateResourceLoader templateResourceLoader : this._templateResourceLoaders.values()) {
            templateResourceLoader.clearCache();
        }
    }

    private void _clearCache(String templateResourceLoaderName) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = this._getTemplateResourceLoader(templateResourceLoaderName);
        templateResourceLoader.clearCache();
    }

    private void _clearCache(String templateResourceLoaderName, String templateId) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = this._getTemplateResourceLoader(templateResourceLoaderName);
        templateResourceLoader.clearCache(templateId);
    }

    private TemplateResource _getTemplateResource(String templateResourceLoaderName, String templateId) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = this._getTemplateResourceLoader(templateResourceLoaderName);
        return templateResourceLoader.getTemplateResource(templateId);
    }

    private TemplateResourceLoader _getTemplateResourceLoader(String templateResourceLoaderName) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = this._templateResourceLoaders.get(templateResourceLoaderName);
        if (templateResourceLoader == null) {
            throw new TemplateException("Unsupported template resource loader " + templateResourceLoaderName);
        }
        return templateResourceLoader;
    }

    private Set<String> _getTemplateResourceLoaderNames() {
        return this._templateResourceLoaders.keySet();
    }

    private boolean _hasTemplateResource(String templateResourceLoaderName, String templateId) throws TemplateException {
        TemplateResourceLoader templateResourceLoader = this._getTemplateResourceLoader(templateResourceLoaderName);
        return templateResourceLoader.hasTemplateResource(templateId);
    }

    private boolean _hasTemplateResourceLoader(String templateResourceLoaderName) {
        return this._templateResourceLoaders.containsKey(templateResourceLoaderName);
    }

    private class TemplateResourceLoaderTrackerCustomizer
    implements ServiceTrackerCustomizer<TemplateResourceLoader, TemplateResourceLoader> {
        private TemplateResourceLoaderTrackerCustomizer() {
        }

        public TemplateResourceLoader addingService(ServiceReference<TemplateResourceLoader> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            TemplateResourceLoader templateResourceLoader = (TemplateResourceLoader)registry.getService(serviceReference);
            TemplateResourceLoaderUtil.this._templateResourceLoaders.put(templateResourceLoader.getName(), templateResourceLoader);
            return templateResourceLoader;
        }

        public void modifiedService(ServiceReference<TemplateResourceLoader> serviceReference, TemplateResourceLoader templateResourceLoader) {
        }

        public void removedService(ServiceReference<TemplateResourceLoader> serviceReference, TemplateResourceLoader templateResourceLoader) {
            TemplateResourceLoaderUtil.this._templateResourceLoaders.remove(templateResourceLoader.getName());
            templateResourceLoader.clearCache();
            templateResourceLoader.destroy();
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }
    }
}

