/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseUpgradeBadColumnNames
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseUpgradeBadColumnNames.class);

    protected void upgradeBadColumnNames(Class<?> tableClass, String ... columnNames) throws Exception {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        DBInspector dbInspector = new DBInspector(this.connection);
        String tableName = dbInspector.normalizeName(this.getTableName(tableClass), databaseMetaData);
        Map<String, String> columnSQLs = this._getTableColumnSQLs(tableClass);
        ArrayList<UpgradeProcess.AlterColumnName> alterColumnNames = new ArrayList<UpgradeProcess.AlterColumnName>(columnNames.length);
        for (String columnName : columnNames) {
            String newColumnName = columnName.concat("_");
            try (ResultSet columnResultSet = databaseMetaData.getColumns(dbInspector.getCatalog(), dbInspector.getSchema(), tableName, dbInspector.normalizeName(newColumnName, databaseMetaData));){
                if (columnResultSet.next()) {
                    continue;
                }
            }
            columnResultSet = databaseMetaData.getColumns(dbInspector.getCatalog(), dbInspector.getSchema(), tableName, dbInspector.normalizeName(columnName, databaseMetaData));
            var14_14 = null;
            try {
                if (!columnResultSet.next()) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn(StringBundler.concat((String[])new String[]{"Unable to get bad column name ", columnName, " in table ", tableName}));
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_14 = throwable;
                throw throwable;
            }
            finally {
                if (columnResultSet != null) {
                    if (var14_14 != null) {
                        try {
                            columnResultSet.close();
                        }
                        catch (Throwable throwable) {
                            var14_14.addSuppressed(throwable);
                        }
                    } else {
                        columnResultSet.close();
                    }
                }
            }
            String columnSQL = columnSQLs.get(newColumnName);
            if (Validator.isNull(columnSQL)) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(StringBundler.concat((String[])new String[]{"Unable to get SQL for column ", columnName, " in table ", tableName}));
                continue;
            }
            alterColumnNames.add(new UpgradeProcess.AlterColumnName(this, columnName, columnSQL));
        }
        this.alter(tableClass, alterColumnNames.toArray(new UpgradeProcess.AlterColumnName[0]));
    }

    private Map<String, String> _getTableColumnSQLs(Class<?> tableClass) throws Exception {
        Field tableSQLCreateField = tableClass.getField("TABLE_SQL_CREATE");
        String createSQL = (String)tableSQLCreateField.get(null);
        int startIndex = createSQL.indexOf(40);
        int endIndex = createSQL.lastIndexOf(41);
        if (startIndex < 0 || endIndex < 0 || startIndex >= endIndex) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to get column SQL from " + createSQL);
            }
            return Collections.emptyMap();
        }
        HashMap<String, String> columnSQLs = new HashMap<String, String>();
        for (String columnSQL : StringUtil.split(createSQL.substring(startIndex + 1, endIndex))) {
            int index = columnSQL.indexOf(32);
            if (index <= 0) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn("Unable to get column name from " + columnSQL);
                continue;
            }
            columnSQLs.put(columnSQL.substring(0, index), columnSQL);
        }
        return columnSQLs;
    }
}

