/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.memory.EqualityWeakReference;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class AggregateClassLoader
extends ClassLoader {
    private static final Method _FIND_CLASS_METHOD;
    private static final Method _LOAD_CLASS_METHOD;
    private final List<EqualityWeakReference<ClassLoader>> _classLoaderReferences = new ArrayList<EqualityWeakReference<ClassLoader>>();

    public static ClassLoader getAggregateClassLoader(ClassLoader parentClassLoader, ClassLoader ... classLoaders) {
        if (ArrayUtil.isEmpty(classLoaders)) {
            return parentClassLoader;
        }
        AggregateClassLoader aggregateClassLoader = null;
        if (parentClassLoader instanceof AggregateClassLoader) {
            aggregateClassLoader = (AggregateClassLoader)parentClassLoader;
            List<ClassLoader> existingClassLoaders = aggregateClassLoader.getClassLoaders();
            boolean requiresNew = false;
            for (ClassLoader classLoader : classLoaders) {
                if (classLoader.equals(parentClassLoader) || existingClassLoaders.contains(classLoader)) continue;
                requiresNew = true;
                break;
            }
            if (!requiresNew) {
                return aggregateClassLoader;
            }
            aggregateClassLoader = new AggregateClassLoader(parentClassLoader.getParent());
            aggregateClassLoader.addClassLoader(parentClassLoader);
        } else {
            aggregateClassLoader = new AggregateClassLoader(parentClassLoader);
        }
        for (ClassLoader classLoader : classLoaders) {
            aggregateClassLoader.addClassLoader(classLoader);
        }
        return aggregateClassLoader;
    }

    public static ClassLoader getAggregateClassLoader(ClassLoader[] classLoaders) {
        if (ArrayUtil.isEmpty(classLoaders)) {
            return null;
        }
        return AggregateClassLoader.getAggregateClassLoader(classLoaders[0], classLoaders);
    }

    public AggregateClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (classLoader.equals(this.getParent())) {
            return;
        }
        List<ClassLoader> classLoaders = this.getClassLoaders();
        if (classLoaders.contains(classLoader)) {
            return;
        }
        if (classLoader instanceof AggregateClassLoader) {
            AggregateClassLoader aggregateClassLoader = (AggregateClassLoader)classLoader;
            this.addClassLoader(aggregateClassLoader.getParent());
            for (ClassLoader curClassLoader : aggregateClassLoader.getClassLoaders()) {
                this.addClassLoader(curClassLoader);
            }
            return;
        }
        this._classLoaderReferences.add((EqualityWeakReference<ClassLoader>)new EqualityWeakReference((Object)classLoader));
    }

    public void addClassLoader(ClassLoader ... classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            this.addClassLoader(classLoader);
        }
    }

    public void addClassLoader(Collection<ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            this.addClassLoader(classLoader);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AggregateClassLoader)) {
            return false;
        }
        AggregateClassLoader aggregateClassLoader = (AggregateClassLoader)object;
        return this._classLoaderReferences.equals(aggregateClassLoader._classLoaderReferences) && Objects.equals(this.getParent(), aggregateClassLoader.getParent());
    }

    public List<ClassLoader> getClassLoaders() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(this._classLoaderReferences.size());
        Iterator<EqualityWeakReference<ClassLoader>> iterator = this._classLoaderReferences.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            ClassLoader classLoader = (ClassLoader)weakReference.get();
            if (classLoader == null) {
                iterator.remove();
                continue;
            }
            classLoaders.add(classLoader);
        }
        return classLoaders;
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            URL url = classLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoader classLoader : this.getClassLoaders()) {
            urls.addAll(Collections.list(classLoader.getResources(name)));
        }
        ClassLoader parentClassLoader = this.getParent();
        urls.addAll(Collections.list(parentClassLoader.getResources(name)));
        return Collections.enumeration(urls);
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, this._classLoaderReferences);
        return HashUtil.hash((int)hash, (Object)this.getParent());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                return this._findClass(classLoader, name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException("Unable to find class " + name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = null;
        for (ClassLoader classLoader : this.getClassLoaders()) {
            try {
                loadedClass = this._loadClass(classLoader, name, resolve);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (loadedClass == null) {
            loadedClass = this._loadClass(this.getParent(), name, resolve);
        } else if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    private Class<?> _findClass(ClassLoader classLoader, String name) throws ClassNotFoundException {
        try {
            return (Class)_FIND_CLASS_METHOD.invoke((Object)classLoader, name);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ClassNotFoundException("Unable to find class " + name, invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Unable to find class " + name, exception);
        }
    }

    private Class<?> _loadClass(ClassLoader classLoader, String name, boolean resolve) throws ClassNotFoundException {
        if (resolve) {
            try {
                return (Class)_LOAD_CLASS_METHOD.invoke((Object)classLoader, name, true);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ClassNotFoundException("Unable to load class " + name, invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("Unable to load class " + name, exception);
            }
        }
        return classLoader.loadClass(name);
    }

    static {
        try {
            _FIND_CLASS_METHOD = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"findClass", (Class[])new Class[]{String.class});
            _LOAD_CLASS_METHOD = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"loadClass", (Class[])new Class[]{String.class, Boolean.TYPE});
        }
        catch (Exception exception) {
            throw new LoggedExceptionInInitializerError(exception);
        }
    }
}

