/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class PwdGenerator {
    public static final String KEY1 = "0123456789";
    public static final String KEY2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String KEY3 = "abcdefghijklmnopqrstuvwxyz";
    private static final String[] _KEYS = new String[]{"0123456789", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "abcdefghijklmnopqrstuvwxyz"};
    private static final double _MULTIPLIER = 64.0 * Math.log(2.0);
    private static final Log _log = LogFactoryUtil.getLog(PwdGenerator.class);

    public static String getPassword() {
        return PwdGenerator.getPassword(8, _KEYS);
    }

    public static String getPassword(int length) {
        return PwdGenerator.getPassword(length, _KEYS);
    }

    public static String getPassword(int length, String ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Keys are null");
        }
        String fullKey = String.valueOf(new StringBundler(keys));
        int fullKeyLength = fullKey.length();
        int refreshPeriod = (int)(_MULTIPLIER / Math.log(fullKeyLength));
        long secureLong = 0L;
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            if (i % refreshPeriod == 0) {
                secureLong = SecureRandomUtil.nextLong();
            }
            int pos = Math.abs((int)(secureLong % (long)fullKeyLength));
            secureLong /= (long)fullKeyLength;
            sb.append(fullKey.charAt(pos));
        }
        return sb.toString();
    }

    public static String getPassword(String key, int length) {
        String password;
        int keysCount = 0;
        if (key.contains(KEY1)) {
            ++keysCount;
        }
        if (key.contains(KEY2)) {
            ++keysCount;
        }
        if (key.contains(KEY3)) {
            ++keysCount;
        }
        if (keysCount > length) {
            if (_log.isWarnEnabled()) {
                _log.warn("Length is too short");
            }
            length = keysCount;
        }
        do {
            password = PwdGenerator.getPassword(length, key);
        } while (key.contains(KEY1) && Validator.isNull(StringUtil.extractDigits(password)) || key.contains(KEY2) && password.equals(StringUtil.toLowerCase(password)) || key.contains(KEY3) && password.equals(StringUtil.toUpperCase(password)));
        return password;
    }

    public static String getPassword(String key, int length, boolean useAllKeys) {
        if (useAllKeys) {
            return PwdGenerator.getPassword(key, length);
        }
        return PwdGenerator.getPassword(length, key);
    }

    public static String getPinNumber() {
        return PwdGenerator.getPassword(4, KEY1);
    }
}

