/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.webdav;

import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import java.io.InputStream;
import java.text.Format;
import java.util.Date;

public class BaseResourceImpl
implements Resource {
    private static final Format _createDateFormatter = FastDateFormatFactoryUtil.getSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", LocaleUtil.US, TimeZoneUtil.GMT);
    private static final Format _modifiedDateFormatter = FastDateFormatFactoryUtil.getSimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", LocaleUtil.US, TimeZoneUtil.GMT);
    private String _className;
    private final Date _createDate;
    private final String _displayName;
    private final String _href;
    private Object _model;
    private final Date _modifiedDate;
    private long _primaryKey = -1L;
    private final long _size;

    public BaseResourceImpl(String parentPath, long name, long displayName) {
        this(parentPath, String.valueOf(name), String.valueOf(displayName));
    }

    public BaseResourceImpl(String parentPath, long name, String displayName) {
        this(parentPath, String.valueOf(name), displayName);
    }

    public BaseResourceImpl(String parentPath, String name, String displayName) {
        this(parentPath, name, displayName, null, null);
    }

    public BaseResourceImpl(String parentPath, String name, String displayName, Date createDate, Date modifiedDate) {
        this(parentPath, name, displayName, createDate, modifiedDate, 0L);
    }

    public BaseResourceImpl(String parentPath, String name, String displayName, Date createDate, Date modifiedDate, long size) {
        this._displayName = displayName;
        this._size = size;
        String href = HttpUtil.encodePath(parentPath);
        if (Validator.isNotNull(name)) {
            href = href + "/" + URLCodec.encodeURL(name, true);
        }
        this._href = href;
        this._createDate = createDate == null ? new Date() : createDate;
        this._modifiedDate = modifiedDate == null ? new Date() : modifiedDate;
    }

    @Override
    public String getClassName() {
        return this._className;
    }

    @Override
    public InputStream getContentAsStream() throws WebDAVException {
        return null;
    }

    @Override
    public String getContentType() {
        return "httpd/unix-directory";
    }

    @Override
    public String getCreateDate() {
        return _createDateFormatter.format(this._createDate);
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public String getHREF() {
        return this._href;
    }

    @Override
    public Lock getLock() {
        return null;
    }

    @Override
    public Object getModel() {
        return this._model;
    }

    @Override
    public String getModifiedDate() {
        return _modifiedDateFormatter.format(this._modifiedDate);
    }

    @Override
    public long getPrimaryKey() {
        return this._primaryKey;
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setClassName(String className) {
        this._className = className;
    }

    @Override
    public void setModel(Object model) {
        this._model = model;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        this._primaryKey = primaryKey;
    }
}

