/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.kernel.model;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.Objects;

public class SocialActivityCounterDefinition
implements Serializable {
    public static final int LIMIT_PERIOD_DAY = 1;
    public static final int LIMIT_PERIOD_LIFETIME = 2;
    public static final int LIMIT_PERIOD_PERIOD = 3;
    private boolean _enabled = true;
    private int _increment = 1;
    private boolean _limitEnabled = true;
    private int _limitPeriod = 1;
    private int _limitValue;
    private String _name;
    private int _ownerType;
    private int _periodLength = 0;
    private boolean _transient;

    public SocialActivityCounterDefinition() {
    }

    public SocialActivityCounterDefinition(String name, int ownerType) {
        this._name = name;
        this._ownerType = ownerType;
    }

    public SocialActivityCounterDefinition clone() {
        SocialActivityCounterDefinition activityCounterDefinition = new SocialActivityCounterDefinition();
        activityCounterDefinition.setEnabled(this._enabled);
        activityCounterDefinition.setIncrement(this._increment);
        activityCounterDefinition.setLimitEnabled(this._limitEnabled);
        activityCounterDefinition.setLimitPeriod(this._limitPeriod);
        activityCounterDefinition.setLimitValue(this._limitValue);
        activityCounterDefinition.setName(this._name);
        activityCounterDefinition.setOwnerType(this._ownerType);
        activityCounterDefinition.setPeriodLength(this._periodLength);
        activityCounterDefinition.setTransient(this._transient);
        return activityCounterDefinition;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SocialActivityCounterDefinition)) {
            return false;
        }
        SocialActivityCounterDefinition activityCounterDefinition = (SocialActivityCounterDefinition)object;
        return activityCounterDefinition != null && this._enabled == activityCounterDefinition._enabled && this._increment == activityCounterDefinition._increment && this._limitEnabled == activityCounterDefinition._limitEnabled && this._limitPeriod == activityCounterDefinition._limitPeriod && this._limitValue == activityCounterDefinition._limitValue && Objects.equals(this._name, activityCounterDefinition._name) && this._ownerType == activityCounterDefinition._ownerType && this._periodLength == activityCounterDefinition._periodLength && this._transient == activityCounterDefinition._transient;
    }

    public int getIncrement() {
        return this._increment;
    }

    public String getKey() {
        return StringBundler.concat((Object[])new Object[]{this._name, "/", this._ownerType});
    }

    public int getLimitPeriod() {
        return this._limitPeriod;
    }

    public int getLimitValue() {
        return this._limitValue;
    }

    public String getName() {
        return this._name;
    }

    public int getOwnerType() {
        return this._ownerType;
    }

    public int getPeriodLength() {
        return this._periodLength;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, (boolean)this._enabled);
        hash = HashUtil.hash((int)hash, (int)this._increment);
        hash = HashUtil.hash((int)hash, (boolean)this._limitEnabled);
        hash = HashUtil.hash((int)hash, (int)this._limitPeriod);
        hash = HashUtil.hash((int)hash, (int)this._limitValue);
        hash = HashUtil.hash((int)hash, (Object)this._name);
        hash = HashUtil.hash((int)hash, (int)this._ownerType);
        hash = HashUtil.hash((int)hash, (int)this._periodLength);
        return HashUtil.hash((int)hash, (boolean)this._transient);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isLimitEnabled() {
        return this._limitEnabled;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setIncrement(int increment) {
        this._increment = increment;
    }

    public void setLimitEnabled(boolean limitEnabled) {
        this._limitEnabled = limitEnabled;
    }

    public void setLimitPeriod(int limitPeriod) {
        this._limitPeriod = limitPeriod;
    }

    public void setLimitPeriod(String limitPeriod) {
        if (StringUtil.equalsIgnoreCase(limitPeriod, "day")) {
            this.setLimitPeriod(1);
        } else if (StringUtil.equalsIgnoreCase(limitPeriod, "lifetime")) {
            this.setLimitPeriod(2);
        } else {
            this.setLimitPeriod(3);
        }
    }

    public void setLimitValue(int limitValue) {
        this._limitValue = limitValue;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setOwnerType(int ownerType) {
        this._ownerType = ownerType;
    }

    public void setOwnerType(String ownerType) {
        if (StringUtil.equalsIgnoreCase(ownerType, "actor")) {
            this.setOwnerType(1);
        } else if (StringUtil.equalsIgnoreCase(ownerType, "asset")) {
            this.setOwnerType(2);
        } else if (StringUtil.equalsIgnoreCase(ownerType, "creator")) {
            this.setOwnerType(3);
        }
    }

    public void setPeriodLength(int periodLength) {
        this._periodLength = periodLength;
    }

    public void setTransient(boolean transientCounter) {
        this._transient = transientCounter;
    }
}

