/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.support.tomcat.webresources;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractFileResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResource;

public class ExtResourceSet
extends AbstractFileResourceSet {
    public ExtResourceSet() {
        super("/");
    }

    public WebResource getResource(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot webResourceRoot = this.getRoot();
        if (!path.startsWith(webAppMount)) {
            return new EmptyResource(webResourceRoot, path);
        }
        File file = this.file(path.substring(webAppMount.length()), false);
        if (file == null || !file.exists() || file.isDirectory()) {
            return new EmptyResource(webResourceRoot, path);
        }
        return new FileResource(webResourceRoot, path, file, true, this.getManifest());
    }

    public String[] list(String path) {
        this.checkPath(path);
        if (!path.equals(this.getWebAppMount())) {
            return EMPTY_STRING_ARRAY;
        }
        File extBaseFile = this.getFileBase();
        if (!extBaseFile.exists()) {
            return EMPTY_STRING_ARRAY;
        }
        Object[] extFileNames = extBaseFile.list();
        Arrays.sort(extFileNames);
        return extFileNames;
    }

    public Set<String> listWebAppPaths(String path) {
        File extBaseFile;
        File[] files;
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        ResourceSet resourceSet = new ResourceSet();
        if (path.startsWith(webAppMount) && (files = (extBaseFile = this.getFileBase()).listFiles()) != null) {
            if (path.charAt(path.length() - 1) != '/') {
                path = path.concat("/");
            }
            for (File file : files) {
                if (!file.isFile()) continue;
                resourceSet.add((Object)path.concat(file.getName()));
            }
        }
        resourceSet.setLocked(true);
        return resourceSet;
    }

    public boolean mkdir(String path) {
        return false;
    }

    public boolean write(String path, InputStream inputStream, boolean overwrite) {
        return false;
    }

    protected void checkType(File file) {
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
    }
}

