/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.support.tomcat.session;

import com.liferay.support.tomcat.session.LiferayDeltaSession;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.DeltaManager;

public class LiferayDeltaManager
extends DeltaManager {
    private static final CompletableFuture<Function<InputStream, ObjectInputStream>> _objectInputStreamFunctionFuture = new CompletableFuture();
    private static final CompletableFuture<Function<OutputStream, ObjectOutputStream>> _objectOutputStreamFunctionFuture = new CompletableFuture();
    private static final List<Runnable> _runnables = new ArrayList<Runnable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Function<InputStream, ObjectInputStream> objectInputStreamFunction, Function<OutputStream, ObjectOutputStream> objectOutputStreamFunction) {
        Class<LiferayDeltaManager> clazz = LiferayDeltaManager.class;
        synchronized (LiferayDeltaManager.class) {
            _objectInputStreamFunctionFuture.complete(objectInputStreamFunction);
            _objectOutputStreamFunctionFuture.complete(objectOutputStreamFunction);
            for (Runnable runnable : _runnables) {
                runnable.run();
            }
            _runnables.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ObjectInputStream toObjectInputStream(InputStream inputStream) {
        try {
            Function<InputStream, ObjectInputStream> function = _objectInputStreamFunctionFuture.get();
            return function.apply(inputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ObjectOutputStream toObjectOutputStream(OutputStream outputStream) {
        try {
            Function<OutputStream, ObjectOutputStream> function = _objectOutputStreamFunctionFuture.get();
            return function.apply(outputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public ClusterManager cloneFromTemplate() {
        LiferayDeltaManager liferayDeltaManager = new LiferayDeltaManager();
        this.clone((ClusterManagerBase)liferayDeltaManager);
        liferayDeltaManager.setExpireSessionsOnShutdown(this.isExpireSessionsOnShutdown());
        liferayDeltaManager.setNotifyContainerListenersOnReplication(this.isNotifyContainerListenersOnReplication());
        liferayDeltaManager.setNotifySessionListenersOnReplication(this.isNotifyContainerListenersOnReplication());
        liferayDeltaManager.setSendAllSessions(this.isSendAllSessions());
        liferayDeltaManager.setSendAllSessionsSize(this.getSendAllSessionsSize());
        liferayDeltaManager.setSendAllSessionsWaitTime(this.getSendAllSessionsWaitTime());
        liferayDeltaManager.setStateTimestampDrop(this.isStateTimestampDrop());
        liferayDeltaManager.setStateTransferTimeout(this.getStateTransferTimeout());
        return liferayDeltaManager;
    }

    public Session createEmptySession() {
        return new LiferayDeltaSession((Manager)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllClusterSessions() {
        Class<LiferayDeltaManager> clazz = LiferayDeltaManager.class;
        synchronized (LiferayDeltaManager.class) {
            if (_objectInputStreamFunctionFuture.isDone()) {
                super.getAllClusterSessions();
            } else {
                _runnables.add(() -> super.getAllClusterSessions());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

