/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.support.tomcat.session;

import com.liferay.support.tomcat.session.LiferayDeltaManager;
import com.liferay.support.tomcat.session.LiferayDeltaRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.catalina.Manager;
import org.apache.catalina.ha.session.DeltaRequest;
import org.apache.catalina.ha.session.DeltaSession;

public class LiferayDeltaSession
extends DeltaSession {
    public LiferayDeltaSession() {
    }

    public LiferayDeltaSession(Manager manager) {
        super(manager);
    }

    public void readObjectData(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        byte[] bytes = new byte[objectInputStream.readInt()];
        objectInputStream.readFully(bytes);
        try (ObjectInputStream liferayObjectInput = LiferayDeltaManager.toObjectInputStream(new ByteArrayInputStream(bytes));){
            super.doReadObject(liferayObjectInput);
        }
    }

    public void writeObjectData(ObjectOutputStream objectOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream liferayObjectOutput = LiferayDeltaManager.toObjectOutputStream(byteArrayOutputStream);){
            super.doWriteObject(liferayObjectOutput);
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        objectOutputStream.writeInt(bytes.length);
        objectOutputStream.write(bytes);
    }

    protected DeltaRequest createRequest(String sessionId, boolean recordAllActions) {
        return new LiferayDeltaRequest(sessionId, recordAllActions);
    }
}

