/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.wai;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

public class WAIFriendlyURLMapper
implements FriendlyURLMapper {
    protected Router router;
    private static final String[] _BINARY_EXTENSIONS = new String[]{".css", ".doc", ".gif", ".jpeg", ".jpg", ".js", ".odp", ".png", ".ppt", ".tgz", ".xls", ".zip"};
    private static final boolean _CHECK_MAPPING_WITH_PREFIX = true;
    private static final String _MAPPING = "waiapp";
    private String _portletId;

    public String buildPath(LiferayPortletURL liferayPortletURL) {
        String portletId;
        String prefix = portletId = liferayPortletURL.getPortletId();
        int pos = portletId.indexOf("_WAR_");
        if (pos != -1) {
            prefix = portletId.substring(0, pos);
        }
        String appUrl = GetterUtil.getString((String)liferayPortletURL.getParameter("appURL"));
        liferayPortletURL.addParameterIncludedInPath("p_p_id");
        return StringBundler.concat((String[])new String[]{"/", _MAPPING, "/", prefix, "/", appUrl});
    }

    public String getMapping() {
        return _MAPPING;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public Router getRouter() {
        return this.router;
    }

    public boolean isCheckMappingWithPrefix() {
        return true;
    }

    public boolean isPortletInstanceable() {
        return false;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> parameterMap, Map<String, Object> requestContext) {
        int x = friendlyURLPath.indexOf(_MAPPING);
        if (x == -1) {
            return;
        }
        int y = friendlyURLPath.indexOf(47, x + _MAPPING.length() + 1);
        String prefix = friendlyURLPath.substring(x + _MAPPING.length() + 1, y);
        String portletId = prefix + "_WAR_" + prefix;
        parameterMap.put("p_p_id", new String[]{portletId});
        parameterMap.put("p_p_lifecycle", new String[]{"0"});
        if (this.hasBinaryExtension(friendlyURLPath)) {
            parameterMap.put("p_p_state", new String[]{LiferayWindowState.EXCLUSIVE.toString()});
        } else {
            parameterMap.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
        }
        parameterMap.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        String path = friendlyURLPath.substring(y);
        parameterMap.put(namespace + "appURL", new String[]{path});
    }

    public void setMapping(String mapping) {
    }

    public void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    public void setPortletInstanceable(boolean portletInstanceable) {
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    protected boolean hasBinaryExtension(String friendlyURLPath) {
        for (String binaryExtension : _BINARY_EXTENSIONS) {
            if (!friendlyURLPath.endsWith(binaryExtension)) continue;
            return true;
        }
        return false;
    }
}

