/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.slf4j;

import com.liferay.portal.kernel.log.Log;
import java.io.Serializable;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class LiferayLoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger,
Serializable {
    private final transient Log _log;

    public LiferayLoggerAdapter(Log log) {
        this._log = log;
        this._log.setLogWrapperClassName(LiferayLoggerAdapter.class.getName());
    }

    public LiferayLoggerAdapter(Log log, String name) {
        this(log);
        this.name = name;
    }

    public void debug(String message) {
        this._log.debug((Object)message);
    }

    public void debug(String format, Object argument) {
        if (this.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument);
            this._log.debug((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this._log.debug((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void debug(String format, Object argument1, Object argument2) {
        if (this.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument1, (Object)argument2);
            this._log.debug((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void debug(String message, Throwable throwable) {
        this._log.debug((Object)message, throwable);
    }

    public void error(String message) {
        this._log.error((Object)message);
    }

    public void error(String format, Object argument) {
        if (this.isErrorEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument);
            this._log.error((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this._log.error((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void error(String format, Object argument1, Object argument2) {
        if (this.isErrorEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument1, (Object)argument2);
            this._log.error((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void error(String message, Throwable throwable) {
        this._log.error((Object)message, throwable);
    }

    public void info(String message) {
        this._log.info((Object)message);
    }

    public void info(String format, Object argument) {
        if (this.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument);
            this._log.info((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this._log.info((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void info(String format, Object argument1, Object argument2) {
        if (this.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument1, (Object)argument2);
            this._log.info((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void info(String message, Throwable throwable) {
        this._log.info((Object)message, throwable);
    }

    public boolean isDebugEnabled() {
        return this._log.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this._log.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this._log.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this._log.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this._log.isWarnEnabled();
    }

    public void log(Marker marker, String fqcn, int level, String message, Object[] arguments, Throwable throwable) {
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)message, (Object[])arguments);
        if (level == 10) {
            this._log.debug((Object)formattingTuple.getMessage(), throwable);
        } else if (level == 40) {
            this._log.error((Object)formattingTuple.getMessage(), throwable);
        } else if (level == 0) {
            this._log.trace((Object)formattingTuple.getMessage(), throwable);
        } else if (level == 30) {
            this._log.warn((Object)formattingTuple.getMessage(), throwable);
        } else {
            this._log.info((Object)formattingTuple.getMessage(), throwable);
        }
    }

    public void trace(String message) {
        this._log.trace((Object)message);
    }

    public void trace(String format, Object argument) {
        if (this.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument);
            this._log.trace((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this._log.trace((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void trace(String format, Object argument1, Object argument2) {
        if (this.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument1, (Object)argument2);
            this._log.trace((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void trace(String message, Throwable throwable) {
        this._log.trace((Object)message, throwable);
    }

    public void warn(String message) {
        this._log.warn((Object)message);
    }

    public void warn(String format, Object argument) {
        if (this.isWarnEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument);
            this._log.warn((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
            this._log.warn((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void warn(String format, Object argument1, Object argument2) {
        if (this.isWarnEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format((String)format, (Object)argument1, (Object)argument2);
            this._log.warn((Object)formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    public void warn(String message, Throwable throwable) {
        this._log.warn((Object)message, throwable);
    }
}

