/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.slf4j;

import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.util.slf4j.LiferayLoggerAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class LiferayLoggerFactory
implements ILoggerFactory {
    private final Map<String, Logger> _loggers = new HashMap<String, Logger>();
    private final Lock _readLock;
    private final Lock _writeLock;

    public LiferayLoggerFactory() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this._readLock = readWriteLock.readLock();
        this._writeLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String name) {
        Object logger = null;
        this._readLock.lock();
        try {
            logger = this._loggers.get(name);
        }
        finally {
            this._readLock.unlock();
        }
        if (logger == null) {
            this._writeLock.lock();
            try {
                logger = new LiferayLoggerAdapter(LogFactoryUtil.getLog((String)name), name);
                this._loggers.put(name, (Logger)logger);
            }
            finally {
                this._writeLock.unlock();
            }
        }
        return logger;
    }
}

