/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.AddressSerializerUtil;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterTokenTransitionListener;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClusterMasterExecutorImpl
implements ClusterMasterExecutor {
    private static final String _LOCK_CLASS_NAME = ClusterMasterExecutorImpl.class.getName();
    private static Log _log = LogFactoryUtil.getLog(ClusterMasterExecutorImpl.class);
    private static volatile boolean _master;
    private ClusterEventListener _clusterEventListener;
    private ClusterExecutor _clusterExecutor;
    private Set<ClusterMasterTokenTransitionListener> _clusterMasterTokenTransitionListeners = new HashSet<ClusterMasterTokenTransitionListener>();
    private volatile boolean _enabled;
    private volatile String _localClusterNodeAddress;

    public void destroy() {
        block3: {
            if (!this._enabled) {
                return;
            }
            try {
                this._clusterExecutor.removeClusterEventListener(this._clusterEventListener);
                LockLocalServiceUtil.unlock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress);
            }
            catch (SystemException se) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to destroy the cluster master executor", (Throwable)se);
            }
        }
    }

    public <T> Future<T> executeOnMaster(MethodHandler methodHandler) throws SystemException {
        if (!this._enabled) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Executing on the local node because the cluster master executor is disabled");
            }
            try {
                return new LocalFuture<Object>(methodHandler.invoke(true));
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        String masterAddressString = this.getMasterAddressString();
        Address address = AddressSerializerUtil.deserialize((String)masterAddressString);
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)methodHandler, (Address[])new Address[]{address});
        try {
            FutureClusterResponses futureClusterResponses = this._clusterExecutor.execute(clusterRequest);
            return new RemoteFuture(address, futureClusterResponses);
        }
        catch (Exception e3) {
            throw new SystemException("Unable to execute on master " + address.getDescription(), (Throwable)e3);
        }
    }

    public void initialize() {
        if (!this._clusterExecutor.isEnabled()) {
            return;
        }
        try {
            this._localClusterNodeAddress = AddressSerializerUtil.serialize((Address)this._clusterExecutor.getLocalClusterNodeAddress());
            this._clusterEventListener = new ClusterMasterTokenClusterEventListener();
            this._clusterExecutor.addClusterEventListener(this._clusterEventListener);
            String masterAddressString = this.getMasterAddressString();
            this._enabled = true;
            this.notifyMasterTokenTransitionListeners(this._localClusterNodeAddress.equals(masterAddressString));
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to initialize cluster master executor", e2);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isMaster() {
        if (this.isEnabled()) {
            return _master;
        }
        return true;
    }

    public void registerClusterMasterTokenTransitionListener(ClusterMasterTokenTransitionListener clusterMasterTokenTransitionListener) {
        this._clusterMasterTokenTransitionListeners.add(clusterMasterTokenTransitionListener);
    }

    public void setClusterExecutor(ClusterExecutor clusterExecutor) {
        this._clusterExecutor = clusterExecutor;
    }

    public void setClusterMasterTokenTransitionListeners(Set<ClusterMasterTokenTransitionListener> clusterMasterTokenTransitionListeners) {
        this._clusterMasterTokenTransitionListeners.addAll(clusterMasterTokenTransitionListeners);
    }

    public void unregisterClusterMasterTokenTransitionListener(ClusterMasterTokenTransitionListener clusterMasterTokenTransitionListener) {
        this._clusterMasterTokenTransitionListeners.remove(clusterMasterTokenTransitionListener);
    }

    protected String getMasterAddressString() {
        String owner = null;
        while (true) {
            block7: {
                try {
                    Lock lock = null;
                    lock = owner == null ? LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, (String)this._localClusterNodeAddress) : LockLocalServiceUtil.lock((String)_LOCK_CLASS_NAME, (String)_LOCK_CLASS_NAME, owner, (String)this._localClusterNodeAddress);
                    owner = lock.getOwner();
                    Address address = AddressSerializerUtil.deserialize((String)owner);
                    if (this._clusterExecutor.isClusterNodeAlive(address)) {
                        break;
                    }
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)"Unable to acquire memory scheduler cluster lock", (Throwable)e2);
                }
            }
            if (!_log.isInfoEnabled()) continue;
            if (Validator.isNotNull(owner)) {
                _log.info((Object)("Lock currently held by " + owner));
            }
            _log.info((Object)"Reattempting to acquire memory scheduler cluster lock");
        }
        boolean master = this._localClusterNodeAddress.equals(owner);
        if (master == _master) {
            return owner;
        }
        _master = master;
        if (this._enabled) {
            this.notifyMasterTokenTransitionListeners(master);
        }
        return owner;
    }

    protected void notifyMasterTokenTransitionListeners(boolean masterTokenAcquired) {
        for (ClusterMasterTokenTransitionListener clusterMasterTokenTransitionListener : this._clusterMasterTokenTransitionListeners) {
            if (masterTokenAcquired) {
                clusterMasterTokenTransitionListener.masterTokenAcquired();
                continue;
            }
            clusterMasterTokenTransitionListener.masterTokenReleased();
        }
    }

    private class ClusterMasterTokenClusterEventListener
    implements ClusterEventListener {
        private ClusterMasterTokenClusterEventListener() {
        }

        public void processClusterEvent(ClusterEvent clusterEvent) {
            try {
                ClusterMasterExecutorImpl.this.getMasterAddressString();
            }
            catch (Exception e2) {
                _log.error((Object)"Unable to update the cluster master lock", (Throwable)e2);
            }
        }
    }

    private class LocalFuture<T>
    implements Future<T> {
        private final T _result;

        public LocalFuture(T result) {
            this._result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() {
            return this._result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) {
            return this._result;
        }
    }

    private class RemoteFuture<T>
    implements Future<T> {
        private final Address _address;
        private final FutureClusterResponses _futureClusterResponses;

        public RemoteFuture(Address address, FutureClusterResponses futureClusterResponses) {
            this._address = address;
            this._futureClusterResponses = futureClusterResponses;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this._futureClusterResponses.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this._futureClusterResponses.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this._futureClusterResponses.isDone();
        }

        @Override
        public T get() throws InterruptedException {
            ClusterNodeResponses clusterNodeResponses = this._futureClusterResponses.get();
            return (T)clusterNodeResponses.getClusterResponse(this._address);
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            ClusterNodeResponses clusterNodeResponses = this._futureClusterResponses.get(timeout, unit);
            return (T)clusterNodeResponses.getClusterResponse(this._address);
        }
    }
}

