/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.SimpleAction;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.upgrade.UpgradeProcessUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.util.ContentUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public abstract class BaseDefaultDDMStructureAction
extends SimpleAction {
    protected void addDDMStructures(long userId, long groupId, long classNameId, String fileName, ServiceContext serviceContext) throws Exception {
        Locale locale = PortalUtil.getSiteDefaultLocale((long)groupId);
        List<Element> structureElements = this.getDDMStructures(fileName, locale);
        for (Element structureElement : structureElements) {
            boolean dynamicStructure = GetterUtil.getBoolean((String)structureElement.elementText("dynamic-structure"));
            if (dynamicStructure) continue;
            String name = structureElement.elementText("name");
            String description = structureElement.elementText("description");
            String ddmStructureKey = name;
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (long)classNameId, (String)ddmStructureKey);
            if (ddmStructure != null) continue;
            Element structureElementRootElement = structureElement.element("root");
            String xsd = structureElementRootElement.asXML();
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            nameMap.put(locale, name);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(locale, description);
            Attribute defaultLocaleAttribute = structureElementRootElement.attribute("default-locale");
            Locale ddmStructureDefaultLocale = LocaleUtil.fromLanguageId((String)defaultLocaleAttribute.getValue());
            xsd = DDMXMLUtil.updateXMLDefaultLocale((String)xsd, (Locale)ddmStructureDefaultLocale, (Locale)locale);
            if (name.equals("Image Gallery Image") && !UpgradeProcessUtil.isCreateIGImageDocumentType()) continue;
            DDMStructureLocalServiceUtil.addStructure((long)userId, (long)groupId, (long)0L, (long)classNameId, (String)ddmStructureKey, nameMap, descriptionMap, (String)xsd, (String)"xml", (int)0, (ServiceContext)serviceContext);
        }
    }

    protected List<Element> getDDMStructures(String fileName, Locale locale) throws DocumentException {
        String xml = ContentUtil.get((String)("com/liferay/portal/events/dependencies/" + fileName));
        xml = StringUtil.replace((String)xml, (String)"[$LOCALE_DEFAULT$]", (String)locale.toString());
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        return rootElement.elements("structure");
    }

    protected String getDynamicDDMStructureXSD(String fileName, String dynamicDDMStructureName, Locale locale) throws DocumentException {
        List<Element> structureElements = this.getDDMStructures(fileName, locale);
        for (Element structureElement : structureElements) {
            String name;
            boolean dynamicStructure = GetterUtil.getBoolean((String)structureElement.elementText("dynamic-structure"));
            if (!dynamicStructure || !(name = structureElement.elementText("name")).equals(dynamicDDMStructureName)) continue;
            Element structureElementRootElement = structureElement.element("root");
            return structureElementRootElement.asXML();
        }
        return null;
    }
}

