/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.javadoc;

import com.liferay.portal.javadoc.JavadocUtil;
import com.liferay.portal.kernel.javadoc.BaseJavadoc;
import com.liferay.portal.kernel.javadoc.JavadocClass;
import com.liferay.portal.kernel.javadoc.JavadocManager;
import com.liferay.portal.kernel.javadoc.JavadocMethod;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@DoPrivileged
public class JavadocManagerImpl
implements JavadocManager {
    private static Log _log = LogFactoryUtil.getLog(JavadocManagerImpl.class);
    private Map<Class<?>, JavadocClass> _javadocClasses = new HashMap();
    private Map<Method, JavadocMethod> _javadocMethods = new HashMap<Method, JavadocMethod>();

    public void load(String servletContextName, ClassLoader classLoader) {
        Document document;
        if (!PropsValues.JAVADOC_MANAGER_ENABLED) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Loading Javadocs for \"" + servletContextName + '\"'));
        }
        if ((document = this.getDocument(classLoader)) == null) {
            return;
        }
        this.parseDocument(servletContextName, classLoader, document);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Loaded Javadocs for \"" + servletContextName + '\"'));
        }
    }

    public JavadocClass lookupJavadocClass(Class<?> clazz) {
        return this._javadocClasses.get(clazz);
    }

    public JavadocMethod lookupJavadocMethod(Method method) {
        block7: {
            JavadocMethod javadocMethod = this._javadocMethods.get(method);
            if (javadocMethod != null) {
                return javadocMethod;
            }
            Class<?> clazz = method.getDeclaringClass();
            String className = clazz.getName();
            if (!className.contains(".service.") || !className.endsWith("ServiceUtil")) {
                return null;
            }
            String implClassName = StringUtil.replace((String)className, (String[])new String[]{".service.", "ServiceUtil"}, (String[])new String[]{".service.impl.", "ServiceImpl"});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Attempting to load method from class " + implClassName + " instead of " + className));
            }
            try {
                Class<?> implClass = JavadocUtil.loadClass(clazz.getClassLoader(), implClassName);
                Method implMethod = implClass.getMethod(method.getName(), method.getParameterTypes());
                return this._javadocMethods.get(implMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to load method " + method.getName() + " from class " + implClassName));
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)("Unable to load implementation class " + implClassName));
            }
        }
        return null;
    }

    public void unload(String servletContextName) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unloading Javadocs for \"" + servletContextName + '\"'));
        }
        this.unload(servletContextName, this._javadocClasses.values());
        this.unload(servletContextName, this._javadocMethods.values());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unloaded Javadocs for \"" + servletContextName + '\"'));
        }
    }

    protected Document getDocument(ClassLoader classLoader) {
        InputStream inputStream = null;
        try {
            URL url = classLoader.getResource("META-INF/javadocs-rt.xml");
            if (url == null) {
                return null;
            }
            inputStream = url.openStream();
            Document document = SAXReaderUtil.read((InputStream)inputStream, (boolean)true);
            StreamUtil.cleanUp((InputStream)inputStream);
            return document;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        finally {
            StreamUtil.cleanUp(inputStream);
        }
        return null;
    }

    protected void parseDocument(String servletContextName, ClassLoader classLoader, Document document) {
        Element rootElement = document.getRootElement();
        List javadocElements = rootElement.elements("javadoc");
        for (Element javadocElement : javadocElements) {
            String type = javadocElement.elementText("type");
            Class<?> clazz = null;
            try {
                clazz = JavadocUtil.loadClass(classLoader, type);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to load class " + type));
                continue;
            }
            JavadocClass javadocClass = this.parseJavadocClass(servletContextName, javadocElement, clazz);
            this._javadocClasses.put(clazz, javadocClass);
            List methodElements = javadocElement.elements("method");
            for (Element methodElement : methodElements) {
                try {
                    JavadocMethod javadocMethod = this.parseJavadocMethod(servletContextName, clazz, methodElement);
                    this._javadocMethods.put(javadocMethod.getMethod(), javadocMethod);
                }
                catch (Exception exception) {
                    String methodName = methodElement.elementText("name");
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to load method " + methodName + " from class " + type));
                }
            }
        }
    }

    protected JavadocClass parseJavadocClass(String servletContextName, Element javadocElement, Class<?> clazz) {
        JavadocClass javadocClass = new JavadocClass(clazz);
        List authorElements = javadocElement.elements("author");
        String[] authors = new String[authorElements.size()];
        int i2 = 0;
        while (i2 < authorElements.size()) {
            Element authorElement = (Element)authorElements.get(i2);
            authors[i2] = authorElement.getText();
            ++i2;
        }
        javadocClass.setAuthors(authors);
        String comment = javadocElement.elementText("comment");
        javadocClass.setComment(comment);
        javadocClass.setServletContextName(servletContextName);
        return javadocClass;
    }

    protected JavadocMethod parseJavadocMethod(String servletContextName, Class<?> clazz, Element methodElement) throws Exception {
        String name = methodElement.elementText("name");
        List paramElements = methodElement.elements("param");
        Class[] parameterTypeClasses = new Class[paramElements.size()];
        String[] parameterComments = new String[paramElements.size()];
        int i2 = 0;
        while (i2 < paramElements.size()) {
            String parameterComment;
            Class<?> parametarTypeClass;
            Element paramElement = (Element)paramElements.get(i2);
            String parameterType = paramElement.elementText("type");
            parameterTypeClasses[i2] = parametarTypeClass = JavadocUtil.loadClass(clazz.getClassLoader(), parameterType);
            parameterComments[i2] = parameterComment = paramElement.elementText("comment");
            ++i2;
        }
        Method method = clazz.getDeclaredMethod(name, parameterTypeClasses);
        JavadocMethod javadocMethod = new JavadocMethod(method);
        String comment = methodElement.elementText("comment");
        javadocMethod.setComment(comment);
        javadocMethod.setParameterComments(parameterComments);
        Element returnElement = methodElement.element("return");
        if (returnElement != null) {
            String returnComment = returnElement.elementText("comment");
            javadocMethod.setReturnComment(returnComment);
        }
        javadocMethod.setServletContextName(servletContextName);
        List throwsElements = methodElement.elements("throws");
        String[] throwsComments = new String[throwsElements.size()];
        int i3 = 0;
        while (i3 < throwsElements.size()) {
            Element throwElement = (Element)throwsElements.get(i3);
            throwsComments[i3] = throwElement.elementText("comment");
            ++i3;
        }
        javadocMethod.setThrowsComments(throwsComments);
        return javadocMethod;
    }

    protected void unload(String servletContextName, Collection<? extends BaseJavadoc> collection) {
        Iterator<? extends BaseJavadoc> iterator = collection.iterator();
        while (iterator.hasNext()) {
            BaseJavadoc javadoc = iterator.next();
            if (!servletContextName.equals(javadoc.getServletContextName())) continue;
            iterator.remove();
        }
    }
}

