/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.DeletionSystemEventExporter;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionExporter;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.lar.PortletExporter;
import com.liferay.portal.lar.ThemeExporter;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutStagingHandler;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

public class LayoutExporter {
    public static final String SAME_GROUP_FRIENDLY_URL = "/[$SAME_GROUP_FRIENDLY_URL$]";
    private static Log _log = LogFactoryUtil.getLog(LayoutExporter.class);
    private DeletionSystemEventExporter _deletionSystemEventExporter = new DeletionSystemEventExporter();
    private PermissionExporter _permissionExporter = new PermissionExporter();
    private PortletExporter _portletExporter = new PortletExporter();
    private ThemeExporter _themeExporter = new ThemeExporter();

    public static List<Portlet> getDataSiteLevelPortlets(long companyId) throws Exception {
        List portlets = PortletLocalServiceUtil.getPortlets((long)companyId);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (!portlet.isActive()) {
                itr.remove();
                continue;
            }
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            if (portletDataHandler != null && portletDataHandler.isDataSiteLevel()) continue;
            itr.remove();
        }
        return portlets;
    }

    public static Map<String, Boolean> getExportPortletControlsMap(long companyId, String portletId, Map<String, String[]> parameterMap) throws Exception {
        return LayoutExporter.getExportPortletControlsMap(companyId, portletId, parameterMap, "layout-set");
    }

    public static Map<String, Boolean> getExportPortletControlsMap(long companyId, String portletId, Map<String, String[]> parameterMap, String type) throws Exception {
        boolean exportPortletConfiguration = MapUtil.getBoolean(parameterMap, (String)"PORTLET_CONFIGURATION");
        boolean exportPortletConfigurationAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_CONFIGURATION_ALL");
        boolean exportPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export portlet data " + exportPortletData));
            _log.debug((Object)("Export all portlet data " + exportPortletDataAll));
            _log.debug((Object)("Export portlet configuration " + exportPortletConfiguration));
        }
        boolean exportCurPortletData = exportPortletData;
        String rootPortletId = ExportImportHelperUtil.getExportableRootPortletId((long)companyId, (String)portletId);
        if (exportPortletDataAll) {
            exportCurPortletData = true;
        } else if (rootPortletId != null) {
            exportCurPortletData = exportPortletData && MapUtil.getBoolean(parameterMap, (String)("PORTLET_DATA_" + rootPortletId));
        }
        boolean exportCurPortletArchivedSetups = exportPortletConfiguration;
        boolean exportCurPortletConfiguration = exportPortletConfiguration;
        boolean exportCurPortletSetup = exportPortletConfiguration;
        boolean exportCurPortletUserPreferences = exportPortletConfiguration;
        if (exportPortletConfigurationAll || exportPortletConfiguration && type.equals("layout-prototype")) {
            exportCurPortletConfiguration = true;
            exportCurPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS_ALL");
            exportCurPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP_ALL");
            exportCurPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES_ALL");
        } else if (rootPortletId != null) {
            exportCurPortletConfiguration = exportPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)("PORTLET_CONFIGURATION_" + rootPortletId));
            exportCurPortletArchivedSetups = exportCurPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)("PORTLET_ARCHIVED_SETUPS_" + rootPortletId));
            exportCurPortletSetup = exportCurPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)("PORTLET_SETUP_" + rootPortletId));
            exportCurPortletUserPreferences = exportCurPortletConfiguration && MapUtil.getBoolean(parameterMap, (String)("PORTLET_USER_PREFERENCES_" + rootPortletId));
        }
        HashMap<String, Boolean> exportPortletControlsMap = new HashMap<String, Boolean>();
        exportPortletControlsMap.put("PORTLET_ARCHIVED_SETUPS", exportCurPortletArchivedSetups);
        exportPortletControlsMap.put("PORTLET_CONFIGURATION", exportCurPortletConfiguration);
        exportPortletControlsMap.put("PORTLET_DATA", exportCurPortletData);
        exportPortletControlsMap.put("PORTLET_SETUP", exportCurPortletSetup);
        exportPortletControlsMap.put("PORTLET_USER_PREFERENCES", exportCurPortletUserPreferences);
        return exportPortletControlsMap;
    }

    public static List<Portlet> getPortletDataHandlerPortlets(List<Layout> layouts) throws Exception {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        HashSet<String> rootPortletIds = new HashSet<String>();
        for (Layout layout : layouts) {
            if (!layout.isTypePortlet()) continue;
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            for (String portletId : layoutTypePortlet.getPortletIds()) {
                Object[] portletDataHandlerControls;
                PortletDataHandler portletDataHandler;
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
                if (portlet == null || rootPortletIds.contains(portlet.getRootPortletId()) || (portletDataHandler = portlet.getPortletDataHandlerInstance()) == null || !ArrayUtil.isNotEmpty((Object[])(portletDataHandlerControls = portletDataHandler.getExportConfigurationControls(layout.getCompanyId(), layout.getGroupId(), portlet, layout.getPlid(), layout.getPrivateLayout())))) continue;
                rootPortletIds.add(portlet.getRootPortletId());
                portlets.add(portlet);
            }
        }
        return portlets;
    }

    public static List<Portlet> getPortletDataHandlerPortlets(long groupId, boolean privateLayout) throws Exception {
        return LayoutExporter.getPortletDataHandlerPortlets(LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout));
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = this.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        finally {
            file.delete();
        }
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        try {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)true);
            File file = this.doExportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
            return file;
        }
        finally {
            ExportImportThreadLocal.setLayoutExportInProcess((boolean)false);
        }
    }

    protected File doExportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        boolean exportCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean exportIgnoreLastPublishDate = MapUtil.getBoolean(parameterMap, (String)"IGNORE_LAST_PUBLISH_DATE");
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean exportPortletDataAll = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA_ALL");
        boolean exportLogo = MapUtil.getBoolean(parameterMap, (String)"LOGO");
        boolean exportLayoutSetSettings = MapUtil.getBoolean(parameterMap, (String)"LAYOUT_SET_SETTINGS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + exportPermissions));
        }
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setSignedIn(false);
            serviceContext.setUserId(defaultUserId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        serviceContext.setAttribute("exporting", (Serializable)Boolean.TRUE);
        long layoutSetBranchId = MapUtil.getLong(parameterMap, (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        if (exportIgnoreLastPublishDate) {
            endDate = null;
            startDate = null;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LayoutCache layoutCache = new LayoutCache();
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)companyId, (long)groupId, parameterMap, (Date)startDate, (Date)endDate, (ZipWriter)zipWriter);
        portletDataContext.setPortetDataContextListener((PortletDataContextListener)new PortletDataContextListenerImpl(portletDataContext));
        portletDataContext.setPrivateLayout(privateLayout);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        portletDataContext.setExportDataRootElement(rootElement);
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Object[])LanguageUtil.getAvailableLocales((long)portletDataContext.getScopeGroupId())));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("company-id", String.valueOf(portletDataContext.getCompanyId()));
        headerElement.addAttribute("company-group-id", String.valueOf(portletDataContext.getCompanyGroupId()));
        headerElement.addAttribute("group-id", String.valueOf(groupId));
        headerElement.addAttribute("user-personal-site-group-id", String.valueOf(portletDataContext.getUserPersonalSiteGroupId()));
        headerElement.addAttribute("private-layout", String.valueOf(privateLayout));
        Group group = layoutSet.getGroup();
        String type = "layout-set";
        if (group.isLayoutPrototype()) {
            type = "layout-prototype";
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.getLayoutPrototype((long)group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutPrototype.getUuid());
        } else if (group.isLayoutSetPrototype()) {
            type = "layout-set-prototype";
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            headerElement.addAttribute("type-uuid", layoutSetPrototype.getUuid());
        }
        headerElement.addAttribute("type", type);
        LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.fetchLayoutSetBranch((long)layoutSetBranchId);
        if (exportLogo) {
            Image image = null;
            image = layoutSetBranch != null ? ImageLocalServiceUtil.getImage((long)layoutSetBranch.getLogoId()) : ImageLocalServiceUtil.getImage((long)layoutSet.getLogoId());
            if (image != null && image.getTextObj() != null) {
                String logoPath = ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext);
                logoPath = String.valueOf(logoPath) + "/logo";
                headerElement.addAttribute("logo-path", logoPath);
                portletDataContext.addZipEntry(logoPath, image.getTextObj());
            }
        }
        Element missingReferencesElement = rootElement.addElement("missing-references");
        portletDataContext.setMissingReferencesElement(missingReferencesElement);
        if (layoutSetBranch != null) {
            this._themeExporter.exportTheme(portletDataContext, layoutSetBranch);
        } else {
            this._themeExporter.exportTheme(portletDataContext, layoutSet);
        }
        if (exportLayoutSetSettings) {
            Element settingsElement = headerElement.addElement("settings");
            if (layoutSetBranch != null) {
                settingsElement.addCDATA(layoutSetBranch.getSettings());
            } else {
                settingsElement.addCDATA(layoutSet.getSettings());
            }
        }
        LinkedHashMap<String, Object[]> portletIds = new LinkedHashMap<String, Object[]>();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        for (Portlet portlet : LayoutExporter.getDataSiteLevelPortlets(companyId)) {
            String portletId = portlet.getRootPortletId();
            if (!group.isStagedPortlet(portletId)) continue;
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                portletDataHandler.prepareManifestSummary(portletDataContext);
            }
            portletIds.put(PortletPermissionUtil.getPrimaryKey((long)0L, (String)portletId), new Object[]{portletId, 0L, groupId, "", ""});
            if (!portlet.isScopeable()) continue;
            for (Layout layout : layouts) {
                if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId()) && ArrayUtil.isNotEmpty((long[])layoutIds) || !layout.isTypePortlet() || !layout.hasScopeGroup()) continue;
                Group scopeGroup = layout.getScopeGroup();
                portletIds.put(PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portlet.getPortletId()), new Object[]{portlet.getPortletId(), layout.getPlid(), scopeGroup.getGroupId(), "", layout.getUuid()});
            }
        }
        portletDataContext.addDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Layout.class)});
        Element layoutsElement = portletDataContext.getExportDataGroupElement(Layout.class);
        String layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
        if (!group.isStaged() && Validator.isNotNull((String)layoutSetPrototypeUuid)) {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)companyId);
            layoutsElement.addAttribute("layout-set-prototype-uuid", layoutSetPrototypeUuid);
            layoutsElement.addAttribute("layout-set-prototype-name", layoutSetPrototype.getName(LocaleUtil.getDefault()));
        }
        for (Layout layout : layouts) {
            this.exportLayout(portletDataContext, layoutIds, portletIds, layout);
        }
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            Set portletIdsSet = portletIds.keySet();
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"layout", (String[])portletIdsSet.toArray(new String[portletIdsSet.size()]), (ManifestSummary)manifestSummary);
            manifestSummary.resetCounters();
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        Element portletsElement = rootElement.addElement("portlets");
        for (Map.Entry portletIdsEntry : portletIds.entrySet()) {
            Object[] portletObjects = (Object[])portletIdsEntry.getValue();
            String portletId = null;
            long plid = 0L;
            long scopeGroupId = 0L;
            String scopeType = "";
            String scopeLayoutUuid = null;
            if (portletObjects.length == 4) {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[3];
            } else {
                portletId = (String)((Object[])portletIdsEntry.getValue())[0];
                plid = (Long)((Object[])portletIdsEntry.getValue())[1];
                scopeGroupId = (Long)((Object[])portletIdsEntry.getValue())[2];
                scopeType = (String)((Object[])portletIdsEntry.getValue())[3];
                scopeLayoutUuid = (String)((Object[])portletIdsEntry.getValue())[4];
            }
            Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
            if (layout == null) {
                layout = new LayoutImpl();
                layout.setGroupId(groupId);
                layout.setCompanyId(companyId);
            }
            portletDataContext.setPlid(plid);
            portletDataContext.setOldPlid(plid);
            portletDataContext.setScopeGroupId(scopeGroupId);
            portletDataContext.setScopeType(scopeType);
            portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            Map<String, Boolean> exportPortletControlsMap = LayoutExporter.getExportPortletControlsMap(companyId, portletId, parameterMap, type);
            this._portletExporter.exportPortlet(portletDataContext, layoutCache, portletId, layout, portletsElement, exportPermissions, exportPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), exportPortletControlsMap.get("PORTLET_DATA"), exportPortletControlsMap.get("PORTLET_SETUP"), exportPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        this.exportAssetCategories(portletDataContext, exportPortletDataAll, exportCategories, group.isCompany());
        this._portletExporter.exportAssetLinks(portletDataContext);
        this._portletExporter.exportAssetTags(portletDataContext);
        this._portletExporter.exportComments(portletDataContext);
        this._portletExporter.exportExpandoTables(portletDataContext);
        this._portletExporter.exportLocks(portletDataContext);
        this._deletionSystemEventExporter.exportDeletionSystemEvents(portletDataContext);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        this._portletExporter.exportRatingsEntries(portletDataContext, rootElement);
        ExportImportHelperUtil.writeManifestSummary((Document)document, (ManifestSummary)portletDataContext.getManifestSummary());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting layouts takes " + stopWatch.getTime() + " ms"));
        }
        portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        return zipWriter.getFile();
    }

    protected void exportAssetCategories(PortletDataContext portletDataContext, boolean exportPortletDataAll, boolean exportCategories, boolean companyGroup) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("categories-hierarchy");
        if (exportPortletDataAll || exportCategories || companyGroup) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Export categories");
            }
            Element assetVocabulariesElement = rootElement.addElement("vocabularies");
            List assetVocabularies = AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)portletDataContext.getGroupId());
            for (AssetVocabulary assetVocabulary : assetVocabularies) {
                this._portletExporter.exportAssetVocabulary(portletDataContext, assetVocabulariesElement, assetVocabulary);
            }
            Element categoriesElement = rootElement.addElement("categories");
            List assetCategories = AssetCategoryUtil.findByGroupId((long)portletDataContext.getGroupId());
            for (AssetCategory assetCategory : assetCategories) {
                this._portletExporter.exportAssetCategory(portletDataContext, assetVocabulariesElement, categoriesElement, assetCategory);
            }
        }
        this._portletExporter.exportAssetCategories(portletDataContext, rootElement);
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/categories-hierarchy.xml", document.formattedString());
    }

    protected void exportLayout(PortletDataContext portletDataContext, long[] layoutIds, Map<String, Object[]> portletIds, Layout layout) throws Exception {
        if (!ArrayUtil.contains((long[])layoutIds, (long)layout.getLayoutId()) && ArrayUtil.isNotEmpty((long[])layoutIds)) {
            Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
            layoutElement.addAttribute("action", "skip");
            return;
        }
        boolean exportLAR = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"exportLAR");
        if (!exportLAR && LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            long layoutSetBranchId = MapUtil.getLong((Map)portletDataContext.getParameterMap(), (String)"layoutSetBranchId");
            if (layoutSetBranchId <= 0L) {
                return;
            }
            LayoutRevision layoutRevision = LayoutRevisionLocalServiceUtil.fetchLayoutRevision((long)layoutSetBranchId, (boolean)true, (long)layout.getPlid());
            if (layoutRevision == null) {
                return;
            }
            LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
            layoutStagingHandler.setLayoutRevision(layoutRevision);
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout);
        if (!layout.isSupportsEmbeddedPortlets()) {
            return;
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        for (Portlet portlet : layoutTypePortlet.getAllPortlets(false)) {
            String portletId = portlet.getPortletId();
            PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
            String scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
            String scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
            long scopeGroupId = portletDataContext.getScopeGroupId();
            if (Validator.isNotNull((String)scopeType)) {
                Group scopeGroup = null;
                if (scopeType.equals("company")) {
                    scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)layout.getCompanyId());
                } else if (scopeType.equals("layout")) {
                    Layout scopeLayout = null;
                    scopeLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)scopeLayoutUuid, (long)portletDataContext.getGroupId(), (boolean)portletDataContext.isPrivateLayout());
                    if (scopeLayout == null) continue;
                    scopeGroup = scopeLayout.getScopeGroup();
                } else {
                    throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
                }
                if (scopeGroup != null) {
                    scopeGroupId = scopeGroup.getGroupId();
                }
            }
            String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            portletIds.put(key, new Object[]{portletId, layout.getPlid(), scopeGroupId, scopeType, scopeLayoutUuid});
        }
    }
}

