/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LayoutImportException;
import com.liferay.portal.NoSuchPortletPreferencesException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataHandlerStatusMessageSenderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.lar.DeletionSystemEventExporter;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.LayoutExporter;
import com.liferay.portal.lar.PermissionExporter;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletItem;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletItemLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryProperty;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyUtil;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.util.xml.DocUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.time.StopWatch;

public class PortletExporter {
    private static Log _log = LogFactoryUtil.getLog(PortletExporter.class);
    private DeletionSystemEventExporter _deletionSystemEventExporter = new DeletionSystemEventExporter();
    private PermissionExporter _permissionExporter = new PermissionExporter();

    public void exportPortletData(PortletDataContext portletDataContext, Portlet portlet, Layout layout, PortletPreferences jxPortletPreferences, Element parentElement) throws Exception {
        boolean staged;
        if (portlet == null) {
            return;
        }
        PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
        if (portletDataHandler == null || portletDataHandler.isDataPortletInstanceLevel()) {
            return;
        }
        String portletId = portlet.getPortletId();
        Group liveGroup = layout.getGroup();
        if (liveGroup.isStagingGroup()) {
            liveGroup = liveGroup.getLiveGroup();
        }
        if (!(staged = liveGroup.isStagedPortlet(portlet.getRootPortletId())) && ExportImportThreadLocal.isLayoutExportInProcess()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because it is configured not to be staged"));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Exporting data for " + portletId));
        }
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getPortletPath((PortletDataContext)portletDataContext, (String)portletId));
        sb.append("/");
        if (portlet.isPreferencesUniquePerLayout()) {
            sb.append(layout.getPlid());
        } else {
            sb.append(portletDataContext.getScopeGroupId());
        }
        sb.append("/portlet-data.xml");
        String path = sb.toString();
        Element portletDataElement = parentElement.addElement("portlet-data");
        portletDataElement.addAttribute("path", path);
        if (portletDataContext.isPathProcessed(path)) {
            return;
        }
        String data = null;
        long groupId = portletDataContext.getGroupId();
        portletDataContext.setGroupId(portletDataContext.getScopeGroupId());
        portletDataContext.clearScopedPrimaryKeys();
        try {
            try {
                data = portletDataHandler.exportData(portletDataContext, portletId, jxPortletPreferences);
            }
            catch (PortletDataException pde) {
                throw pde;
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        finally {
            portletDataContext.setGroupId(groupId);
        }
        if (Validator.isNull((String)data)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not exporting data for " + portletId + " because null data was returned"));
            }
            return;
        }
        portletDataContext.addZipEntry(path, data);
        Date endDate = portletDataContext.getEndDate();
        boolean updateLastPublishDate = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"UPDATE_LAST_PUBLISH_DATE");
        if (updateLastPublishDate) {
            StagingUtil.updateLastPublishDate((String)portletId, (PortletPreferences)jxPortletPreferences, (Date)endDate);
        }
    }

    @Deprecated
    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        File file = this.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        try {
            ExportImportThreadLocal.setPortletExportInProcess((boolean)true);
            File file = this.doExportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
            return file;
        }
        finally {
            ExportImportThreadLocal.setPortletExportInProcess((boolean)false);
        }
    }

    protected File doExportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws Exception {
        boolean exportPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export permissions " + exportPermissions));
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LayoutCache layoutCache = new LayoutCache();
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        if (!(layout.isTypeControlPanel() || layout.isTypePanel() || layout.isTypePortlet())) {
            throw new LayoutImportException("Layout type " + layout.getType() + " is not valid");
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(layout.getCompanyId());
            serviceContext.setSignedIn(false);
            long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)layout.getCompanyId());
            serviceContext.setUserId(defaultUserId);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        long layoutSetBranchId = MapUtil.getLong(parameterMap, (String)"layoutSetBranchId");
        serviceContext.setAttribute("layoutSetBranchId", (Serializable)Long.valueOf(layoutSetBranchId));
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        long scopeGroupId = groupId;
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        String scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
        String scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
        if (Validator.isNotNull((String)scopeType)) {
            Group scopeGroup = null;
            if (scopeType.equals("company")) {
                scopeGroup = GroupLocalServiceUtil.getCompanyGroup((long)layout.getCompanyId());
            } else if (Validator.isNotNull((String)scopeLayoutUuid)) {
                scopeGroup = layout.getScopeGroup();
            }
            if (scopeGroup != null) {
                scopeGroupId = scopeGroup.getGroupId();
            }
        }
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)layout.getCompanyId(), (long)scopeGroupId, parameterMap, (Date)startDate, (Date)endDate, (ZipWriter)zipWriter);
        portletDataContext.setPortetDataContextListener((PortletDataContextListener)new PortletDataContextListenerImpl(portletDataContext));
        portletDataContext.setPlid(plid);
        portletDataContext.setOldPlid(plid);
        portletDataContext.setScopeType(scopeType);
        portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        Element headerElement = rootElement.addElement("header");
        headerElement.addAttribute("available-locales", StringUtil.merge((Object[])LanguageUtil.getAvailableLocales((long)PortalUtil.getSiteGroupId((long)portletDataContext.getScopeGroupId()))));
        headerElement.addAttribute("build-number", String.valueOf(ReleaseInfo.getBuildNumber()));
        headerElement.addAttribute("export-date", Time.getRFC822());
        if (portletDataContext.hasDateRange()) {
            headerElement.addAttribute("start-date", String.valueOf(portletDataContext.getStartDate()));
            headerElement.addAttribute("end-date", String.valueOf(portletDataContext.getEndDate()));
        }
        headerElement.addAttribute("type", "portlet");
        headerElement.addAttribute("company-id", String.valueOf(portletDataContext.getCompanyId()));
        headerElement.addAttribute("company-group-id", String.valueOf(portletDataContext.getCompanyGroupId()));
        headerElement.addAttribute("group-id", String.valueOf(scopeGroupId));
        headerElement.addAttribute("user-personal-site-group-id", String.valueOf(portletDataContext.getUserPersonalSiteGroupId()));
        headerElement.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
        headerElement.addAttribute("root-portlet-id", PortletConstants.getRootPortletId((String)portletId));
        Element missingReferencesElement = rootElement.addElement("missing-references");
        portletDataContext.setMissingReferencesElement(missingReferencesElement);
        Map<String, Boolean> exportPortletControlsMap = LayoutExporter.getExportPortletControlsMap(layout.getCompanyId(), portletId, parameterMap);
        this.exportPortlet(portletDataContext, layoutCache, portletId, layout, rootElement, exportPermissions, exportPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS"), exportPortletControlsMap.get("PORTLET_DATA"), exportPortletControlsMap.get("PORTLET_SETUP"), exportPortletControlsMap.get("PORTLET_USER_PREFERENCES"));
        this.exportAssetCategories(portletDataContext);
        this.exportAssetLinks(portletDataContext);
        this.exportAssetTags(portletDataContext);
        this.exportComments(portletDataContext);
        this.exportExpandoTables(portletDataContext);
        this.exportLocks(portletDataContext);
        this._deletionSystemEventExporter.exportDeletionSystemEvents(portletDataContext);
        if (exportPermissions) {
            this._permissionExporter.exportPortletDataPermissions(portletDataContext);
        }
        this.exportRatingsEntries(portletDataContext, rootElement);
        ExportImportHelperUtil.writeManifestSummary((Document)document, (ManifestSummary)portletDataContext.getManifestSummary());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Exporting portlet took " + stopWatch.getTime() + " ms"));
        }
        try {
            portletDataContext.addZipEntry("/manifest.xml", document.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return zipWriter.getFile();
    }

    protected void exportAssetCategories(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("categories-hierarchy");
        this.exportAssetCategories(portletDataContext, rootElement);
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/categories-hierarchy.xml", document.formattedString());
    }

    protected void exportAssetCategories(PortletDataContext portletDataContext, Element rootElement) throws Exception {
        Element assetVocabulariesElement;
        Element assetCategoriesElement;
        Element assetsElement = rootElement.element("assets");
        if (assetsElement == null) {
            assetsElement = rootElement.addElement("assets");
        }
        if ((assetCategoriesElement = rootElement.element("categories")) == null) {
            assetCategoriesElement = rootElement.addElement("categories");
        }
        if ((assetVocabulariesElement = rootElement.element("vocabularies")) == null) {
            assetVocabulariesElement = rootElement.addElement("vocabularies");
        }
        Map assetCategoryUuidsMap = portletDataContext.getAssetCategoryUuidsMap();
        for (Map.Entry entry : assetCategoryUuidsMap.entrySet()) {
            String[] assetCategoryEntryParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String className = assetCategoryEntryParts[0];
            String classPK = assetCategoryEntryParts[1];
            Element assetElement = assetsElement.addElement("asset");
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("class-pk", classPK);
            assetElement.addAttribute("category-uuids", StringUtil.merge((Object[])((Object[])entry.getValue())));
            List assetCategories = AssetCategoryLocalServiceUtil.getCategories((String)className, (long)GetterUtil.getLong((String)classPK));
            for (AssetCategory assestCategory : assetCategories) {
                this.exportAssetCategory(portletDataContext, assetVocabulariesElement, assetCategoriesElement, assestCategory);
            }
        }
    }

    protected void exportAssetCategory(PortletDataContext portletDataContext, Element assetVocabulariesElement, Element assetCategoriesElement, AssetCategory assetCategory) throws Exception {
        String path;
        this.exportAssetVocabulary(portletDataContext, assetVocabulariesElement, assetCategory.getVocabularyId());
        if (assetCategory.getParentCategoryId() != 0L) {
            this.exportAssetCategory(portletDataContext, assetVocabulariesElement, assetCategoriesElement, assetCategory.getParentCategoryId());
        }
        if (!portletDataContext.isPathNotProcessed(path = this.getAssetCategoryPath(portletDataContext, assetCategory.getCategoryId()))) {
            return;
        }
        Element assetCategoryElement = assetCategoriesElement.addElement("category");
        assetCategoryElement.addAttribute("path", path);
        assetCategory.setUserUuid(assetCategory.getUserUuid());
        portletDataContext.addZipEntry(path, (Object)assetCategory);
        List assetCategoryProperties = AssetCategoryPropertyLocalServiceUtil.getCategoryProperties((long)assetCategory.getCategoryId());
        for (AssetCategoryProperty assetCategoryProperty : assetCategoryProperties) {
            Element propertyElement = assetCategoryElement.addElement("property");
            propertyElement.addAttribute("userUuid", assetCategoryProperty.getUserUuid());
            propertyElement.addAttribute("key", assetCategoryProperty.getKey());
            propertyElement.addAttribute("value", assetCategoryProperty.getValue());
        }
        portletDataContext.addPermissions(AssetCategory.class, assetCategory.getCategoryId());
        portletDataContext.cleanUpMissingReferences((ClassedModel)assetCategory);
    }

    protected void exportAssetCategory(PortletDataContext portletDataContext, Element assetVocabulariesElement, Element assetCategoriesElement, long assetCategoryId) throws Exception {
        AssetCategory assetCategory = AssetCategoryUtil.fetchByPrimaryKey((long)assetCategoryId);
        if (assetCategory != null) {
            this.exportAssetCategory(portletDataContext, assetVocabulariesElement, assetCategoriesElement, assetCategory);
        }
    }

    protected void exportAssetLinks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("links");
        Map assetLinksMap = portletDataContext.getAssetLinksMap();
        for (Map.Entry entry : assetLinksMap.entrySet()) {
            String[] assetLinkNameParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            List assetLinks = (List)entry.getValue();
            String sourceAssetEntryUuid = assetLinkNameParts[0];
            Element assetElement = rootElement.addElement("asset-link-group");
            assetElement.addAttribute("source-uuid", sourceAssetEntryUuid);
            for (AssetLink assetLink : assetLinks) {
                String path = this.getAssetLinkPath(portletDataContext, assetLink.getLinkId());
                if (!portletDataContext.isPathNotProcessed(path)) {
                    return;
                }
                Element assetLinkElement = assetElement.addElement("asset-link");
                assetLinkElement.addAttribute("path", path);
                AssetEntry targetAssetEntry = AssetEntryLocalServiceUtil.fetchAssetEntry((long)assetLink.getEntryId2());
                assetLinkElement.addAttribute("target-uuid", targetAssetEntry.getClassUuid());
                portletDataContext.addZipEntry(path, (Object)assetLink);
            }
        }
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/links.xml", document.formattedString());
    }

    protected void exportAssetTag(PortletDataContext portletDataContext, AssetTag assetTag, Element assetTagsElement) throws PortalException, SystemException {
        String path = this.getAssetTagPath(portletDataContext, assetTag.getTagId());
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element assetTagElement = assetTagsElement.addElement("tag");
        assetTagElement.addAttribute("path", path);
        assetTag.setUserUuid(assetTag.getUserUuid());
        portletDataContext.addZipEntry(path, (Object)assetTag);
        List assetTagProperties = AssetTagPropertyLocalServiceUtil.getTagProperties((long)assetTag.getTagId());
        for (AssetTagProperty assetTagProperty : assetTagProperties) {
            Element propertyElement = assetTagElement.addElement("property");
            propertyElement.addAttribute("key", assetTagProperty.getKey());
            propertyElement.addAttribute("value", assetTagProperty.getValue());
        }
        portletDataContext.addPermissions(AssetTag.class, assetTag.getTagId());
    }

    protected void exportAssetTags(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("tags");
        Map assetTagNamesMap = portletDataContext.getAssetTagNamesMap();
        if (assetTagNamesMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : assetTagNamesMap.entrySet()) {
            String[] assetTagNameParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String className = assetTagNameParts[0];
            String classPK = assetTagNameParts[1];
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("class-pk", classPK);
            assetElement.addAttribute("tags", StringUtil.merge((Object[])((Object[])entry.getValue())));
            String[] stringArray = (String[])entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    String tagName = stringArray[n2];
                    try {
                        AssetTag assetTag = AssetTagLocalServiceUtil.getTag((long)portletDataContext.getScopeGroupId(), (String)tagName);
                        this.exportAssetTag(portletDataContext, assetTag, rootElement);
                    }
                    catch (NoSuchTagException noSuchTagException) {
                        if (!_log.isWarnEnabled()) break block5;
                        _log.warn((Object)("Unable to export tag " + tagName));
                    }
                }
                ++n2;
            }
        }
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/tags.xml", document.formattedString());
    }

    protected void exportAssetVocabulary(PortletDataContext portletDataContext, Element assetVocabulariesElement, AssetVocabulary assetVocabulary) throws Exception {
        String path = this.getAssetVocabulariesPath(portletDataContext, assetVocabulary.getVocabularyId());
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element assetVocabularyElement = assetVocabulariesElement.addElement("vocabulary");
        assetVocabularyElement.addAttribute("path", path);
        assetVocabulary.setUserUuid(assetVocabulary.getUserUuid());
        portletDataContext.addZipEntry(path, (Object)assetVocabulary);
        portletDataContext.addPermissions(AssetVocabulary.class, assetVocabulary.getVocabularyId());
        portletDataContext.cleanUpMissingReferences((ClassedModel)assetVocabulary);
    }

    protected void exportAssetVocabulary(PortletDataContext portletDataContext, Element assetVocabulariesElement, long assetVocabularyId) throws Exception {
        AssetVocabulary assetVocabulary = AssetVocabularyUtil.findByPrimaryKey((long)assetVocabularyId);
        this.exportAssetVocabulary(portletDataContext, assetVocabulariesElement, assetVocabulary);
    }

    protected void exportComments(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("comments");
        Map commentsMap = portletDataContext.getComments();
        for (Map.Entry entry : commentsMap.entrySet()) {
            String[] commentParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String className = commentParts[0];
            String classPK = commentParts[1];
            String commentsPath = this.getCommentsPath(portletDataContext, className, classPK);
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("path", commentsPath);
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("class-pk", classPK);
            List mbMessages = (List)entry.getValue();
            for (MBMessage mbMessage : mbMessages) {
                User user;
                String commentPath = this.getCommentPath(portletDataContext, className, classPK, mbMessage);
                if (!portletDataContext.isPathNotProcessed(commentPath) || (user = UserLocalServiceUtil.fetchUser((long)mbMessage.getUserId())) == null) continue;
                portletDataContext.addZipEntry(commentPath, (Object)mbMessage);
                MBDiscussion mbDiscussion = MBDiscussionLocalServiceUtil.getDiscussion((String)className, (long)GetterUtil.getLong((String)classPK));
                portletDataContext.addReferenceElement((ClassedModel)mbDiscussion, assetElement, (ClassedModel)user, "weak", true);
            }
        }
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/comments.xml", document.formattedString());
    }

    protected void exportExpandoTables(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("expando-tables");
        Map expandoColumnsMap = portletDataContext.getExpandoColumns();
        for (Map.Entry entry : expandoColumnsMap.entrySet()) {
            String className = (String)entry.getKey();
            Element expandoTableElement = rootElement.addElement("expando-table");
            expandoTableElement.addAttribute("class-name", className);
            List expandoColumns = (List)entry.getValue();
            for (ExpandoColumn expandoColumn : expandoColumns) {
                Element expandoColumnElement = expandoTableElement.addElement("expando-column");
                expandoColumnElement.addAttribute("column-id", String.valueOf(expandoColumn.getColumnId()));
                expandoColumnElement.addAttribute("name", expandoColumn.getName());
                expandoColumnElement.addAttribute("type", String.valueOf(expandoColumn.getType()));
                DocUtil.add((Element)expandoColumnElement, (String)"default-data", (String)expandoColumn.getDefaultData());
                Element typeSettingsElement = expandoColumnElement.addElement("type-settings");
                UnicodeProperties typeSettingsProperties = expandoColumn.getTypeSettingsProperties();
                typeSettingsElement.addCDATA(typeSettingsProperties.toString());
            }
        }
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/expando-tables.xml", document.formattedString());
    }

    protected void exportLocks(PortletDataContext portletDataContext) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("locks");
        Map locksMap = portletDataContext.getLocks();
        for (Map.Entry entry : locksMap.entrySet()) {
            Lock lock = (Lock)entry.getValue();
            String entryKey = (String)entry.getKey();
            int pos = entryKey.indexOf(35);
            String className = entryKey.substring(0, pos);
            String key = entryKey.substring(pos + 1);
            String path = this.getLockPath(portletDataContext, className, key, lock);
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("path", path);
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("key", key);
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            portletDataContext.addZipEntry(path, (Object)lock);
        }
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/locks.xml", document.formattedString());
    }

    protected void exportPortlet(PortletDataContext portletDataContext, LayoutCache layoutCache, String portletId, Layout layout, Element parentElement, boolean exportPermissions, boolean exportPortletArchivedSetups, boolean exportPortletData, boolean exportPortletSetup, boolean exportPortletUserPreferences) throws Exception {
        Portlet portlet;
        long plid = 0L;
        long layoutId = 0L;
        if (layout != null) {
            plid = layout.getPlid();
            layoutId = layout.getLayoutId();
        }
        if ((portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId)) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Do not export portlet " + portletId + " because the portlet does not exist"));
            }
            return;
        }
        if (!portlet.isInstanceable() && !portlet.isPreferencesUniquePerLayout() && portletDataContext.hasNotUniquePerLayout(portletId)) {
            return;
        }
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        portletDataContext.setRootPortletId(rootPortletId);
        if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
            PortletDataContext clonedPortletDataContext = PortletDataContextFactoryUtil.clonePortletDataContext((PortletDataContext)portletDataContext);
            ManifestSummary manifestSummary = clonedPortletDataContext.getManifestSummary();
            manifestSummary.resetCounters();
            PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
            portletDataHandler.prepareManifestSummary(clonedPortletDataContext);
            PortletDataHandlerStatusMessageSenderUtil.sendStatusMessage((String)"portlet", (String)portletId, (ManifestSummary)manifestSummary);
        }
        Document document = SAXReaderUtil.createDocument();
        Element portletElement = document.addElement("portlet");
        portletElement.addAttribute("portlet-id", portletId);
        portletElement.addAttribute("root-portlet-id", rootPortletId);
        portletElement.addAttribute("old-plid", String.valueOf(plid));
        portletElement.addAttribute("scope-layout-type", portletDataContext.getScopeType());
        portletElement.addAttribute("scope-layout-uuid", portletDataContext.getScopeLayoutUuid());
        portletElement.addAttribute("private-layout", String.valueOf(layout.isPrivateLayout()));
        if (exportPortletData) {
            PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletId);
            this.exportPortletData(portletDataContext, portlet, layout, jxPortletPreferences, portletElement);
        }
        if (exportPortletSetup) {
            this.exportPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), 1, false, layout, plid, portlet.getRootPortletId(), portletElement);
            this.exportPortletPreferences(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, layout, 0L, portlet.getRootPortletId(), portletElement);
            this.exportPortletPreferences(portletDataContext, 0L, 3, false, layout, plid, portletId, portletElement);
        }
        if (exportPortletUserPreferences) {
            List portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferences((int)4, (long)plid, (String)portletId);
            for (com.liferay.portal.model.PortletPreferences portletPreferences : portletPreferencesList) {
                boolean defaultUser = false;
                if (portletPreferences.getOwnerId() == 0L) {
                    defaultUser = true;
                }
                this.exportPortletPreferences(portletDataContext, portletPreferences.getOwnerId(), 4, defaultUser, layout, plid, portletId, portletElement);
            }
            try {
                com.liferay.portal.model.PortletPreferences groupPortletPreferences = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)portletDataContext.getScopeGroupId(), (int)2, (long)0L, (String)portlet.getRootPortletId());
                this.exportPortletPreference(portletDataContext, portletDataContext.getScopeGroupId(), 2, false, groupPortletPreferences, portlet.getRootPortletId(), 0L, portletElement);
            }
            catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {}
        }
        if (exportPortletArchivedSetups) {
            List portletItems = PortletItemLocalServiceUtil.getPortletItems((long)portletDataContext.getGroupId(), (String)rootPortletId, (String)com.liferay.portal.model.PortletPreferences.class.getName());
            for (PortletItem portletItem : portletItems) {
                this.exportPortletPreferences(portletDataContext, portletItem.getPortletItemId(), 5, false, null, plid, portletItem.getPortletId(), portletElement);
            }
        }
        if (exportPermissions) {
            this._permissionExporter.exportPortletPermissions(portletDataContext, layoutCache, portletId, layout, portletElement);
        }
        StringBundler pathSB = new StringBundler(4);
        pathSB.append(ExportImportPathUtil.getPortletPath((PortletDataContext)portletDataContext, (String)portletId));
        pathSB.append("/");
        pathSB.append(plid);
        pathSB.append("/portlet.xml");
        String path = pathSB.toString();
        Element element = parentElement.addElement("portlet");
        element.addAttribute("portlet-id", portletId);
        element.addAttribute("layout-id", String.valueOf(layoutId));
        element.addAttribute("path", path);
        element.addAttribute("portlet-data", String.valueOf(exportPortletData));
        StringBundler configurationOptionsSB = new StringBundler(6);
        if (exportPortletSetup) {
            configurationOptionsSB.append("setup");
            configurationOptionsSB.append(",");
        }
        if (exportPortletArchivedSetups) {
            configurationOptionsSB.append("archived-setups");
            configurationOptionsSB.append(",");
        }
        if (exportPortletUserPreferences) {
            configurationOptionsSB.append("user-preferences");
            configurationOptionsSB.append(",");
        }
        if (configurationOptionsSB.index() > 0) {
            configurationOptionsSB.setIndex(configurationOptionsSB.index() - 1);
        }
        element.addAttribute("portlet-configuration", configurationOptionsSB.toString());
        if (portletDataContext.isPathNotProcessed(path)) {
            block22: {
                try {
                    portletDataContext.addZipEntry(path, document.formattedString());
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block22;
                    _log.warn((Object)ioe.getMessage());
                }
            }
            portletDataContext.addPrimaryKey(String.class, path);
        }
        portletDataContext.setRootPortletId("");
    }

    protected void exportPortletPreference(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, com.liferay.portal.model.PortletPreferences portletPreferences, String portletId, long plid, Element parentElement) throws Exception {
        String preferencesXML = portletPreferences.getPreferences();
        if (Validator.isNull((String)preferencesXML)) {
            preferencesXML = "<portlet-preferences />";
        }
        PortletPreferences jxPortletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)preferencesXML);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)portletDataContext.getCompanyId(), (String)portletId);
        Element portletPreferencesElement = parentElement.addElement("portlet-preferences");
        if (portlet != null && portlet.getPortletDataHandlerInstance() != null) {
            Element exportDataRootElement = portletDataContext.getExportDataRootElement();
            try {
                portletDataContext.clearScopedPrimaryKeys();
                Element preferenceDataElement = portletPreferencesElement.addElement("preference-data");
                portletDataContext.setExportDataRootElement(preferenceDataElement);
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                jxPortletPreferences = portletDataHandler.processExportPortletPreferences(portletDataContext, portletId, jxPortletPreferences);
            }
            finally {
                portletDataContext.setExportDataRootElement(exportDataRootElement);
            }
        }
        Document document = SAXReaderUtil.read((String)PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("owner-id", String.valueOf(ownerId));
        rootElement.addAttribute("owner-type", String.valueOf(ownerType));
        rootElement.addAttribute("default-user", String.valueOf(defaultUser));
        rootElement.addAttribute("plid", String.valueOf(plid));
        rootElement.addAttribute("portlet-id", portletId);
        if (ownerType == 5) {
            PortletItem portletItem = PortletItemLocalServiceUtil.getPortletItem((long)ownerId);
            rootElement.addAttribute("archive-user-uuid", portletItem.getUserUuid());
            rootElement.addAttribute("archive-name", portletItem.getName());
        } else if (ownerType == 4) {
            User user = UserLocalServiceUtil.fetchUserById((long)ownerId);
            if (user == null) {
                return;
            }
            rootElement.addAttribute("user-uuid", user.getUserUuid());
        }
        List nodes = document.selectNodes("/portlet-preferences/preference[name/text() = 'last-publish-date']");
        for (Node node : nodes) {
            document.remove(node);
        }
        String path = this.getPortletPreferencesPath(portletDataContext, portletId, ownerId, ownerType, plid);
        portletPreferencesElement.addAttribute("path", path);
        if (portletDataContext.isPathNotProcessed(path)) {
            portletDataContext.addZipEntry(path, document.formattedString("\t", false, false));
        }
    }

    protected void exportPortletPreferences(PortletDataContext portletDataContext, long ownerId, int ownerType, boolean defaultUser, Layout layout, long plid, String portletId, Element parentElement) throws Exception {
        com.liferay.portal.model.PortletPreferences portletPreferences = null;
        try {
            portletPreferences = ownerType == 1 || ownerType == 2 || ownerType == 5 ? PortletPreferencesLocalServiceUtil.getPortletPreferences((long)ownerId, (int)ownerType, (long)0L, (String)portletId) : PortletPreferencesLocalServiceUtil.getPortletPreferences((long)ownerId, (int)ownerType, (long)plid, (String)portletId);
        }
        catch (NoSuchPortletPreferencesException noSuchPortletPreferencesException) {
            return;
        }
        LayoutTypePortlet layoutTypePortlet = null;
        if (layout != null) {
            layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        }
        if (layoutTypePortlet == null || layoutTypePortlet.hasPortletId(portletId)) {
            this.exportPortletPreference(portletDataContext, ownerId, ownerType, defaultUser, portletPreferences, portletId, plid, parentElement);
        }
    }

    protected void exportRatingsEntries(PortletDataContext portletDataContext, Element parentElement) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("ratings");
        Map ratingsEntriesMap = portletDataContext.getRatingsEntries();
        for (Map.Entry entry : ratingsEntriesMap.entrySet()) {
            String[] ratingsEntryParts = StringUtil.split((String)((String)entry.getKey()), (char)'#');
            String className = ratingsEntryParts[0];
            String classPK = ratingsEntryParts[1];
            String ratingsEntriesPath = this.getRatingsEntriesPath(portletDataContext, className, classPK);
            Element assetElement = rootElement.addElement("asset");
            assetElement.addAttribute("path", ratingsEntriesPath);
            assetElement.addAttribute("class-name", className);
            assetElement.addAttribute("class-pk", classPK);
            List ratingsEntries = (List)entry.getValue();
            for (RatingsEntry ratingsEntry : ratingsEntries) {
                String ratingsEntryPath = this.getRatingsEntryPath(portletDataContext, className, classPK, ratingsEntry);
                User user = UserLocalServiceUtil.fetchUser((long)ratingsEntry.getUserId());
                if (user == null) continue;
                portletDataContext.addZipEntry(ratingsEntryPath, (Object)ratingsEntry);
                portletDataContext.addReferenceElement((ClassedModel)ratingsEntry, assetElement, (ClassedModel)user, "weak", true);
            }
        }
        portletDataContext.addZipEntry(String.valueOf(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext)) + "/ratings.xml", document.formattedString());
    }

    protected String getAssetCategoryPath(PortletDataContext portletDataContext, long assetCategoryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/categories/");
        sb.append(assetCategoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getAssetLinkPath(PortletDataContext portletDataContext, long assetLinkId) {
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/links/");
        sb.append(assetLinkId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getAssetTagPath(PortletDataContext portletDataContext, long assetCategoryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/tags/");
        sb.append(assetCategoryId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getAssetVocabulariesPath(PortletDataContext portletDataContext, long assetVocabularyId) {
        StringBundler sb = new StringBundler(4);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/vocabularies/");
        sb.append(assetVocabularyId);
        sb.append(".xml");
        return sb.toString();
    }

    protected String getCommentPath(PortletDataContext portletDataContext, String className, String classPK, MBMessage mbMessage) {
        StringBundler sb = new StringBundler(8);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/comments/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        sb.append(mbMessage.getMessageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getCommentsPath(PortletDataContext portletDataContext, String className, String classPK) {
        StringBundler sb = new StringBundler(6);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/comments/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        return sb.toString();
    }

    protected String getLockPath(PortletDataContext portletDataContext, String className, String key, Lock lock) {
        StringBundler sb = new StringBundler(8);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/locks/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(key);
        sb.append('/');
        sb.append(lock.getLockId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getPortletPreferencesPath(PortletDataContext portletDataContext, String portletId, long ownerId, int ownerType, long plid) {
        StringBundler sb = new StringBundler(8);
        sb.append(ExportImportPathUtil.getPortletPath((PortletDataContext)portletDataContext, (String)portletId));
        sb.append("/preferences/");
        if (ownerType == 1) {
            sb.append("company/");
        } else if (ownerType == 2) {
            sb.append("group/");
        } else if (ownerType == 3) {
            sb.append("layout/");
        } else if (ownerType == 4) {
            sb.append("user/");
        } else if (ownerType == 5) {
            sb.append("archived/");
        }
        sb.append(ownerId);
        sb.append('/');
        sb.append(plid);
        sb.append('/');
        sb.append("portlet-preferences.xml");
        return sb.toString();
    }

    protected String getRatingsEntriesPath(PortletDataContext portletDataContext, String className, String classPK) {
        StringBundler sb = new StringBundler(6);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/ratings/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        return sb.toString();
    }

    protected String getRatingsEntryPath(PortletDataContext portletDataContext, String className, String classPK, RatingsEntry ratingsEntry) {
        StringBundler sb = new StringBundler(8);
        sb.append(ExportImportPathUtil.getRootPath((PortletDataContext)portletDataContext));
        sb.append("/ratings/");
        sb.append(PortalUtil.getClassNameId((String)className));
        sb.append('/');
        sb.append(classPK);
        sb.append('/');
        sb.append(ratingsEntry.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }
}

