/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.impl.GroupModelImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import java.util.ArrayList;

public abstract class GroupBaseImpl
extends GroupModelImpl
implements Group {
    public void persist() throws SystemException {
        if (this.isNew()) {
            GroupLocalServiceUtil.addGroup((Group)this);
        } else {
            GroupLocalServiceUtil.updateGroup((Group)this);
        }
    }

    public String buildTreePath() throws PortalException, SystemException {
        ArrayList<GroupBaseImpl> groups = new ArrayList<GroupBaseImpl>();
        GroupBaseImpl group = this;
        while (group != null) {
            groups.add(group);
            group = GroupLocalServiceUtil.fetchGroup((long)group.getParentGroupId());
        }
        StringBundler sb = new StringBundler(groups.size() * 2 + 1);
        sb.append("/");
        int i2 = groups.size() - 1;
        while (i2 >= 0) {
            group = (Group)groups.get(i2);
            sb.append(group.getGroupId());
            sb.append("/");
            --i2;
        }
        return sb.toString();
    }

    public void updateTreePath(String treePath) throws SystemException {
        GroupBaseImpl group = this;
        group.setTreePath(treePath);
        GroupLocalServiceUtil.updateGroup((Group)group);
    }
}

