/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AuthToken;
import com.liferay.portal.security.auth.AuthTokenWhitelistUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.SecurityPortletContainerWrapper;
import com.liferay.util.PwdGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionAuthToken
implements AuthToken {
    private static final String _CSRF = "#CSRF";

    public void check(HttpServletRequest request) throws PrincipalException {
        this.checkCSRFToken(request, SecurityPortletContainerWrapper.class.getName());
    }

    public void checkCSRFToken(HttpServletRequest request, String origin) throws PrincipalException {
        String sessionToken;
        String portletNamespace;
        String strutsAction;
        String ppid;
        if (!PropsValues.AUTH_TOKEN_CHECK_ENABLED) {
            return;
        }
        String sharedSecret = ParamUtil.getString((HttpServletRequest)request, (String)"p_auth_secret");
        if (AuthTokenWhitelistUtil.isValidSharedSecret((String)sharedSecret)) {
            return;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        if (AuthTokenWhitelistUtil.isCSRFOrigintWhitelisted((long)companyId, (String)origin)) {
            return;
        }
        if (origin.equals(SecurityPortletContainerWrapper.class.getName()) && AuthTokenWhitelistUtil.isPortletCSRFWhitelisted((long)companyId, (String)(ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id")), (String)(strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)(String.valueOf(portletNamespace = PortalUtil.getPortletNamespace((String)ppid)) + "struts_action"))))) {
            return;
        }
        String csrfToken = ParamUtil.getString((HttpServletRequest)request, (String)"p_auth");
        if (Validator.isNull((String)csrfToken)) {
            csrfToken = GetterUtil.getString((String)request.getHeader("X-CSRF-Token"));
        }
        if (!csrfToken.equals(sessionToken = this.getSessionAuthenticationToken(request, _CSRF, false))) {
            throw new PrincipalException("Invalid authentication token");
        }
    }

    public String getToken(HttpServletRequest request) {
        return this.getSessionAuthenticationToken(request, _CSRF, true);
    }

    public String getToken(HttpServletRequest request, long plid, String portletId) {
        return this.getSessionAuthenticationToken(request, PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId), true);
    }

    public boolean isValidPortletInvocationToken(HttpServletRequest request, long plid, String portletId, String strutsAction, String tokenValue) {
        String key;
        String sessionToken;
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        if (AuthTokenWhitelistUtil.isPortletInvocationWhitelisted((long)companyId, (String)portletId, (String)strutsAction)) {
            return true;
        }
        return Validator.isNotNull((String)tokenValue) && Validator.isNotNull((String)(sessionToken = this.getSessionAuthenticationToken(request, key = PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId), false))) && sessionToken.equals(tokenValue);
    }

    protected String getSessionAuthenticationToken(HttpServletRequest request, String key, boolean createToken) {
        HttpSession session = request.getSession();
        String tokenKey = "LIFERAY_SHARED_AUTHENTICATION_TOKEN".concat(key);
        String sessionAuthenticationToken = (String)session.getAttribute(tokenKey);
        if (createToken && Validator.isNull((String)sessionAuthenticationToken)) {
            sessionAuthenticationToken = PwdGenerator.getPassword((int)PropsValues.AUTH_TOKEN_LENGTH);
            session.setAttribute(tokenKey, (Object)sessionAuthenticationToken);
        }
        return sessionAuthenticationToken;
    }
}

