/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.AccountNameException;
import com.liferay.portal.CompanyMxException;
import com.liferay.portal.CompanyVirtualHostException;
import com.liferay.portal.CompanyWebIdException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchShardException;
import com.liferay.portal.NoSuchVirtualHostException;
import com.liferay.portal.RequiredCompanyException;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.FacetedSearcher;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.facet.AssetEntriesFacet;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.ScopeFacet;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.PortalPreferences;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Shard;
import com.liferay.portal.model.User;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.base.CompanyLocalServiceBaseImpl;
import com.liferay.portal.service.persistence.GroupActionableDynamicQuery;
import com.liferay.portal.service.persistence.LayoutPrototypeActionableDynamicQuery;
import com.liferay.portal.service.persistence.LayoutSetPrototypeActionableDynamicQuery;
import com.liferay.portal.service.persistence.OrganizationActionableDynamicQuery;
import com.liferay.portal.service.persistence.RoleActionableDynamicQuery;
import com.liferay.portal.service.persistence.UserActionableDynamicQuery;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;

public class CompanyLocalServiceImpl
extends CompanyLocalServiceBaseImpl {
    private static final String _DEFAULT_VIRTUAL_HOST = "localhost";
    private static Log _log = LogFactoryUtil.getLog(CompanyLocalServiceImpl.class);

    public Company addCompany(String webId, String virtualHostname, String mx, String shardName, boolean system, int maxUsers, boolean active) throws PortalException, SystemException {
        virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
        if (Validator.isNull((String)webId) || webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID) || this.companyPersistence.fetchByWebId(webId) != null) {
            throw new CompanyWebIdException();
        }
        this.validateVirtualHost(webId, virtualHostname);
        this.validateMx(mx);
        Company company = this.checkCompany(webId, mx, shardName);
        company.setMx(mx);
        company.setSystem(system);
        company.setMaxUsers(maxUsers);
        company.setActive(active);
        this.companyPersistence.update((BaseModel)company);
        this.updateVirtualHostname(company.getCompanyId(), virtualHostname);
        return company;
    }

    public Company checkCompany(String webId) throws PortalException, SystemException {
        String mx = webId;
        return this.companyLocalService.checkCompany(webId, mx, PropsValues.SHARD_DEFAULT_NAME);
    }

    public Company checkCompany(String webId, String mx, String shardName) throws PortalException, SystemException {
        long companyId;
        Date now = new Date();
        Company company = this.companyPersistence.fetchByWebId(webId);
        if (company == null) {
            companyId = this.counterLocalService.increment();
            company = this.companyPersistence.create(companyId);
            try {
                company.setKey(Base64.objectToString((Object)Encryptor.generateKey()));
            }
            catch (EncryptorException ee) {
                throw new SystemException((Throwable)ee);
            }
            company.setWebId(webId);
            company.setMx(mx);
            company.setActive(true);
            this.companyPersistence.update((BaseModel)company);
            this.shardLocalService.addShard(Company.class.getName(), companyId, shardName);
            String name = webId;
            if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                name = PropsValues.COMPANY_DEFAULT_NAME;
            }
            String legalName = null;
            String legalId = null;
            String legalType = null;
            String sicCode = null;
            String tickerSymbol = null;
            String industry = null;
            String type = null;
            String size = null;
            this.updateAccount(company, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
            if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                this.updateVirtualHostname(companyId, _DEFAULT_VIRTUAL_HOST);
            }
            if (webId.equals("liferay.net")) {
                company = this.companyPersistence.findByWebId(webId);
                this.updateVirtualHostname(companyId, "demo.liferay.net");
                this.updateSecurity(companyId, "emailAddress", true, true, true, true, false, true);
                PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
                try {
                    preferences.setValue("admin.email.from.name", "Liferay Demo");
                    preferences.setValue("admin.email.from.address", "test@liferay.net");
                    preferences.store();
                }
                catch (IOException ioe) {
                    throw new SystemException((Throwable)ioe);
                }
                catch (PortletException pe) {
                    throw new SystemException((Throwable)pe);
                }
            }
        } else {
            try {
                this.shardLocalService.getShard(Company.class.getName(), company.getCompanyId());
            }
            catch (NoSuchShardException noSuchShardException) {
                this.shardLocalService.addShard(Company.class.getName(), company.getCompanyId(), shardName);
            }
        }
        companyId = company.getCompanyId();
        this.checkCompanyKey(companyId);
        User defaultUser = this.userPersistence.fetchByC_DU(companyId, true);
        if (defaultUser != null) {
            if (!defaultUser.isAgreedToTermsOfUse()) {
                defaultUser.setAgreedToTermsOfUse(true);
                this.userPersistence.update((BaseModel)defaultUser);
            }
        } else {
            long userId = this.counterLocalService.increment();
            defaultUser = this.userPersistence.create(userId);
            defaultUser.setCompanyId(companyId);
            defaultUser.setCreateDate(now);
            defaultUser.setModifiedDate(now);
            defaultUser.setDefaultUser(true);
            defaultUser.setContactId(this.counterLocalService.increment());
            defaultUser.setPassword("password");
            defaultUser.setScreenName(String.valueOf(defaultUser.getUserId()));
            defaultUser.setEmailAddress("default@" + company.getMx());
            if (Validator.isNotNull((String)PropsValues.COMPANY_DEFAULT_LOCALE)) {
                defaultUser.setLanguageId(PropsValues.COMPANY_DEFAULT_LOCALE);
            } else {
                Locale locale = LocaleUtil.getDefault();
                defaultUser.setLanguageId(locale.toString());
            }
            if (Validator.isNotNull((String)PropsValues.COMPANY_DEFAULT_TIME_ZONE)) {
                defaultUser.setTimeZoneId(PropsValues.COMPANY_DEFAULT_TIME_ZONE);
            } else {
                TimeZone timeZone = TimeZoneUtil.getDefault();
                defaultUser.setTimeZoneId(timeZone.getID());
            }
            defaultUser.setGreeting(LanguageUtil.format((Locale)defaultUser.getLocale(), (String)"welcome-x", (Object)"", (boolean)false));
            defaultUser.setLoginDate(now);
            defaultUser.setFailedLoginAttempts(0);
            defaultUser.setAgreedToTermsOfUse(true);
            defaultUser.setStatus(0);
            this.userPersistence.update((BaseModel)defaultUser);
            Contact defaultContact = this.contactPersistence.create(defaultUser.getContactId());
            defaultContact.setCompanyId(defaultUser.getCompanyId());
            defaultContact.setUserId(defaultUser.getUserId());
            defaultContact.setUserName("");
            defaultContact.setCreateDate(now);
            defaultContact.setModifiedDate(now);
            defaultContact.setClassName(User.class.getName());
            defaultContact.setClassPK(defaultUser.getUserId());
            defaultContact.setAccountId(company.getAccountId());
            defaultContact.setParentContactId(0L);
            defaultContact.setEmailAddress(defaultUser.getEmailAddress());
            defaultContact.setFirstName("");
            defaultContact.setMiddleName("");
            defaultContact.setLastName("");
            defaultContact.setMale(true);
            defaultContact.setBirthday(now);
            this.contactPersistence.update((BaseModel)defaultContact);
        }
        this.roleLocalService.checkSystemRoles(companyId);
        this.groupLocalService.checkSystemGroups(companyId);
        this.groupLocalService.checkCompanyGroup(companyId);
        this.passwordPolicyLocalService.checkDefaultPasswordPolicy(companyId);
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.roleLocalService.setUserRoles(defaultUser.getUserId(), new long[]{guestRole.getRoleId()});
        if (this.userPersistence.countByCompanyId(companyId) == 1) {
            String emailAddress = String.valueOf(PropsValues.DEFAULT_ADMIN_EMAIL_ADDRESS_PREFIX) + "@" + mx;
            this.userLocalService.addDefaultAdminUser(companyId, PropsValues.DEFAULT_ADMIN_SCREEN_NAME, emailAddress, defaultUser.getLocale(), PropsValues.DEFAULT_ADMIN_FIRST_NAME, PropsValues.DEFAULT_ADMIN_MIDDLE_NAME, PropsValues.DEFAULT_ADMIN_LAST_NAME);
        }
        this.portletLocalService.checkPortlets(companyId);
        return company;
    }

    public void checkCompanyKey(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (Validator.isNull((String)company.getKey()) && company.getKeyObj() == null) {
            try {
                company.setKey(Base64.objectToString((Object)Encryptor.generateKey()));
            }
            catch (EncryptorException ee) {
                throw new SystemException((Throwable)ee);
            }
            this.companyPersistence.update((BaseModel)company);
        }
    }

    @Override
    public Company deleteCompany(long companyId) throws PortalException, SystemException {
        if (companyId == PortalInstances.getDefaultCompanyId()) {
            throw new RequiredCompanyException();
        }
        Long currentCompanyId = CompanyThreadLocal.getCompanyId();
        boolean deleteInProcess = CompanyThreadLocal.isDeleteInProcess();
        try {
            CompanyThreadLocal.setCompanyId((Long)companyId);
            CompanyThreadLocal.setDeleteInProcess((boolean)true);
            Company company = this.doDeleteCompany(companyId);
            return company;
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)currentCompanyId);
            CompanyThreadLocal.setDeleteInProcess((boolean)deleteInProcess);
        }
    }

    public void deleteLogo(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        long logoId = company.getLogoId();
        if (logoId > 0L) {
            company.setLogoId(0L);
            this.companyPersistence.update((BaseModel)company);
            this.imageLocalService.deleteImage(logoId);
        }
    }

    public Company fetchCompanyById(long companyId) throws SystemException {
        return this.companyPersistence.fetchByPrimaryKey(companyId);
    }

    public Company fetchCompanyByVirtualHost(String virtualHostname) throws SystemException {
        VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim()));
        if (virtualHost == null || virtualHost.getLayoutSetId() != 0L) {
            return null;
        }
        return this.companyPersistence.fetchByPrimaryKey(virtualHost.getCompanyId());
    }

    public List<Company> getCompanies() throws SystemException {
        return this.companyPersistence.findAll();
    }

    public List<Company> getCompanies(boolean system) throws SystemException {
        return this.companyPersistence.findBySystem(system);
    }

    public int getCompaniesCount(boolean system) throws SystemException {
        return this.companyPersistence.countBySystem(system);
    }

    public Company getCompanyById(long companyId) throws PortalException, SystemException {
        return this.companyPersistence.findByPrimaryKey(companyId);
    }

    public Company getCompanyByLogoId(long logoId) throws PortalException, SystemException {
        return this.companyPersistence.findByLogoId(logoId);
    }

    public Company getCompanyByMx(String mx) throws PortalException, SystemException {
        return this.companyPersistence.findByMx(mx);
    }

    public Company getCompanyByVirtualHost(String virtualHostname) throws PortalException, SystemException {
        try {
            virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
            VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname);
            if (virtualHost.getLayoutSetId() != 0L) {
                throw new CompanyVirtualHostException("Virtual host is associated with layout set " + virtualHost.getLayoutSetId());
            }
            return this.companyPersistence.findByPrimaryKey(virtualHost.getCompanyId());
        }
        catch (NoSuchVirtualHostException nsvhe) {
            throw new CompanyVirtualHostException((Throwable)nsvhe);
        }
    }

    public Company getCompanyByWebId(String webId) throws PortalException, SystemException {
        return this.companyPersistence.findByWebId(webId);
    }

    public long getCompanyIdByUserId(long userId) throws Exception {
        long companyId;
        block5: {
            long[] companyIds = PortalInstances.getCompanyIds();
            companyId = 0L;
            if (companyIds.length == 1) {
                companyId = companyIds[0];
            } else if (companyIds.length > 1) {
                try {
                    User user = this.userPersistence.findByPrimaryKey(userId);
                    companyId = user.getCompanyId();
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)("Unable to get the company id for user " + userId), (Throwable)e2);
                }
            }
        }
        return companyId;
    }

    public void removePreferences(long companyId, String[] keys) throws SystemException {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                preferences.reset(key);
                ++n2;
            }
            preferences.store();
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Hits search(long companyId, long userId, String keywords, int start, int end) throws SystemException {
        return this.search(companyId, userId, null, 0L, null, keywords, start, end);
    }

    public Hits search(long companyId, long userId, String portletId, long groupId, String type, String keywords, int start, int end) throws SystemException {
        try {
            SearchContext searchContext = new SearchContext();
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setEntryClassNames(SearchEngineUtil.getEntryClassNames());
            if (groupId > 0L) {
                searchContext.setGroupIds(new long[]{groupId});
            }
            searchContext.setKeywords(keywords);
            if (Validator.isNotNull((String)portletId)) {
                searchContext.setPortletIds(new String[]{portletId});
            }
            searchContext.setStart(start);
            searchContext.setUserId(userId);
            AssetEntriesFacet assetEntriesFacet = new AssetEntriesFacet(searchContext);
            assetEntriesFacet.setStatic(true);
            searchContext.addFacet((Facet)assetEntriesFacet);
            ScopeFacet scopeFacet = new ScopeFacet(searchContext);
            scopeFacet.setStatic(true);
            searchContext.addFacet((Facet)scopeFacet);
            Indexer indexer = FacetedSearcher.getInstance();
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Company updateCompany(long companyId, String virtualHostname, String mx, int maxUsers, boolean active) throws PortalException, SystemException {
        virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
        if (!active && companyId == PortalInstances.getDefaultCompanyId()) {
            active = true;
        }
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validateVirtualHost(company.getWebId(), virtualHostname);
        if (PropsValues.MAIL_MX_UPDATE) {
            this.validateMx(mx);
            company.setMx(mx);
        }
        company.setMaxUsers(maxUsers);
        company.setActive(active);
        this.companyPersistence.update((BaseModel)company);
        this.updateVirtualHostname(companyId, virtualHostname);
        return company;
    }

    public Company updateCompany(long companyId, String virtualHostname, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException, SystemException {
        virtualHostname = StringUtil.toLowerCase((String)virtualHostname.trim());
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.validateVirtualHost(company.getWebId(), virtualHostname);
        if (PropsValues.MAIL_MX_UPDATE) {
            this.validateMx(mx);
        }
        this.validateName(companyId, name);
        if (PropsValues.MAIL_MX_UPDATE) {
            company.setMx(mx);
        }
        company.setHomeURL(homeURL);
        this.companyPersistence.update((BaseModel)company);
        this.updateAccount(company, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
        this.updateVirtualHostname(companyId, virtualHostname);
        return company;
    }

    public void updateDisplay(long companyId, String languageId, String timeZoneId) throws PortalException, SystemException {
        User user = this.userLocalService.getDefaultUser(companyId);
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        this.userPersistence.update((BaseModel)user);
    }

    public Company updateLogo(long companyId, byte[] bytes) throws PortalException, SystemException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), bytes);
        return company;
    }

    public Company updateLogo(long companyId, File file) throws PortalException, SystemException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), file);
        return company;
    }

    public Company updateLogo(long companyId, InputStream is) throws PortalException, SystemException {
        Company company = this.checkLogo(companyId);
        this.imageLocalService.updateImage(company.getLogoId(), is);
        return company;
    }

    public void updatePreferences(long companyId, UnicodeProperties properties) throws PortalException, SystemException {
        PortletPreferences portletPreferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            String oldLanguageIds;
            String newLanguageIds = properties.getProperty("locales");
            if (Validator.isNotNull((String)newLanguageIds) && !Validator.equals((Object)(oldLanguageIds = portletPreferences.getValue("locales", "")), (Object)newLanguageIds)) {
                this.validateLanguageIds(newLanguageIds);
                LanguageUtil.resetAvailableLocales((long)companyId);
                Date now = new Date();
                for (LayoutSetPrototype layoutSetPrototype : this.layoutSetPrototypeLocalService.getLayoutSetPrototypes(companyId)) {
                    layoutSetPrototype.setModifiedDate(now);
                    this.layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototype);
                }
            }
            ArrayList<String> resetKeys = new ArrayList<String>();
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value.equals("TEMP_OBFUSCATION_VALUE")) continue;
                String propsUtilValue = PropsUtil.get(key);
                if (!value.equals(propsUtilValue)) {
                    portletPreferences.setValue(key, value);
                    continue;
                }
                String portletPreferencesValue = portletPreferences.getValue(key, null);
                if (portletPreferencesValue == null) continue;
                resetKeys.add(key);
            }
            for (String key : resetKeys) {
                portletPreferences.reset(key);
            }
            portletPreferences.store();
        }
        catch (LocaleException le) {
            throw le;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public void updateSecurity(long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean siteLogo) throws SystemException {
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        try {
            preferences.setValue("company.security.auth.type", authType);
            preferences.setValue("company.security.auto.login", String.valueOf(autoLogin));
            preferences.setValue("company.security.send.password", String.valueOf(sendPassword));
            preferences.setValue("company.security.strangers", String.valueOf(strangers));
            preferences.setValue("company.security.strangers.with.mx", String.valueOf(strangersWithMx));
            preferences.setValue("company.security.strangers.verify", String.valueOf(strangersVerify));
            preferences.setValue("company.security.site.logo", String.valueOf(siteLogo));
            preferences.store();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (PortletException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    protected Company checkLogo(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        long logoId = company.getLogoId();
        if (logoId <= 0L) {
            logoId = this.counterLocalService.increment();
            company.setLogoId(logoId);
            company = (Company)this.companyPersistence.update((BaseModel)company);
        }
        return company;
    }

    protected Company doDeleteCompany(final long companyId) throws PortalException, SystemException {
        String[] systemGroups;
        Company company = this.companyPersistence.remove(companyId);
        this.accountLocalService.deleteAccount(company.getAccountId());
        DeleteGroupActionableDynamicQuery deleteGroupActionableDynamicQuery = new DeleteGroupActionableDynamicQuery();
        deleteGroupActionableDynamicQuery.setCompanyId(companyId);
        deleteGroupActionableDynamicQuery.performActions();
        String[] stringArray = systemGroups = PortalUtil.getSystemGroups();
        int n = systemGroups.length;
        int n2 = 0;
        while (n2 < n) {
            String groupName = stringArray[n2];
            Group group = this.groupLocalService.getGroup(companyId, groupName);
            deleteGroupActionableDynamicQuery.deleteGroup(group);
            ++n2;
        }
        Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
        deleteGroupActionableDynamicQuery.deleteGroup(companyGroup);
        LayoutPrototypeActionableDynamicQuery layoutPrototypeActionableDynamicQuery = new LayoutPrototypeActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                LayoutPrototype layoutPrototype = (LayoutPrototype)object;
                CompanyLocalServiceImpl.this.layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototype);
            }
        };
        layoutPrototypeActionableDynamicQuery.setCompanyId(companyId);
        layoutPrototypeActionableDynamicQuery.performActions();
        LayoutSetPrototypeActionableDynamicQuery layoutSetPrototypeActionableDynamicQuery = new LayoutSetPrototypeActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                LayoutSetPrototype layoutSetPrototype = (LayoutSetPrototype)object;
                CompanyLocalServiceImpl.this.layoutSetPrototypeLocalService.deleteLayoutSetPrototype(layoutSetPrototype);
            }
        };
        layoutSetPrototypeActionableDynamicQuery.setCompanyId(companyId);
        layoutSetPrototypeActionableDynamicQuery.performActions();
        DeleteOrganizationActionableDynamicQuery deleteOrganizationActionableDynamicQuery = new DeleteOrganizationActionableDynamicQuery();
        deleteOrganizationActionableDynamicQuery.setCompanyId(companyId);
        deleteOrganizationActionableDynamicQuery.performActions();
        RoleActionableDynamicQuery roleActionableDynamicQuery = new RoleActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                Role role = (Role)object;
                CompanyLocalServiceImpl.this.roleLocalService.deleteRole(role);
            }
        };
        roleActionableDynamicQuery.setCompanyId(companyId);
        roleActionableDynamicQuery.performActions();
        this.passwordPolicyLocalService.deleteNondefaultPasswordPolicies(companyId);
        PasswordPolicy defaultPasswordPolicy = this.passwordPolicyLocalService.getDefaultPasswordPolicy(companyId);
        if (defaultPasswordPolicy != null) {
            this.passwordPolicyLocalService.deletePasswordPolicy(defaultPasswordPolicy);
        }
        PortalPreferences portalPreferences = this.portalPreferencesPersistence.findByO_O(companyId, 1);
        this.portalPreferencesLocalService.deletePortalPreferences(portalPreferences);
        List portlets = this.portletPersistence.findByCompanyId(companyId);
        for (Portlet portlet : portlets) {
            this.portletLocalService.deletePortlet(portlet.getId());
        }
        this.portletLocalService.removeCompanyPortletsPool(companyId);
        Shard shard = this.shardLocalService.getShard(Company.class.getName(), company.getCompanyId());
        this.shardLocalService.deleteShard(shard);
        UserActionableDynamicQuery userActionableDynamicQuery = new UserActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                User user = (User)object;
                if (!user.isDefaultUser()) {
                    CompanyLocalServiceImpl.this.userLocalService.deleteUser(user.getUserId());
                }
            }
        };
        userActionableDynamicQuery.setCompanyId(companyId);
        userActionableDynamicQuery.performActions();
        User defaultUser = this.userLocalService.getDefaultUser(companyId);
        this.userLocalService.deleteUser(defaultUser);
        VirtualHost companyVirtualHost = this.virtualHostLocalService.fetchVirtualHost(companyId, 0L);
        this.virtualHostLocalService.deleteVirtualHost(companyVirtualHost);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PortalInstances.removeCompany(companyId);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
        return company;
    }

    protected void updateAccount(Company company, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws SystemException {
        Date now = new Date();
        Account account = this.accountPersistence.fetchByPrimaryKey(company.getAccountId());
        if (account == null) {
            long accountId = this.counterLocalService.increment();
            account = this.accountPersistence.create(accountId);
            account.setCompanyId(company.getCompanyId());
            account.setCreateDate(now);
            account.setUserId(0L);
            account.setUserName("");
            company.setAccountId(accountId);
            this.companyPersistence.update((BaseModel)company);
        }
        account.setModifiedDate(now);
        account.setName(name);
        account.setLegalName(legalName);
        account.setLegalId(legalId);
        account.setLegalType(legalType);
        account.setSicCode(sicCode);
        account.setTickerSymbol(tickerSymbol);
        account.setIndustry(industry);
        account.setType(type);
        account.setSize(size);
        this.accountPersistence.update((BaseModel)account);
    }

    protected void updateVirtualHostname(long companyId, String virtualHostname) throws CompanyVirtualHostException, SystemException {
        if (Validator.isNotNull((String)virtualHostname)) {
            VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname);
            if (virtualHost == null) {
                this.virtualHostLocalService.updateVirtualHost(companyId, 0L, virtualHostname);
            } else if (virtualHost.getCompanyId() != companyId || virtualHost.getLayoutSetId() != 0L) {
                throw new CompanyVirtualHostException();
            }
        } else {
            VirtualHost virtualHost = this.virtualHostPersistence.fetchByC_L(companyId, 0L);
            if (virtualHost != null) {
                this.virtualHostPersistence.remove((BaseModel)virtualHost);
            }
        }
    }

    protected void validateLanguageIds(String languageIds) throws PortalException {
        String[] languageIdsArray;
        String[] stringArray = languageIdsArray = StringUtil.split((String)languageIds, (String)",");
        int n = languageIdsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String languageId = stringArray[n2];
            if (!ArrayUtil.contains((Object[])PropsValues.LOCALES, (Object)languageId)) {
                LocaleException le = new LocaleException(1);
                le.setSourceAvailableLocales(LocaleUtil.fromLanguageIds((String[])PropsValues.LOCALES));
                le.setTargetAvailableLocales(LocaleUtil.fromLanguageIds((String[])languageIdsArray));
                throw le;
            }
            ++n2;
        }
    }

    protected void validateMx(String mx) throws PortalException {
        if (Validator.isNull((String)mx) || !Validator.isDomain((String)mx)) {
            throw new CompanyMxException();
        }
    }

    protected void validateName(long companyId, String name) throws PortalException, SystemException {
        Group group = this.groupLocalService.fetchGroup(companyId, name);
        if (group != null || Validator.isNull((String)name)) {
            throw new AccountNameException();
        }
    }

    protected void validateVirtualHost(String webId, String virtualHostname) throws PortalException, SystemException {
        if (Validator.isNull((String)virtualHostname)) {
            throw new CompanyVirtualHostException();
        }
        if (virtualHostname.equals(_DEFAULT_VIRTUAL_HOST) && !webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new CompanyVirtualHostException();
        }
        if (!Validator.isDomain((String)virtualHostname)) {
            throw new CompanyVirtualHostException();
        }
        try {
            VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname);
            long companyId = virtualHost.getCompanyId();
            Company virtualHostnameCompany = this.companyPersistence.findByPrimaryKey(companyId);
            if (!webId.equals(virtualHostnameCompany.getWebId())) {
                throw new CompanyVirtualHostException();
            }
        }
        catch (NoSuchVirtualHostException noSuchVirtualHostException) {}
    }

    protected class DeleteGroupActionableDynamicQuery
    extends GroupActionableDynamicQuery {
        private long _parentGroupId = 0L;

        public void deleteGroup(Group group) throws PortalException, SystemException {
            DeleteGroupActionableDynamicQuery deleteGroupActionableDynamicQuery = new DeleteGroupActionableDynamicQuery();
            deleteGroupActionableDynamicQuery.setCompanyId(group.getCompanyId());
            deleteGroupActionableDynamicQuery.setParentGroupId(group.getGroupId());
            deleteGroupActionableDynamicQuery.performActions();
            CompanyLocalServiceImpl.this.groupLocalService.deleteGroup(group);
            LiveUsers.deleteGroup(group.getCompanyId(), group.getGroupId());
        }

        public void setParentGroupId(long parentGroupId) {
            this._parentGroupId = parentGroupId;
        }

        protected void addCriteria(DynamicQuery dynamicQuery) {
            Property parentGroupIdProperty = PropertyFactoryUtil.forName((String)"parentGroupId");
            dynamicQuery.add(parentGroupIdProperty.eq((Object)this._parentGroupId));
            Property siteProperty = PropertyFactoryUtil.forName((String)"site");
            dynamicQuery.add(siteProperty.eq((Object)Boolean.TRUE));
        }

        protected void performAction(Object object) throws PortalException, SystemException {
            Group group = (Group)object;
            if (!PortalUtil.isSystemGroup((String)group.getName()) && !group.isCompany()) {
                this.deleteGroup(group);
            }
        }
    }

    protected class DeleteOrganizationActionableDynamicQuery
    extends OrganizationActionableDynamicQuery {
        private long _parentOrganizationId = 0L;

        public void deleteOrganization(Organization organization) throws PortalException, SystemException {
            DeleteOrganizationActionableDynamicQuery deleteOrganizationActionableDynamicQuery = new DeleteOrganizationActionableDynamicQuery();
            deleteOrganizationActionableDynamicQuery.setCompanyId(organization.getCompanyId());
            deleteOrganizationActionableDynamicQuery.setParentOrganizationId(organization.getOrganizationId());
            deleteOrganizationActionableDynamicQuery.performActions();
            CompanyLocalServiceImpl.this.organizationLocalService.deleteOrganization(organization);
        }

        public void setParentOrganizationId(long parentOrganizationId) {
            this._parentOrganizationId = parentOrganizationId;
        }

        protected void addCriteria(DynamicQuery dynamicQuery) {
            Property property = PropertyFactoryUtil.forName((String)"parentOrganizationId");
            dynamicQuery.add(property.eq((Object)this._parentOrganizationId));
        }

        protected void performAction(Object object) throws PortalException, SystemException {
            Organization organization = (Organization)object;
            this.deleteOrganization(organization);
        }
    }
}

