/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.base.ResourceActionLocalServiceBaseImpl;
import com.liferay.portal.util.comparator.ResourceActionBitwiseValueComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceActionLocalServiceImpl
extends ResourceActionLocalServiceBaseImpl {
    private static Map<String, ResourceAction> _resourceActions = new ConcurrentHashMap<String, ResourceAction>();

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkResourceActions() throws SystemException {
        List resourceActions = this.resourceActionPersistence.findAll();
        for (ResourceAction resourceAction : resourceActions) {
            String key = this.encodeKey(resourceAction.getName(), resourceAction.getActionId());
            _resourceActions.put(key, resourceAction);
        }
    }

    public void checkResourceActions(String name, List<String> actionIds) throws SystemException {
        this.checkResourceActions(name, actionIds, false);
    }

    public void checkResourceActions(String name, List<String> actionIds, boolean addDefaultActions) throws SystemException {
        long lastBitwiseValue = -1L;
        ArrayList<ResourceAction> newResourceActions = null;
        for (String actionId : actionIds) {
            String key = this.encodeKey(name, actionId);
            ResourceAction resourceAction = _resourceActions.get(key);
            if (resourceAction != null) continue;
            resourceAction = this.resourceActionPersistence.fetchByN_A(name, actionId);
            if (resourceAction == null) {
                long bitwiseValue = 1L;
                if (!actionId.equals("VIEW")) {
                    if (lastBitwiseValue < 0L) {
                        ResourceAction lastResourceAction = this.resourceActionPersistence.fetchByName_First(name, (OrderByComparator)new ResourceActionBitwiseValueComparator());
                        lastBitwiseValue = lastResourceAction != null ? lastResourceAction.getBitwiseValue() : 1L;
                    }
                    bitwiseValue = lastBitwiseValue <<= 1;
                }
                long resourceActionId = this.counterLocalService.increment(ResourceAction.class.getName());
                resourceAction = this.resourceActionPersistence.create(resourceActionId);
                resourceAction.setName(name);
                resourceAction.setActionId(actionId);
                resourceAction.setBitwiseValue(bitwiseValue);
                this.resourceActionPersistence.update((BaseModel)resourceAction);
                if (newResourceActions == null) {
                    newResourceActions = new ArrayList<ResourceAction>();
                }
                newResourceActions.add(resourceAction);
            }
            _resourceActions.put(key, resourceAction);
        }
        if (!addDefaultActions || newResourceActions == null) {
            return;
        }
        List groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
        List guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions((String)name);
        long guestBitwiseValue = 0L;
        long ownerBitwiseValue = 0L;
        long siteMemberBitwiseValue = 0L;
        for (ResourceAction resourceAction : newResourceActions) {
            String actionId = resourceAction.getActionId();
            if (guestDefaultActions.contains(actionId)) {
                guestBitwiseValue |= resourceAction.getBitwiseValue();
            }
            ownerBitwiseValue |= resourceAction.getBitwiseValue();
            if (!groupDefaultActions.contains(actionId)) continue;
            siteMemberBitwiseValue |= resourceAction.getBitwiseValue();
        }
        if (guestBitwiseValue > 0L) {
            this.resourcePermissionLocalService.addResourcePermissions(name, "Guest", 4, guestBitwiseValue);
        }
        if (ownerBitwiseValue > 0L) {
            this.resourcePermissionLocalService.addResourcePermissions(name, "Owner", 4, ownerBitwiseValue);
        }
        if (siteMemberBitwiseValue > 0L) {
            this.resourcePermissionLocalService.addResourcePermissions(name, "Site Member", 4, siteMemberBitwiseValue);
        }
    }

    @Skip
    public ResourceAction fetchResourceAction(String name, String actionId) {
        String key = this.encodeKey(name, actionId);
        return _resourceActions.get(key);
    }

    @Skip
    public ResourceAction getResourceAction(String name, String actionId) throws PortalException {
        String key = this.encodeKey(name, actionId);
        ResourceAction resourceAction = _resourceActions.get(key);
        if (resourceAction == null) {
            throw new NoSuchResourceActionException(key);
        }
        return resourceAction;
    }

    public List<ResourceAction> getResourceActions(String name) throws SystemException {
        return this.resourceActionPersistence.findByName(name);
    }

    protected String encodeKey(String name, String actionId) {
        return name.concat("#").concat(actionId);
    }
}

