/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.OldServiceComponentException;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.ServiceComponent;
import com.liferay.portal.service.base.ServiceComponentLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public class ServiceComponentLocalServiceImpl
extends ServiceComponentLocalServiceBaseImpl {
    public static final boolean CACHE_CLEAR_ON_PLUGIN_UNDEPLOY = GetterUtil.getBoolean((String)PropsUtil.get("cache.clear.on.plugin.undeploy"));
    private static final int _MAX_SERVICE_COMPONENTS = 10;
    private static Log _log = LogFactoryUtil.getLog(ServiceComponentLocalServiceImpl.class);
    private static PACL _pacl = new NoPACL();

    public void destroyServiceComponent(ServletContext servletContext, ClassLoader classLoader) throws SystemException {
        try {
            this.clearCacheRegistry(servletContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public ServiceComponent initServiceComponent(ServletContext servletContext, ClassLoader classLoader, String buildNamespace, long buildNumber, long buildDate, boolean buildAutoUpgrade) throws PortalException, SystemException {
        long serviceComponentId;
        try {
            ModelHintsUtil.read((ClassLoader)classLoader, (String)"META-INF/portlet-model-hints.xml");
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        try {
            ModelHintsUtil.read((ClassLoader)classLoader, (String)"META-INF/portlet-model-hints-ext.xml");
        }
        catch (Exception e3) {
            throw new SystemException((Throwable)e3);
        }
        ServiceComponent serviceComponent = null;
        ServiceComponent previousServiceComponent = null;
        List serviceComponents = this.serviceComponentPersistence.findByBuildNamespace(buildNamespace, 0, 1);
        if (serviceComponents.isEmpty()) {
            serviceComponentId = this.counterLocalService.increment();
            serviceComponent = this.serviceComponentPersistence.create(serviceComponentId);
            serviceComponent.setBuildNamespace(buildNamespace);
            serviceComponent.setBuildNumber(buildNumber);
            serviceComponent.setBuildDate(buildDate);
        } else {
            serviceComponent = (ServiceComponent)serviceComponents.get(0);
            if (serviceComponent.getBuildNumber() < buildNumber) {
                previousServiceComponent = serviceComponent;
                serviceComponentId = this.counterLocalService.increment();
                serviceComponent = this.serviceComponentPersistence.create(serviceComponentId);
                serviceComponent.setBuildNamespace(buildNamespace);
                serviceComponent.setBuildNumber(buildNumber);
                serviceComponent.setBuildDate(buildDate);
            } else {
                if (serviceComponent.getBuildNumber() > buildNumber) {
                    throw new OldServiceComponentException("Build namespace " + buildNamespace + " has build number " + serviceComponent.getBuildNumber() + " which is newer than " + buildNumber);
                }
                return serviceComponent;
            }
        }
        try {
            Document document = SAXReaderUtil.createDocument((String)"UTF-8");
            Element dataElement = document.addElement("data");
            Element tablesSQLElement = dataElement.addElement("tables-sql");
            String tablesSQL = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/sql/tables.sql"));
            tablesSQLElement.addCDATA(tablesSQL);
            Element sequencesSQLElement = dataElement.addElement("sequences-sql");
            String sequencesSQL = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/sql/sequences.sql"));
            sequencesSQLElement.addCDATA(sequencesSQL);
            Element indexesSQLElement = dataElement.addElement("indexes-sql");
            String indexesSQL = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/sql/indexes.sql"));
            indexesSQLElement.addCDATA(indexesSQL);
            String dataXML = document.formattedString();
            serviceComponent.setData(dataXML);
            this.serviceComponentPersistence.update((BaseModel)serviceComponent);
            this.serviceComponentLocalService.upgradeDB(classLoader, buildNamespace, buildNumber, buildAutoUpgrade, previousServiceComponent, tablesSQL, sequencesSQL, indexesSQL);
            this.removeOldServiceComponents(buildNamespace);
            return serviceComponent;
        }
        catch (Exception e4) {
            throw new SystemException((Throwable)e4);
        }
    }

    public void upgradeDB(ClassLoader classLoader, String buildNamespace, long buildNumber, boolean buildAutoUpgrade, ServiceComponent previousServiceComponent, String tablesSQL, String sequencesSQL, String indexesSQL) throws Exception {
        _pacl.doUpgradeDB(new DoUpgradeDBPrivilegedExceptionAction(classLoader, buildNamespace, buildNumber, buildAutoUpgrade, previousServiceComponent, tablesSQL, sequencesSQL, indexesSQL));
    }

    public void verifyDB() throws SystemException {
        List serviceComponents = this.serviceComponentPersistence.findAll();
        for (ServiceComponent serviceComponent : serviceComponents) {
            String buildNamespace = serviceComponent.getBuildNamespace();
            String tablesSQL = serviceComponent.getTablesSQL();
            String sequencesSQL = serviceComponent.getSequencesSQL();
            String indexesSQL = serviceComponent.getIndexesSQL();
            try {
                this.serviceComponentLocalService.upgradeDB(null, buildNamespace, 0L, false, null, tablesSQL, sequencesSQL, indexesSQL);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
    }

    protected void clearCacheRegistry(ServletContext servletContext) throws DocumentException {
        InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/classes/META-INF/portlet-hbm.xml");
        if (inputStream == null) {
            return;
        }
        Document document = SAXReaderUtil.read((InputStream)inputStream);
        Element rootElement = document.getRootElement();
        List classElements = rootElement.elements("class");
        for (Element classElement : classElements) {
            String name = classElement.attributeValue("name");
            CacheRegistryUtil.unregister((String)name);
        }
        CacheRegistryUtil.clear();
        if (CACHE_CLEAR_ON_PLUGIN_UNDEPLOY) {
            EntityCacheUtil.clearCache();
            FinderCacheUtil.clearCache();
        }
    }

    protected void doUpgradeDB(ClassLoader classLoader, String buildNamespace, long buildNumber, boolean buildAutoUpgrade, ServiceComponent previousServiceComponent, String tablesSQL, String sequencesSQL, String indexesSQL) throws Exception {
        DB db = DBFactoryUtil.getDB();
        if (previousServiceComponent == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Running " + buildNamespace + " SQL scripts"));
            }
            db.runSQLTemplateString(tablesSQL, true, false);
            db.runSQLTemplateString(sequencesSQL, true, false);
            db.runSQLTemplateString(indexesSQL, true, false);
        } else if (buildAutoUpgrade) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Upgrading " + buildNamespace + " database to build number " + buildNumber));
            }
            if (!tablesSQL.equals(previousServiceComponent.getTablesSQL())) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Upgrading database with tables.sql");
                }
                db.runSQLTemplateString(tablesSQL, true, false);
                this.upgradeModels(classLoader, previousServiceComponent);
            }
            if (!sequencesSQL.equals(previousServiceComponent.getSequencesSQL())) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Upgrading database with sequences.sql");
                }
                db.runSQLTemplateString(sequencesSQL, true, false);
            }
            if (!indexesSQL.equals(previousServiceComponent.getIndexesSQL()) || !tablesSQL.equals(previousServiceComponent.getTablesSQL())) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Upgrading database with indexes.sql");
                }
                db.runSQLTemplateString(indexesSQL, true, false);
            }
        }
    }

    protected List<String> getModels(ClassLoader classLoader) throws DocumentException, IOException {
        ArrayList<String> models;
        block2: {
            models = new ArrayList<String>();
            String xml = StringUtil.read((ClassLoader)classLoader, (String)"META-INF/portlet-model-hints.xml");
            models.addAll(this.getModels(xml));
            try {
                xml = StringUtil.read((ClassLoader)classLoader, (String)"META-INF/portlet-model-hints-ext.xml");
                models.addAll(this.getModels(xml));
            }
            catch (Exception exception) {
                if (!_log.isInfoEnabled()) break block2;
                _log.info((Object)"No optional file META-INF/portlet-model-hints-ext.xml found");
            }
        }
        return models;
    }

    protected List<String> getModels(String xml) throws DocumentException {
        ArrayList<String> models = new ArrayList<String>();
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        List modelElements = rootElement.elements("model");
        for (Element modelElement : modelElements) {
            String name = modelElement.attributeValue("name");
            models.add(name);
        }
        return models;
    }

    protected UpgradeTableListener getUpgradeTableListener(ClassLoader classLoader, Class<?> modelClass) {
        String modelClassName;
        String upgradeTableListenerClassName = modelClassName = modelClass.getName();
        upgradeTableListenerClassName = StringUtil.replaceLast((String)upgradeTableListenerClassName, (String)".model.impl.", (String)".model.upgrade.");
        upgradeTableListenerClassName = StringUtil.replaceLast((String)upgradeTableListenerClassName, (String)"ModelImpl", (String)"UpgradeTableListener");
        try {
            UpgradeTableListener upgradeTableListener = (UpgradeTableListener)InstanceFactory.newInstance((ClassLoader)classLoader, (String)upgradeTableListenerClassName);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Instantiated " + upgradeTableListenerClassName));
            }
            return upgradeTableListener;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to instantiate " + upgradeTableListenerClassName));
            }
            return null;
        }
    }

    protected void removeOldServiceComponents(String buildNamespace) throws SystemException {
        int serviceComponentsCount = this.serviceComponentPersistence.countByBuildNamespace(buildNamespace);
        if (serviceComponentsCount < 10) {
            return;
        }
        List serviceComponents = this.serviceComponentPersistence.findByBuildNamespace(buildNamespace, 10, serviceComponentsCount);
        int i2 = 0;
        while (i2 < serviceComponents.size()) {
            ServiceComponent serviceComponent = (ServiceComponent)serviceComponents.get(i2);
            this.serviceComponentPersistence.remove((BaseModel)serviceComponent);
            ++i2;
        }
    }

    protected void upgradeModels(ClassLoader classLoader, ServiceComponent previousServiceComponent) throws Exception {
        List<String> models = this.getModels(classLoader);
        for (String name : models) {
            int pos = name.lastIndexOf(".model.");
            name = String.valueOf(name.substring(0, pos)) + ".model.impl." + name.substring(pos + 7) + "ModelImpl";
            Class<?> modelClass = Class.forName(name, true, classLoader);
            Field tableNameField = modelClass.getField("TABLE_NAME");
            Field tableColumnsField = modelClass.getField("TABLE_COLUMNS");
            Field tableSQLCreateField = modelClass.getField("TABLE_SQL_CREATE");
            Field dataSourceField = modelClass.getField("DATA_SOURCE");
            String tableName = (String)tableNameField.get(null);
            Object[][] tableColumns = (Object[][])tableColumnsField.get(null);
            String tableSQLCreate = (String)tableSQLCreateField.get(null);
            String dataSource = (String)dataSourceField.get(null);
            if (!dataSource.equals("liferayDataSource")) continue;
            UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)tableName, (Object[][])tableColumns, (UpgradeColumn[])new UpgradeColumn[0]);
            UpgradeTableListener upgradeTableListener = this.getUpgradeTableListener(classLoader, modelClass);
            upgradeTable.setCreateSQL(tableSQLCreate);
            if (upgradeTableListener != null) {
                upgradeTableListener.onBeforeUpdateTable(previousServiceComponent, upgradeTable);
            }
            upgradeTable.updateTable();
            if (upgradeTableListener == null) continue;
            upgradeTableListener.onAfterUpdateTable(previousServiceComponent, upgradeTable);
        }
    }

    public class DoUpgradeDBPrivilegedExceptionAction
    implements PrivilegedExceptionAction<Void> {
        private boolean _buildAutoUpgrade;
        private String _buildNamespace;
        private long _buildNumber;
        private ClassLoader _classLoader;
        private String _indexesSQL;
        private ServiceComponent _previousServiceComponent;
        private String _sequencesSQL;
        private String _tablesSQL;

        public DoUpgradeDBPrivilegedExceptionAction(ClassLoader classLoader, String buildNamespace, long buildNumber, boolean buildAutoUpgrade, ServiceComponent previousServiceComponent, String tablesSQL, String sequencesSQL, String indexesSQL) {
            this._classLoader = classLoader;
            this._buildNamespace = buildNamespace;
            this._buildNumber = buildNumber;
            this._buildAutoUpgrade = buildAutoUpgrade;
            this._previousServiceComponent = previousServiceComponent;
            this._tablesSQL = tablesSQL;
            this._sequencesSQL = sequencesSQL;
            this._indexesSQL = indexesSQL;
        }

        public ClassLoader getClassLoader() {
            return this._classLoader;
        }

        @Override
        public Void run() throws Exception {
            ServiceComponentLocalServiceImpl.this.doUpgradeDB(this._classLoader, this._buildNamespace, this._buildNumber, this._buildAutoUpgrade, this._previousServiceComponent, this._tablesSQL, this._sequencesSQL, this._indexesSQL);
            return null;
        }
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public void doUpgradeDB(DoUpgradeDBPrivilegedExceptionAction doUpgradeDBPrivilegedExceptionAction) throws Exception {
            doUpgradeDBPrivilegedExceptionAction.run();
        }
    }

    public static interface PACL {
        public void doUpgradeDB(DoUpgradeDBPrivilegedExceptionAction var1) throws Exception;
    }
}

