/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.SubscriptionPermission;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.permission.BlogsPermission;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBDiscussionPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.service.permission.MBPermission;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;

public class SubscriptionPermissionImpl
implements SubscriptionPermission {
    public void check(PermissionChecker permissionChecker, String className, long classPK) throws PortalException, SystemException {
        this.check(permissionChecker, className, classPK, null, 0L);
    }

    public void check(PermissionChecker permissionChecker, String subscriptionClassName, long subscriptionClassPK, String inferredClassName, long inferredClassPK) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, subscriptionClassName, subscriptionClassPK, inferredClassName, inferredClassPK)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, String className, long classPK) throws PortalException, SystemException {
        return this.contains(permissionChecker, className, classPK, null, 0L);
    }

    public boolean contains(PermissionChecker permissionChecker, String subscriptionClassName, long subscriptionClassPK, String inferredClassName, long inferredClassPK) throws PortalException, SystemException {
        Boolean hasPermission;
        if (subscriptionClassName == null) {
            return false;
        }
        if (Validator.isNotNull((String)inferredClassName) && ((hasPermission = this.hasPermission(permissionChecker, inferredClassName, inferredClassPK, "VIEW")) == null || !hasPermission.booleanValue())) {
            return false;
        }
        hasPermission = this.hasPermission(permissionChecker, subscriptionClassName, subscriptionClassPK, "SUBSCRIBE");
        if (hasPermission != null) {
            return hasPermission;
        }
        return true;
    }

    protected Boolean hasPermission(PermissionChecker permissionChecker, String className, long classPK, String actionId) throws PortalException, SystemException {
        MBDiscussion mbDiscussion = MBDiscussionLocalServiceUtil.fetchDiscussion((String)className, (long)classPK);
        if (mbDiscussion != null) {
            if (className.equals(Layout.class.getName())) {
                return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"VIEW");
            }
            MBThread mbThread = MBThreadLocalServiceUtil.fetchThread((long)mbDiscussion.getThreadId());
            if (className.equals(WorkflowInstance.class.getName())) {
                return permissionChecker.hasPermission(mbThread.getGroupId(), "151", mbThread.getGroupId(), "VIEW");
            }
            return MBDiscussionPermission.contains(permissionChecker, mbThread.getCompanyId(), mbThread.getGroupId(), className, classPK, mbThread.getUserId(), "VIEW");
        }
        if (className.equals(BlogsEntry.class.getName())) {
            return BlogsPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(BookmarksEntry.class.getName())) {
            return BookmarksEntryPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(DLFileEntry.class.getName())) {
            return DLFileEntryPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(JournalArticle.class.getName())) {
            return JournalPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(MBCategory.class.getName())) {
            Group group = GroupLocalServiceUtil.fetchGroup((long)classPK);
            if (group == null) {
                return MBCategoryPermission.contains(permissionChecker, classPK, actionId);
            }
            return MBPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(MBThread.class.getName())) {
            MBThread mbThread = MBThreadLocalServiceUtil.fetchThread((long)classPK);
            if (mbThread == null) {
                return false;
            }
            return MBMessagePermission.contains(permissionChecker, mbThread.getRootMessageId(), actionId);
        }
        if (className.equals(WikiNode.class.getName())) {
            return WikiNodePermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(WikiPage.class.getName())) {
            return WikiPagePermission.contains(permissionChecker, classPK, actionId);
        }
        return null;
    }
}

