/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalMessages;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutFriendlyURL;
import com.liferay.portal.model.LayoutFriendlyURLComposite;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FriendlyURLServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(FriendlyURLServlet.class);
    private String _friendlyURLPathPrefix;
    private boolean _private;
    private boolean _user;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._private = GetterUtil.getBoolean((String)servletConfig.getInitParameter("private"));
        this._user = GetterUtil.getBoolean((String)servletConfig.getInitParameter("user"));
        this._friendlyURLPathPrefix = this._private ? (this._user ? PortalUtil.getPathFriendlyURLPrivateUser() : PortalUtil.getPathFriendlyURLPrivateGroup()) : PortalUtil.getPathFriendlyURLPublic();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean forcePermanentRedirect;
        String redirect;
        String mainPath;
        block11: {
            redirect = mainPath = "/c";
            String pathInfo = this.getPathInfo(request);
            request.setAttribute("FRIENDLY_URL", (Object)this.getFriendlyURL(pathInfo));
            Object[] redirectArray = null;
            forcePermanentRedirect = false;
            try {
                redirectArray = this.getRedirect(request, pathInfo, mainPath, request.getParameterMap());
                redirect = (String)redirectArray[0];
                forcePermanentRedirect = (Boolean)redirectArray[1];
                if (request.getAttribute("LAST_PATH") == null) {
                    LastPath lastPath = new LastPath(this._friendlyURLPathPrefix, pathInfo, request.getParameterMap());
                    request.setAttribute("LAST_PATH", (Object)lastPath);
                }
            }
            catch (Exception e2) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)e2);
                }
                if (!(e2 instanceof NoSuchGroupException) && !(e2 instanceof NoSuchLayoutException)) break block11;
                PortalUtil.sendError((int)404, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
        }
        if (Validator.isNull((String)redirect)) {
            redirect = mainPath;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect " + redirect));
        }
        if (redirect.charAt(0) == '/' && !forcePermanentRedirect) {
            ServletContext servletContext = this.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else if (forcePermanentRedirect) {
            response.setHeader("Location", redirect);
            response.setStatus(301);
        } else {
            response.sendRedirect(redirect);
        }
    }

    protected String getFriendlyURL(String pathInfo) {
        String friendlyURL = this._friendlyURLPathPrefix;
        if (Validator.isNotNull((String)pathInfo)) {
            friendlyURL = friendlyURL.concat(pathInfo);
        }
        return friendlyURL;
    }

    protected String getPathInfo(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        int pos = requestURI.indexOf(";jsessionid=");
        if (pos != -1) {
            requestURI = requestURI.substring(0, pos);
        }
        return requestURI.substring(this._friendlyURLPathPrefix.length());
    }

    protected Object[] getRedirect(HttpServletRequest request, String path, String mainPath, Map<String, String[]> params) throws Exception {
        if (Validator.isNull((String)path) || path.charAt(0) != '/') {
            return new Object[]{mainPath, false};
        }
        String friendlyURL = null;
        int pos = path.indexOf(47, 1);
        if (pos != -1) {
            friendlyURL = path.substring(0, pos);
        } else if (path.length() > 1) {
            friendlyURL = path;
        }
        if (Validator.isNull((String)friendlyURL)) {
            return new Object[]{mainPath, Boolean.FALSE};
        }
        long companyId = PortalInstances.getCompanyId(request);
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup((long)companyId, (String)friendlyURL);
        if (group == null) {
            String screenName = friendlyURL.substring(1);
            if (this._user || !Validator.isNumber((String)screenName)) {
                User user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)screenName);
                if (user != null) {
                    group = user.getGroup();
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No user exists with friendly URL " + screenName));
                }
            } else {
                long groupId = GetterUtil.getLong((String)screenName);
                group = GroupLocalServiceUtil.fetchGroup((long)groupId);
                if (group == null) {
                    User user;
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("No group exists with friendly URL " + groupId + ". Try fetching by screen name instead."));
                    }
                    if ((user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)screenName)) != null) {
                        group = user.getGroup();
                    } else if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No user or group exists with friendly URL " + groupId));
                    }
                }
            }
        }
        if (group == null) {
            StringBundler sb = new StringBundler(5);
            sb.append("{companyId=");
            sb.append(companyId);
            sb.append(", friendlyURL=");
            sb.append(friendlyURL);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString());
        }
        friendlyURL = null;
        if (pos != -1 && pos + 1 != path.length()) {
            friendlyURL = path.substring(pos);
        }
        if (Validator.isNull((String)friendlyURL)) {
            request.setAttribute("REDIRECT_TO_DEFAULT_LAYOUT", (Object)Boolean.TRUE);
        }
        HashMap<String, HttpServletRequest> requestContext = new HashMap<String, HttpServletRequest>();
        requestContext.put("request", request);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        if (Validator.isNotNull((String)friendlyURL)) {
            LayoutFriendlyURLComposite layoutFriendlyURLComposite = PortalUtil.getLayoutFriendlyURLComposite((long)group.getGroupId(), (boolean)this._private, (String)friendlyURL, params, requestContext);
            Layout layout = layoutFriendlyURLComposite.getLayout();
            String layoutFriendlyURLCompositeFriendlyURL = layoutFriendlyURLComposite.getFriendlyURL();
            pos = layoutFriendlyURLCompositeFriendlyURL.indexOf("/-/");
            if (pos != 0) {
                Locale locale;
                if (pos != -1) {
                    layoutFriendlyURLCompositeFriendlyURL = layoutFriendlyURLCompositeFriendlyURL.substring(0, pos);
                }
                if (!StringUtil.equalsIgnoreCase((String)layoutFriendlyURLCompositeFriendlyURL, (String)layout.getFriendlyURL(locale = PortalUtil.getLocale((HttpServletRequest)request)))) {
                    Locale originalLocale = this.setAlternativeLayoutFriendlyURL(request, layout, layoutFriendlyURLCompositeFriendlyURL);
                    String redirect = PortalUtil.getLocalizedFriendlyURL((HttpServletRequest)request, (Layout)layout, (Locale)locale, (Locale)originalLocale);
                    return new Object[]{redirect, Boolean.TRUE};
                }
            }
        }
        String actualURL = PortalUtil.getActualURL((long)group.getGroupId(), (boolean)this._private, (String)mainPath, (String)friendlyURL, params, requestContext);
        return new Object[]{actualURL, Boolean.FALSE};
    }

    protected Locale setAlternativeLayoutFriendlyURL(HttpServletRequest request, Layout layout, String friendlyURL) throws Exception {
        List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid(), (String)friendlyURL, (int)0, (int)1);
        if (layoutFriendlyURLs.isEmpty()) {
            return null;
        }
        LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)layoutFriendlyURLs.get(0);
        Locale locale = LocaleUtil.fromLanguageId((String)layoutFriendlyURL.getLanguageId());
        String alternativeLayoutFriendlyURL = PortalUtil.getLocalizedFriendlyURL((HttpServletRequest)request, (Layout)layout, (Locale)locale, (Locale)locale);
        SessionMessages.add((HttpServletRequest)request, (String)"alternativeLayoutFriendlyURL", (Object)alternativeLayoutFriendlyURL);
        PortalMessages.add((HttpServletRequest)request, (String)"jspPath", (Object)"/html/common/themes/layout_friendly_url_redirect.jsp");
        return locale;
    }
}

