/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.dao.shard.ShardDataSourceTargetSource;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.events.StartupAction;
import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.servlet.SerializableSessionAttributeListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletFilter;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.model.User;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.jaas.JAASHelper;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.server.capabilities.ServerCapabilitiesUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.I18nServlet;
import com.liferay.portal.servlet.filters.absoluteredirects.AbsoluteRedirectsResponse;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.setup.SetupWizardUtil;
import com.liferay.portal.struts.PortletRequestProcessor;
import com.liferay.portal.struts.StrutsUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.ExtRegistry;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.portlet.social.util.SocialConfigurationUtil;
import com.liferay.util.ContentUtil;
import com.liferay.util.servlet.EncryptedServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;

public class MainServlet
extends ActionServlet {
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_DEFAULT = StringUtil.equalsIgnoreCase((String)PropsValues.HTTP_HEADER_VERSION_VERBOSITY, (String)ReleaseInfo.getName());
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_PARTIAL = StringUtil.equalsIgnoreCase((String)PropsValues.HTTP_HEADER_VERSION_VERBOSITY, (String)"partial");
    private static final String _LIFERAY_PORTAL_REQUEST_HEADER = "Liferay-Portal";
    private static Log _log = LogFactoryUtil.getLog(MainServlet.class);

    public void destroy() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy plugins");
        }
        PortalLifecycleUtil.flushDestroys();
        List portlets = PortletLocalServiceUtil.getPortlets();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy portlets");
        }
        try {
            this.destroyPortlets(portlets);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy companies");
        }
        try {
            this.destroyCompanies();
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process global shutdown events");
        }
        try {
            this.processGlobalShutdownEvents();
        }
        catch (Exception e4) {
            _log.error((Object)e4, (Throwable)e4);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy");
        }
        this.callParentDestroy();
    }

    public void init() throws ServletException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize");
        }
        ServletContext servletContext = this.getServletContext();
        servletContext.setAttribute(MainServlet.class.getName(), (Object)Boolean.TRUE);
        this.callParentInit();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize listeners");
        }
        this.initListeners();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process startup events");
        }
        try {
            this.processStartupEvents();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            System.out.println("Stopping the server due to unexpected startup errors");
            System.exit(0);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize server detector");
        }
        try {
            this.initServerDetector();
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize plugin package");
        }
        PluginPackage pluginPackage = null;
        try {
            pluginPackage = this.initPluginPackage();
        }
        catch (Exception e4) {
            _log.error((Object)e4, (Throwable)e4);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize portlets");
        }
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        try {
            portlets.addAll(this.initPortlets(pluginPackage));
        }
        catch (Exception e5) {
            _log.error((Object)e5, (Throwable)e5);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize layout templates");
        }
        try {
            this.initLayoutTemplates(pluginPackage, portlets);
        }
        catch (Exception e6) {
            _log.error((Object)e6, (Throwable)e6);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize social");
        }
        try {
            this.initSocial(pluginPackage);
        }
        catch (Exception e7) {
            _log.error((Object)e7, (Throwable)e7);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize themes");
        }
        try {
            this.initThemes(pluginPackage, portlets);
        }
        catch (Exception e8) {
            _log.error((Object)e8, (Throwable)e8);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize web settings");
        }
        try {
            this.initWebSettings();
        }
        catch (Exception e9) {
            _log.error((Object)e9, (Throwable)e9);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize extension environment");
        }
        try {
            this.initExt();
        }
        catch (Exception e10) {
            _log.error((Object)e10, (Throwable)e10);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process global startup events");
        }
        try {
            this.processGlobalStartupEvents();
        }
        catch (Exception e11) {
            _log.error((Object)e11, (Throwable)e11);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize resource actions");
        }
        try {
            this.initResourceActions(portlets);
        }
        catch (Exception e12) {
            _log.error((Object)e12, (Throwable)e12);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize companies");
        }
        try {
            this.initCompanies();
        }
        catch (Exception e13) {
            _log.error((Object)e13, (Throwable)e13);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize plugins");
        }
        try {
            this.initPlugins();
        }
        catch (Exception e14) {
            _log.error((Object)e14, (Throwable)e14);
        }
        servletContext.setAttribute("STARTUP_FINISHED", (Object)true);
        ThreadLocalCacheManager.clearAll((Lifecycle)Lifecycle.REQUEST);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long companyId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process service request");
        }
        if (this.processShutdownRequest(request, response)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed shutdown request");
            }
            return;
        }
        if (this.processMaintenanceRequest(request, response)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed maintenance request");
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Get company id");
        }
        if (this.processCompanyInactiveRequest(request, response, companyId = this.getCompanyId(request))) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed company inactive request");
            }
            return;
        }
        try {
            if (this.processGroupInactiveRequest(request, response)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Processed site inactive request");
                }
                return;
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchLayoutException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e2, (Throwable)e2);
                }
            }
            _log.error((Object)e2, (Throwable)e2);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Set portal port");
        }
        this.setPortalPort(request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check variables");
        }
        this.checkServletContext(request);
        this.checkPortletRequestProcessor(request);
        this.checkTilesDefinitionsFactory();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Handle non-serializable request");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Encrypt request");
        }
        request = this.encryptRequest(request, companyId);
        long userId = this.getUserId(request);
        String remoteUser = this.getRemoteUser(request, userId);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Protect request");
        }
        request = this.protectRequest(request, remoteUser);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Set principal");
        }
        String password = this.getPassword(request);
        this.setPrincipal(companyId, userId, remoteUser, password);
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Authenticate user id " + userId + " and remote user " + remoteUser));
            }
            userId = this.loginUser(request, response, companyId, userId, remoteUser);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Authenticated user id " + userId));
            }
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Set session thread local");
        }
        PortalSessionThreadLocal.setHttpSession((HttpSession)request.getSession());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process service pre events");
        }
        if (this.processServicePre(request, response, userId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing service pre events has errors");
            }
            return;
        }
        if (this.hasAbsoluteRedirect(request)) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                _log.debug((Object)("Current URL " + currentURL + " has absolute redirect"));
            }
            return;
        }
        if (!this.hasThemeDisplay(request)) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                _log.debug((Object)("Current URL " + currentURL + " does not have a theme display"));
            }
            return;
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Call parent service");
            }
            this.callParentService(request, response);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Process service post events");
            }
            this.processServicePost(request, response);
        }
    }

    protected void callParentDestroy() {
        super.destroy();
    }

    protected void callParentInit() throws ServletException {
        super.init();
    }

    protected void callParentService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.service(request, response);
    }

    protected void checkPortletRequestProcessor(HttpServletRequest request) throws ServletException {
        ServletContext servletContext = this.getServletContext();
        PortletRequestProcessor portletReqProcessor = (PortletRequestProcessor)((Object)servletContext.getAttribute("PORTLET_STRUTS_PROCESSOR"));
        if (portletReqProcessor == null) {
            ModuleConfig moduleConfig = this.getModuleConfig(request);
            portletReqProcessor = PortletRequestProcessor.getInstance(this, moduleConfig);
            servletContext.setAttribute("PORTLET_STRUTS_PROCESSOR", (Object)portletReqProcessor);
        }
    }

    protected void checkServletContext(HttpServletRequest request) {
        ServletContext servletContext = this.getServletContext();
        request.setAttribute("CTX", (Object)servletContext);
        String contextPath = request.getContextPath();
        servletContext.setAttribute("CTX_PATH", (Object)contextPath);
    }

    protected void checkTilesDefinitionsFactory() {
        ServletContext servletContext = this.getServletContext();
        if (servletContext.getAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY") != null) {
            return;
        }
        servletContext.setAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY", servletContext.getAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY"));
    }

    protected void checkWebSettings(String xml) throws DocumentException {
        Document doc = SAXReaderUtil.read((String)xml);
        Element root = doc.getRootElement();
        int timeout = PropsValues.SESSION_TIMEOUT;
        Element sessionConfig = root.element("session-config");
        if (sessionConfig != null) {
            String sessionTimeout = sessionConfig.elementText("session-timeout");
            timeout = GetterUtil.getInteger((String)sessionTimeout, (int)timeout);
        }
        PropsUtil.set("session.timeout", String.valueOf(timeout));
        PropsValues.SESSION_TIMEOUT = timeout;
        I18nServlet.setLanguageIds(root);
        I18nFilter.setLanguageIds(I18nServlet.getLanguageIds());
    }

    protected void destroyCompanies() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIds();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            this.destroyCompany(companyId);
            ++n2;
        }
    }

    protected void destroyCompany(long companyId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process shutdown events");
        }
        try {
            EventsProcessorUtil.process("application.shutdown.events", PropsValues.APPLICATION_SHUTDOWN_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected void destroyPortlets(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            PortletInstanceFactoryUtil.destroy((Portlet)portlet);
        }
    }

    protected HttpServletRequest encryptRequest(HttpServletRequest request, long companyId) {
        boolean encryptRequest = ParamUtil.getBoolean((HttpServletRequest)request, (String)"shuo");
        if (!encryptRequest) {
            return request;
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
            request = new EncryptedServletRequest(request, company.getKeyObj());
        }
        catch (Exception exception) {}
        return request;
    }

    protected long getCompanyId(HttpServletRequest request) {
        return PortalInstances.getCompanyId(request);
    }

    protected String getPassword(HttpServletRequest request) {
        return PortalUtil.getUserPassword((HttpServletRequest)request);
    }

    protected String getRemoteUser(HttpServletRequest request, long userId) {
        HttpSession session;
        String jRemoteUser;
        String remoteUser = request.getRemoteUser();
        if (!PropsValues.PORTAL_JAAS_ENABLE && (jRemoteUser = (String)(session = request.getSession()).getAttribute("j_remoteuser")) != null) {
            remoteUser = jRemoteUser;
            session.removeAttribute("j_remoteuser");
        }
        if (userId > 0L && remoteUser == null) {
            remoteUser = String.valueOf(userId);
        }
        return remoteUser;
    }

    protected synchronized RequestProcessor getRequestProcessor(ModuleConfig moduleConfig) throws ServletException {
        String key;
        ServletContext servletContext = this.getServletContext();
        RequestProcessor requestProcessor = (RequestProcessor)servletContext.getAttribute(key = "org.apache.struts.action.REQUEST_PROCESSOR" + moduleConfig.getPrefix());
        if (requestProcessor == null) {
            ControllerConfig controllerConfig = moduleConfig.getControllerConfig();
            try {
                requestProcessor = (RequestProcessor)InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)controllerConfig.getProcessorClass());
            }
            catch (Exception e2) {
                throw new ServletException((Throwable)e2);
            }
            requestProcessor.init((ActionServlet)this, moduleConfig);
            servletContext.setAttribute(key, (Object)requestProcessor);
        }
        return requestProcessor;
    }

    protected long getUserId(HttpServletRequest request) {
        return PortalUtil.getUserId((HttpServletRequest)request);
    }

    protected boolean hasAbsoluteRedirect(HttpServletRequest request) {
        return request.getAttribute(AbsoluteRedirectsResponse.class.getName()) != null;
    }

    protected boolean hasThemeDisplay(HttpServletRequest request) {
        return request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY") != null;
    }

    protected void initCompanies() throws Exception {
        ServletContext servletContext = this.getServletContext();
        try {
            String[] webIds;
            String[] stringArray = webIds = PortalInstances.getWebIds();
            int n = webIds.length;
            int n2 = 0;
            while (n2 < n) {
                String webId = stringArray[n2];
                PortalInstances.initCompany(servletContext, webId);
                ++n2;
            }
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)PortalInstances.getDefaultCompanyId());
            ShardDataSourceTargetSource shardDataSourceTargetSource = (ShardDataSourceTargetSource)InfrastructureUtil.getShardDataSourceTargetSource();
            if (shardDataSourceTargetSource != null) {
                shardDataSourceTargetSource.resetDataSource();
            }
        }
    }

    protected void initExt() throws Exception {
        ServletContext servletContext = this.getServletContext();
        ExtRegistry.registerPortal(servletContext);
    }

    protected void initLayoutTemplates(PluginPackage pluginPackage, List<Portlet> portlets) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-layout-templates.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-layout-templates-ext.xml"))};
        List layoutTemplates = LayoutTemplateLocalServiceUtil.init((ServletContext)servletContext, (String[])xmls, (PluginPackage)pluginPackage);
        servletContext.setAttribute("PLUGIN_LAYOUT_TEMPLATES", (Object)layoutTemplates);
    }

    protected void initListeners() {
        SerializableSessionAttributeListener.initialize();
    }

    protected PluginPackage initPluginPackage() throws Exception {
        ServletContext servletContext = this.getServletContext();
        return PluginPackageUtil.readPluginPackageServletContext(servletContext);
    }

    protected void initPlugins() throws Exception {
        if (SetupWizardUtil.isSetupFinished()) {
            HotDeployUtil.setCapturePrematureEvents((boolean)false);
            PortalLifecycleUtil.flushInits();
        }
    }

    protected void initPortletApp(Portlet portlet, ServletContext servletContext) throws PortletException {
        PortletApp portletApp = portlet.getPortletApp();
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        Set portletFilters = portletApp.getPortletFilters();
        for (PortletFilter portletFilter : portletFilters) {
            PortletFilterFactory.create(portletFilter, portletContext);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    protected List<Portlet> initPortlets(PluginPackage pluginPackage) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet-custom.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/portlet-ext.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-portlet.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-portlet-ext.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/web.xml"))};
        PortletLocalServiceUtil.initEAR((ServletContext)servletContext, (String[])xmls, (PluginPackage)pluginPackage);
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(ClassLoaderUtil.getPortalClassLoader());
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(false);
        List portlets = PortletLocalServiceUtil.getPortlets();
        int i2 = 0;
        while (i2 < portlets.size()) {
            Portlet portlet = (Portlet)portlets.get(i2);
            portletBagFactory.create(portlet);
            if (i2 == 0) {
                this.initPortletApp(portlet, servletContext);
            }
            ++i2;
        }
        servletContext.setAttribute("PLUGIN_PORTLETS", (Object)portlets);
        return portlets;
    }

    protected void initResourceActions(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            List portletActions = ResourceActionsUtil.getPortletResourceActions((Portlet)portlet);
            ResourceActionLocalServiceUtil.checkResourceActions((String)portlet.getPortletId(), (List)portletActions);
            List modelNames = ResourceActionsUtil.getPortletModelResources((String)portlet.getPortletId());
            for (String modelName : modelNames) {
                List modelActions = ResourceActionsUtil.getModelResourceActions((String)modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)modelActions);
            }
        }
    }

    protected void initServerDetector() throws Exception {
        ServerCapabilitiesUtil.determineServerCapabilities(this.getServletContext());
    }

    protected void initSocial(PluginPackage pluginPackage) throws Exception {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-social.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-social-ext.xml"))};
        SocialConfigurationUtil.read((ClassLoader)classLoader, (String[])xmls);
    }

    protected void initThemes(PluginPackage pluginPackage, List<Portlet> portlets) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-look-and-feel.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-look-and-feel-ext.xml"))};
        List themes = ThemeLocalServiceUtil.init((ServletContext)servletContext, null, (boolean)true, (String[])xmls, (PluginPackage)pluginPackage);
        servletContext.setAttribute("PLUGIN_THEMES", (Object)themes);
    }

    protected void initWebSettings() throws Exception {
        ServletContext servletContext = this.getServletContext();
        String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/web.xml"));
        this.checkWebSettings(xml);
    }

    protected long loginUser(HttpServletRequest request, HttpServletResponse response, long companyId, long userId, String remoteUser) throws PortalException, SystemException {
        if (userId > 0L || remoteUser == null) {
            return userId;
        }
        userId = PropsValues.PORTAL_JAAS_ENABLE ? JAASHelper.getJaasUserId(companyId, remoteUser) : GetterUtil.getLong((String)remoteUser);
        EventsProcessorUtil.process("login.events.pre", PropsValues.LOGIN_EVENTS_PRE, request, response);
        User user = UserLocalServiceUtil.getUserById((long)userId);
        if (PropsValues.USERS_UPDATE_LAST_LOGIN) {
            UserLocalServiceUtil.updateLastLogin((long)userId, (String)request.getRemoteAddr());
        }
        HttpSession session = request.getSession();
        session.setAttribute("USER", (Object)user);
        session.setAttribute("USER_ID", (Object)new Long(userId));
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)user.getLocale());
        EventsProcessorUtil.process("login.events.post", PropsValues.LOGIN_EVENTS_POST, request, response);
        return userId;
    }

    protected boolean processCompanyInactiveRequest(HttpServletRequest request, HttpServletResponse response, long companyId) throws IOException {
        if (PortalInstances.isCompanyActive(companyId)) {
            return false;
        }
        this.processInactiveRequest(request, response, "this-instance-is-inactive-please-contact-the-administrator");
        return true;
    }

    protected void processGlobalShutdownEvents() throws Exception {
        EventsProcessorUtil.process("global.shutdown.events", PropsValues.GLOBAL_SHUTDOWN_EVENTS);
        super.destroy();
    }

    protected void processGlobalStartupEvents() throws Exception {
        EventsProcessorUtil.process("global.startup.events", PropsValues.GLOBAL_STARTUP_EVENTS);
    }

    protected boolean processGroupInactiveRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException, SystemException {
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid <= 0L) {
            return false;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group group = layout.getGroup();
        if (group.isActive()) {
            return false;
        }
        this.processInactiveRequest(request, response, "this-site-is-inactive-please-contact-the-administrator");
        return true;
    }

    protected void processInactiveRequest(HttpServletRequest request, HttpServletResponse response, String messageKey) throws IOException {
        response.setContentType("text/html; charset=UTF-8");
        Locale locale = LocaleUtil.getDefault();
        String message = LanguageUtil.get((Locale)locale, (String)messageKey);
        String html = ContentUtil.get((String)"com/liferay/portal/dependencies/inactive.html");
        html = StringUtil.replace((String)html, (String)"[$MESSAGE$]", (String)message);
        PrintWriter printWriter = response.getWriter();
        printWriter.print(html);
    }

    protected boolean processMaintenanceRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!MaintenanceUtil.isMaintaining()) {
            return false;
        }
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/html/portal/maintenance.jsp");
        requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        return true;
    }

    protected void processServicePost(HttpServletRequest request, HttpServletResponse response) {
        try {
            EventsProcessorUtil.process("servlet.service.events.post", PropsValues.SERVLET_SERVICE_EVENTS_POST, request, response);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected boolean processServicePre(HttpServletRequest request, HttpServletResponse response, long userId) throws IOException, ServletException {
        try {
            EventsProcessorUtil.process("servlet.service.events.pre", PropsValues.SERVLET_SERVICE_EVENTS_PRE, request, response);
        }
        catch (Exception e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof NoSuchLayoutException) {
                this.sendError(404, cause, request, response);
                return true;
            }
            if (cause instanceof PrincipalException) {
                this.processServicePrePrincipalException(cause, userId, request, response);
                return true;
            }
            _log.error((Object)e2, (Throwable)e2);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e2);
            ServletContext servletContext = this.getServletContext();
            StrutsUtil.forward(PropsValues.SERVLET_SERVICE_EVENTS_PRE_ERROR_PAGE, servletContext, request, response);
            return true;
        }
        if (!_HTTP_HEADER_VERSION_VERBOSITY_DEFAULT) {
            if (_HTTP_HEADER_VERSION_VERBOSITY_PARTIAL) {
                response.addHeader(_LIFERAY_PORTAL_REQUEST_HEADER, ReleaseInfo.getName());
            } else {
                response.addHeader(_LIFERAY_PORTAL_REQUEST_HEADER, ReleaseInfo.getReleaseInfo());
            }
        }
        return false;
    }

    protected void processServicePrePrincipalException(Throwable t, long userId, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (userId > 0L) {
            this.sendError(401, t, request, response);
            return;
        }
        String redirect = PortalUtil.getPathMain().concat("/portal/login");
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        redirect = HttpUtil.addParameter((String)redirect, (String)"redirect", (String)currentURL);
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid > 0L) {
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                Group group = layout.getGroup();
                plid = group.getDefaultPublicPlid();
                if (plid == 0L || group.isStagingGroup()) {
                    Group guestGroup = GroupLocalServiceUtil.getGroup((long)layout.getCompanyId(), (String)"Guest");
                    plid = guestGroup.getDefaultPublicPlid();
                }
                redirect = HttpUtil.addParameter((String)redirect, (String)"p_l_id", (long)plid);
            }
            catch (Exception exception) {}
        }
        response.sendRedirect(redirect);
    }

    protected boolean processShutdownRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ShutdownUtil.isShutdown()) {
            return false;
        }
        String messageKey = ShutdownUtil.getMessage();
        if (Validator.isNull((String)messageKey)) {
            messageKey = "the-system-is-shutdown-please-try-again-later";
        }
        this.processInactiveRequest(request, response, messageKey);
        return true;
    }

    protected void processStartupEvents() throws Exception {
        StartupAction startupAction = new StartupAction();
        startupAction.run(null);
    }

    protected HttpServletRequest protectRequest(HttpServletRequest request, String remoteUser) {
        return new ProtectedServletRequest(request, remoteUser);
    }

    protected void sendError(int status, Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DynamicServletRequest dynamicRequest = new DynamicServletRequest(request);
        dynamicRequest.setParameter("p_l_id", "");
        dynamicRequest.setParameter("groupId", "");
        dynamicRequest.setParameter("layoutId", "");
        dynamicRequest.setParameter("privateLayout", "");
        PortalUtil.sendError((int)status, (Exception)((Exception)t), (HttpServletRequest)dynamicRequest, (HttpServletResponse)response);
    }

    protected void setPortalPort(HttpServletRequest request) {
        PortalUtil.setPortalPort((HttpServletRequest)request);
    }

    protected void setPrincipal(long companyId, long userId, String remoteUser, String password) {
        if (userId == 0L && remoteUser == null) {
            return;
        }
        String name = String.valueOf(userId);
        if (PropsValues.PORTAL_JAAS_ENABLE) {
            long remoteUserId;
            block7: {
                remoteUserId = 0L;
                try {
                    remoteUserId = JAASHelper.getJaasUserId(companyId, remoteUser);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Throwable)e2);
                }
            }
            if (remoteUserId > 0L) {
                name = String.valueOf(remoteUserId);
            }
        } else if (remoteUser != null) {
            name = remoteUser;
        }
        PrincipalThreadLocal.setName((String)name);
        PrincipalThreadLocal.setPassword((String)password);
    }
}

