/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.deploy.BaseDeployer;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.bridges.alloy.AlloyPortlet;
import com.liferay.util.bridges.mvc.MVCPortlet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PortletDeployer
extends BaseDeployer {
    public static final String JSF_STANDARD = "javax.portlet.faces.GenericFacesPortlet";

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        ArrayList<String> wars = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.endsWith(".war")) {
                wars.add(arg);
            } else if (arg.endsWith(".jar")) {
                jars.add(arg);
            }
            ++n2;
        }
        new PortletDeployer(wars, jars);
    }

    public PortletDeployer() {
    }

    public PortletDeployer(List<String> wars, List<String> jars) {
        super(wars, jars);
    }

    @Override
    public void checkArguments() {
        super.checkArguments();
        if (Validator.isNull((String)this.portletTaglibDTD)) {
            throw new IllegalArgumentException("The system property deployer.portlet.taglib.dtd is not set");
        }
    }

    @Override
    public void copyXmls(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        super.copyXmls(srcFile, displayName, pluginPackage);
        this.copyTomcatContextXml(srcFile);
        this.copyDependencyXml("_servlet_context_include.jsp", srcFile + "/WEB-INF/jsp");
    }

    @Override
    public String getExtraContent(double webXmlVersion, File srcFile, String displayName) throws Exception {
        StringBundler sb = new StringBundler();
        if (ServerDetector.isWebSphere()) {
            sb.append("<context-param>");
            sb.append("<param-name>");
            sb.append("com.ibm.websphere.portletcontainer.");
            sb.append("PortletDeploymentEnabled");
            sb.append("</param-name>");
            sb.append("<param-value>false</param-value>");
            sb.append("</context-param>");
        }
        File portletXML = new File(srcFile + "/WEB-INF/" + "portlet.xml");
        File webXML = new File(srcFile + "/WEB-INF/web.xml");
        this.updatePortletXML(portletXML);
        sb.append(this.getServletContent(portletXML, webXML));
        this.setupAlloy(srcFile, portletXML);
        String extraContent = super.getExtraContent(webXmlVersion, srcFile, displayName);
        sb.append(extraContent);
        return sb.toString();
    }

    @Override
    public String getExtraFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        StringBundler sb = new StringBundler(4);
        String extraFiltersContent = super.getExtraFiltersContent(webXmlVersion, srcFile);
        sb.append(extraFiltersContent);
        sb.append(this.getIgnoreFiltersContent(srcFile));
        sb.append(this.getSpeedFiltersContent(srcFile));
        sb.append(this.getServletContextIncludeFiltersContent(webXmlVersion, srcFile));
        return sb.toString();
    }

    @Override
    public String getPluginType() {
        return "portlet";
    }

    public String getServletContent(File portletXML, File webXML) throws Exception {
        StringBundler sb = new StringBundler();
        Document document = SAXReaderUtil.read((File)portletXML);
        Element rootElement = document.getRootElement();
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            String portletName = PortalUtil.getJsSafePortletId((String)portletElement.elementText("portlet-name"));
            String portletClassName = portletElement.elementText("portlet-class");
            String servletName = String.valueOf(portletName) + " Servlet";
            sb.append("<servlet>");
            sb.append("<servlet-name>");
            sb.append(servletName);
            sb.append("</servlet-name>");
            sb.append("<servlet-class>");
            sb.append("com.liferay.portal.kernel.servlet.PortletServlet");
            sb.append("</servlet-class>");
            sb.append("<init-param>");
            sb.append("<param-name>portlet-class</param-name>");
            sb.append("<param-value>");
            sb.append(portletClassName);
            sb.append("</param-value>");
            sb.append("</init-param>");
            sb.append("<load-on-startup>1</load-on-startup>");
            sb.append("</servlet>");
            sb.append("<servlet-mapping>");
            sb.append("<servlet-name>");
            sb.append(servletName);
            sb.append("</servlet-name>");
            sb.append("<url-pattern>/");
            sb.append(portletName);
            sb.append("/*</url-pattern>");
            sb.append("</servlet-mapping>");
        }
        return sb.toString();
    }

    public void setupAlloy(File srcFile, File portletXML) throws Exception {
        Document document = SAXReaderUtil.read((File)portletXML);
        Element rootElement = document.getRootElement();
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            String[] dirNames;
            String portletClassName = portletElement.elementText("portlet-class");
            if (!portletClassName.contains(AlloyPortlet.class.getSimpleName())) continue;
            String[] stringArray = dirNames = FileUtil.listDirs((String)(srcFile + "/WEB-INF/jsp"));
            int n = dirNames.length;
            int n2 = 0;
            while (n2 < n) {
                String dirName = stringArray[n2];
                File dir = new File(srcFile + "/WEB-INF/jsp/" + dirName + "/views");
                if (dir.exists() && dir.isDirectory()) {
                    this.copyDependencyXml("touch.jsp", dir.toString());
                }
                ++n2;
            }
            break block0;
        }
    }

    @Override
    public void updateDeployDirectory(File srcFile) throws Exception {
        boolean customPortletXML = false;
        try {
            customPortletXML = PrefsPropsUtil.getBoolean("auto.deploy.custom.portlet.xml", PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML);
        }
        catch (Exception exception) {
            customPortletXML = PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML;
        }
        customPortletXML = GetterUtil.getBoolean((String)System.getProperty("deployer.custom.portlet.xml"), (boolean)customPortletXML);
        if (!customPortletXML) {
            return;
        }
        File portletXML = new File(srcFile + "/WEB-INF/" + "portlet.xml");
        if (portletXML.exists()) {
            File portletCustomXML = new File(srcFile + "/WEB-INF/" + "portlet-custom.xml");
            if (portletCustomXML.exists()) {
                portletCustomXML.delete();
            }
            portletXML.renameTo(portletCustomXML);
        }
    }

    public void updatePortletXML(File portletXML) throws Exception {
        if (!portletXML.exists()) {
            return;
        }
        String content = FileUtil.read((File)portletXML);
        content = StringUtil.replace((String)content, (String)"com.liferay.util.bridges.jsp.JSPPortlet", (String)MVCPortlet.class.getName());
        FileUtil.write((File)portletXML, (String)content);
    }
}

