/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.seleniumbuilder;

import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class SeleniumBuilderFileUtil {
    private static final String _TPL_ROOT = "com/liferay/portal/tools/seleniumbuilder/dependencies/";
    private static List<String> _allowedNullAttributes = ListUtil.fromArray((Object[])new String[]{"arg1", "arg2", "message", "string", "substring", "value"});
    private static List<String> _allowedVarAttributes = ListUtil.fromArray((Object[])new String[]{"attribute", "line-number", "locator", "locator-key", "name", "path", "value"});
    private static List<String> _methodNames = ListUtil.fromArray((Object[])new String[]{"getFirstNumber", "increment", "length", "lowercase", "replace"});
    private static List<String> _reservedTags = ListUtil.fromArray((Object[])new String[]{"and", "case", "command", "condition", "contains", "default", "definition", "echo", "else", "elseif", "equals", "execute", "fail", "if", "isset", "not", "or", "set-up", "td", "tear-down", "then", "tr", "while", "var"});
    private String _baseDir;

    public SeleniumBuilderFileUtil(String baseDir) {
        this._baseDir = baseDir;
    }

    public String escapeHtml(String input) {
        return StringEscapeUtils.escapeHtml((String)input);
    }

    public String escapeJava(String input) {
        return StringEscapeUtils.escapeJava((String)input);
    }

    public List<Element> getAllChildElements(Element element, String elementName) {
        ArrayList<Element> allChildElements = new ArrayList<Element>();
        List childElements = element.elements();
        if (childElements.isEmpty()) {
            return allChildElements;
        }
        for (Element childElement : childElements) {
            String childElementName = childElement.getName();
            if (childElementName.equals(elementName)) {
                allChildElements.add(childElement);
            }
            allChildElements.addAll(this.getAllChildElements(childElement, elementName));
        }
        return allChildElements;
    }

    public String getBaseDir() {
        return this._baseDir;
    }

    public Set<String> getChildElementAttributeValues(Element element, String attributeName) {
        TreeSet<String> childElementAttributeValues = new TreeSet<String>();
        List childElements = element.elements();
        if (childElements.isEmpty()) {
            return childElementAttributeValues;
        }
        for (Element childElement : childElements) {
            int x;
            String childElementName = childElement.attributeValue(attributeName);
            if (childElementName != null && (x = childElementName.lastIndexOf("#")) != -1) {
                childElementAttributeValues.add(childElementName.substring(0, x));
            }
            childElementAttributeValues.addAll(this.getChildElementAttributeValues(childElement, attributeName));
        }
        return childElementAttributeValues;
    }

    public String getClassName(String fileName) {
        String classSuffix = this.getClassSuffix(fileName);
        return this.getClassName(fileName, classSuffix);
    }

    public String getClassName(String fileName, String classSuffix) {
        return String.valueOf(this.getPackageName(fileName)) + "." + this.getSimpleClassName(fileName, classSuffix);
    }

    public String getClassSimpleClassName(String className) {
        int x = className.lastIndexOf(46);
        return className.substring(x + 1);
    }

    public String getClassSuffix(String fileName) {
        int x = fileName.indexOf(46);
        String classSuffix = StringUtil.upperCaseFirstLetter((String)fileName.substring(x + 1));
        if (classSuffix.equals("Testcase")) {
            classSuffix = "TestCase";
        }
        return classSuffix;
    }

    public String getHTMLFileName(String fileName) {
        String javaFileName = this.getJavaFileName(fileName);
        return StringUtil.replace((String)javaFileName, (String)".java", (String)".html");
    }

    public String getJavaFileName(String fileName) {
        String classSuffix = this.getClassSuffix(fileName);
        return this.getJavaFileName(fileName, classSuffix);
    }

    public String getJavaFileName(String fileName, String classSuffix) {
        return String.valueOf(this.getPackagePath(fileName)) + "/" + this.getSimpleClassName(fileName, classSuffix) + ".java";
    }

    public int getLocatorCount(Element rootElement) {
        String xml = rootElement.asXML();
        int i2 = 1;
        while (true) {
            if (!xml.contains("${locator" + i2 + "}")) {
                if (i2 > 1) {
                    --i2;
                }
                return i2;
            }
            ++i2;
        }
    }

    public String getName(String fileName) {
        int x = fileName.lastIndexOf("/");
        int y = fileName.lastIndexOf(46);
        return fileName.substring(x + 1, y);
    }

    public String getNormalizedContent(String fileName) throws Exception {
        String content = this.readFile(fileName);
        if (fileName.endsWith(".path")) {
            int x = content.indexOf("<tbody>");
            int y = content.indexOf("</tbody>");
            if (x == -1 || y == -1) {
                this.throwValidationException(1002, fileName, "tbody");
            }
            String pathTbody = content.substring(x, y + 8);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("pathName", this.getName(fileName));
            context.put("pathTbody", pathTbody);
            String newContent = this.processTemplate("path_xml.ftl", context);
            if (!content.equals(newContent)) {
                content = newContent;
                this.writeFile(this.getBaseDir(), fileName, newContent, false);
            }
        }
        StringBundler sb = new StringBundler();
        int lineNumber = 1;
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            Pattern pattern = Pattern.compile("<[a-z\\-]+");
            Matcher matcher = pattern.matcher(line);
            if (matcher.find()) {
                for (String reservedTag : _reservedTags) {
                    if (!line.contains("<" + reservedTag)) continue;
                    line = StringUtil.replace((String)line, (String)matcher.group(), (String)(String.valueOf(matcher.group()) + " line-number=\"" + lineNumber + "\""));
                    break;
                }
            }
            sb.append(line);
            ++lineNumber;
        }
        content = sb.toString();
        if (content != null) {
            content = content.trim();
            content = StringUtil.replace((String)content, (String)"\n", (String)"");
            content = StringUtil.replace((String)content, (String)"\r\n", (String)"");
            content = StringUtil.replace((String)content, (String)"\t", (String)" ");
            content = content.replaceAll(" +", " ");
        }
        return content;
    }

    public String getObjectName(String name) {
        return StringUtil.upperCaseFirstLetter((String)name);
    }

    public String getPackageName(String fileName) {
        String packagePath = this.getPackagePath(fileName);
        return StringUtil.replace((String)packagePath, (String)"/", (String)".");
    }

    public String getPackagePath(String fileName) {
        int x = fileName.lastIndexOf("/");
        return fileName.substring(0, x);
    }

    public String getReturnType(String name) {
        if (name.startsWith("Is")) {
            return "boolean";
        }
        return "void";
    }

    public Element getRootElement(String fileName) throws Exception {
        String content = this.getNormalizedContent(fileName);
        try {
            Document document = SAXReaderUtil.read((String)content, (boolean)true);
            Element rootElement = document.getRootElement();
            this.validate(fileName, rootElement);
            return rootElement;
        }
        catch (DocumentException de) {
            this.throwValidationException(1007, fileName, (Exception)((Object)de));
            return null;
        }
    }

    public String getSimpleClassName(String fileName) {
        String classSuffix = this.getClassSuffix(fileName);
        return this.getSimpleClassName(fileName, classSuffix);
    }

    public String getSimpleClassName(String fileName, String classSuffix) {
        return String.valueOf(this.getName(fileName)) + classSuffix;
    }

    public String getVariableName(String name) {
        return TextFormatter.format((String)name, (int)8);
    }

    public String normalizeFileName(String fileName) {
        return StringUtil.replace((String)fileName, (String)"\\", (String)"/");
    }

    public String readFile(String fileName) throws Exception {
        return FileUtil.read((String)(String.valueOf(this.getBaseDir()) + "/" + fileName));
    }

    public void writeFile(String fileName, String content, boolean format) throws Exception {
        this.writeFile(String.valueOf(this.getBaseDir()) + "-generated", fileName, content, format);
    }

    public void writeFile(String baseDir, String fileName, String content, boolean format) throws Exception {
        File file = new File(String.valueOf(baseDir) + "/" + fileName);
        if (format) {
            ServiceBuilder.writeFile(file, content);
        } else {
            System.out.println("Writing " + file);
            FileUtil.write((File)file, (String)content);
        }
    }

    protected String processTemplate(String name, Map<String, Object> context) throws Exception {
        return StringUtil.strip((String)FreeMarkerUtil.process(_TPL_ROOT + name, context), (char)'\r');
    }

    protected void throwValidationException(int errorCode, String fileName) {
        this.throwValidationException(errorCode, fileName, null, null, null, null, null);
    }

    protected void throwValidationException(int errorCode, String fileName, Element element) {
        this.throwValidationException(errorCode, fileName, element, null, null, null, null);
    }

    protected void throwValidationException(int errorCode, String fileName, Element element, String string1) {
        this.throwValidationException(errorCode, fileName, element, null, string1, null, null);
    }

    protected void throwValidationException(int errorCode, String fileName, Element element, String string1, String string2) {
        this.throwValidationException(errorCode, fileName, element, null, string1, string2, null);
    }

    protected void throwValidationException(int errorCode, String fileName, Element element, String[] array) {
        this.throwValidationException(errorCode, fileName, element, array, null, null, null);
    }

    protected void throwValidationException(int errorCode, String fileName, Element element, String[] array, String string1, String string2, Exception e2) {
        String prefix = "Error " + errorCode + ": ";
        String suffix = fileName;
        if (element != null) {
            suffix = String.valueOf(suffix) + ":" + element.attributeValue("line-number");
        }
        if (errorCode == 1000) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid root element in " + suffix);
        }
        if (errorCode == 1001) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Missing (" + StringUtil.merge((Object[])array, (String)"|") + ") child element in " + suffix);
        }
        if (errorCode == 1002) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid " + string1 + " element in " + suffix);
        }
        if (errorCode == 1003) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Missing " + string1 + " attribute in " + suffix);
        }
        if (errorCode == 1004) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Missing (" + StringUtil.merge((Object[])array, (String)"|") + ") attribute in " + suffix);
        }
        if (errorCode == 1005) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid " + string1 + " attribute in " + suffix);
        }
        if (errorCode == 1006) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid " + string1 + " attribute value in " + suffix);
        }
        if (errorCode == 1007) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Poorly formed XML in " + suffix, e2);
        }
        if (errorCode == 1008) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Duplicate file name " + string1 + " at " + suffix);
        }
        if (errorCode == 1009) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Duplicate command name " + string1 + " at " + suffix);
        }
        if (errorCode == 1010) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid locator-key " + string1 + " at " + suffix);
        }
        if (errorCode == 1011) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid " + string1 + " name " + string2 + " at " + suffix);
        }
        if (errorCode == 1012) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid " + string1 + " command " + string2 + " at " + suffix);
        }
        if (errorCode == 1013) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid method " + string1 + " at " + suffix);
        }
        if (errorCode == 1014) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid path " + string1 + " at " + suffix);
        }
        if (errorCode == 1015) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Poorly formed test case command " + string1 + " at " + suffix);
        }
        if (errorCode == 1016) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Invalid " + string1 + " attribute value " + string2 + " in " + suffix);
        }
        if (errorCode == 2000) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Too many child elements in the " + string1 + " element in " + suffix);
        }
        if (errorCode == 2001) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Action command " + string1 + " does not match a function name at " + suffix);
        }
        if (errorCode == 2002) {
            throw new IllegalArgumentException(String.valueOf(prefix) + "Missing matching " + string1 + ".path for " + suffix);
        }
        throw new IllegalArgumentException(String.valueOf(prefix) + suffix);
    }

    protected void throwValidationException(int errorCode, String fileName, Exception e2) {
        this.throwValidationException(errorCode, fileName, null, null, null, null, e2);
    }

    protected void throwValidationException(int errorCode, String fileName, String string1) {
        this.throwValidationException(errorCode, fileName, null, null, string1, null, null);
    }

    protected void validate(String fileName, Element rootElement) throws Exception {
        if (fileName.endsWith(".action")) {
            this.validateActionDocument(fileName, rootElement);
        } else if (fileName.endsWith(".function")) {
            this.validateFunctionDocument(fileName, rootElement);
        } else if (fileName.endsWith(".macro")) {
            this.validateMacroDocument(fileName, rootElement);
        } else if (fileName.endsWith(".path")) {
            this.validatePathDocument(fileName, rootElement);
        } else if (fileName.endsWith(".testcase")) {
            this.validateTestCaseDocument(fileName, rootElement);
        }
    }

    protected void validateActionCommandElement(String fileName, Element commandElement, String[] allowedBlockChildElementNames, String[] allowedExecuteAttributeNames, String[] allowedExecuteChildElementNames) {
        List elements = commandElement.elements();
        if (elements.isEmpty()) {
            this.throwValidationException(1001, fileName, commandElement, new String[]{"case", "default"});
        }
        for (Element element : elements) {
            List attributes;
            List childElements = element.elements();
            String elementName = element.getName();
            if (childElements.size() > 1) {
                this.throwValidationException(2000, fileName, (Element)childElements.get(1), elementName);
            }
            if (elementName.equals("case")) {
                attributes = element.attributes();
                boolean hasNeededAttributeName = false;
                for (Attribute attribute : attributes) {
                    String attributeValue;
                    String attributeName = attribute.getName();
                    if (attributeName.equals("comparator")) {
                        attributeValue = attribute.getValue();
                        if (!(attributeValue.equals("contains") || attributeValue.equals("endsWith") || attributeValue.equals("equals") || attributeValue.equals("startsWith"))) {
                            this.throwValidationException(1006, fileName, element, attributeName);
                        }
                    } else if (attributeName.startsWith("locator") || attributeName.startsWith("locator-key")) {
                        attributeValue = attribute.getValue();
                        if (Validator.isNull((String)attributeValue)) {
                            this.throwValidationException(1006, fileName, element, attributeName);
                        }
                        hasNeededAttributeName = true;
                    }
                    if (!(attributeName.equals("comparator") || attributeName.equals("line-number") || attributeName.startsWith("locator") || attributeName.startsWith("locator-key"))) {
                        this.throwValidationException(1005, fileName, element, attributeName);
                    }
                    if (!attributeName.equals("locator") && !attributeName.equals("locator-key")) continue;
                    this.throwValidationException(1005, fileName, element, attributeName);
                }
                if (!hasNeededAttributeName) {
                    this.throwValidationException(1004, fileName, element, new String[]{"locator1", "locator-key1"});
                }
                this.validateBlockElement(fileName, element, new String[]{"execute"}, new String[]{"function"}, new String[0], new String[0]);
                continue;
            }
            if (elementName.equals("default")) {
                attributes = element.attributes();
                if (attributes.size() != 1) {
                    Attribute attribute = (Attribute)attributes.get(1);
                    String attributeName = attribute.getName();
                    this.throwValidationException(1005, fileName, element, attributeName);
                }
                this.validateBlockElement(fileName, element, new String[]{"execute"}, new String[]{"function"}, new String[0], new String[0]);
                continue;
            }
            this.throwValidationException(1002, fileName, element, elementName);
        }
    }

    protected void validateActionDocument(String fileName, Element rootElement) {
        List elements;
        if (!Validator.equals((Object)rootElement.getName(), (Object)"definition")) {
            this.throwValidationException(1000, fileName, rootElement);
        }
        if ((elements = rootElement.elements()).isEmpty()) {
            this.throwValidationException(1001, fileName, rootElement, new String[]{"command"});
        }
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("command")) {
                String attributeValue = element.attributeValue("name");
                if (attributeValue == null) {
                    this.throwValidationException(1003, fileName, element, "name");
                } else if (Validator.isNull((String)attributeValue)) {
                    this.throwValidationException(1006, fileName, element, "name");
                }
                this.validateActionCommandElement(fileName, element, new String[]{"execute"}, new String[]{"function"}, new String[0]);
                continue;
            }
            this.throwValidationException(1002, fileName, element, elementName);
        }
    }

    protected void validateBlockElement(String fileName, Element commandElement, String[] allowedBlockChildElementNames, String[] allowedExecuteAttributeNames, String[] allowedExecuteChildElementNames, String[] allowedIfConditionElementNames) {
        List elements = commandElement.elements();
        if (elements.isEmpty()) {
            this.throwValidationException(1001, fileName, commandElement, allowedBlockChildElementNames);
        }
        for (Element element : elements) {
            String elementName = element.getName();
            if (!ArrayUtil.contains((Object[])allowedBlockChildElementNames, (Object)elementName)) {
                this.throwValidationException(1002, fileName, element, elementName);
            }
            if (elementName.equals("echo") || elementName.equals("fail")) {
                this.validateSimpleElement(fileName, element, new String[]{"message"});
                continue;
            }
            if (elementName.equals("execute")) {
                this.validateExecuteElement(fileName, element, allowedExecuteAttributeNames, ".+", allowedExecuteChildElementNames);
                continue;
            }
            if (elementName.equals("if") || elementName.equals("while")) {
                this.validateIfElement(fileName, element, allowedBlockChildElementNames, allowedExecuteAttributeNames, allowedExecuteChildElementNames, allowedIfConditionElementNames);
                continue;
            }
            if (elementName.equals("var")) {
                this.validateVarElement(fileName, element);
                continue;
            }
            this.throwValidationException(1002, fileName, element, elementName);
        }
    }

    protected void validateExecuteElement(String fileName, Element executeElement, String[] allowedExecuteAttributeNames, String allowedExecuteAttributeValuesRegex, String[] allowedExecuteChildElementNames) {
        String attributeName;
        boolean hasAllowedAttributeName = false;
        List attributes = executeElement.attributes();
        for (Attribute attribute : attributes) {
            String attributeName2 = attribute.getName();
            if (!ArrayUtil.contains((Object[])allowedExecuteAttributeNames, (Object)attributeName2)) continue;
            hasAllowedAttributeName = true;
            break;
        }
        if (!hasAllowedAttributeName) {
            this.throwValidationException(1004, fileName, executeElement, allowedExecuteAttributeNames);
        }
        String action = executeElement.attributeValue("action");
        String function = executeElement.attributeValue("function");
        String macro = executeElement.attributeValue("macro");
        String selenium = executeElement.attributeValue("selenium");
        String testCase = executeElement.attributeValue("test-case");
        String testCaseCommand = executeElement.attributeValue("test-case-command");
        String testClass = executeElement.attributeValue("test-class");
        if (action != null) {
            if (Validator.isNull((String)action) || !action.matches(allowedExecuteAttributeValuesRegex)) {
                this.throwValidationException(1006, fileName, executeElement, "action");
            }
            for (Attribute attribute : attributes) {
                attributeName = attribute.getName();
                if (!(attributeName.equals("action") || attributeName.equals("line-number") || attributeName.startsWith("locator") || attributeName.startsWith("locator-key") || attributeName.startsWith("value"))) {
                    this.throwValidationException(1005, fileName, executeElement, attributeName);
                }
                if (!attributeName.equals("locator") && !attributeName.equals("locator-key") && !attributeName.equals("value")) continue;
                this.throwValidationException(1005, fileName, executeElement, attributeName);
            }
        } else if (function != null) {
            if (Validator.isNull((String)function) || !function.matches(allowedExecuteAttributeValuesRegex)) {
                this.throwValidationException(1006, fileName, executeElement, "function");
            }
            for (Attribute attribute : attributes) {
                attributeName = attribute.getName();
                if (!(attributeName.equals("function") || attributeName.equals("line-number") || attributeName.startsWith("locator") || attributeName.startsWith("value"))) {
                    this.throwValidationException(1005, fileName, executeElement, attributeName);
                }
                if (!attributeName.equals("locator") && !attributeName.equals("value")) continue;
                this.throwValidationException(1005, fileName, executeElement, attributeName);
            }
        } else if (macro != null) {
            if (Validator.isNull((String)macro) || !macro.matches(allowedExecuteAttributeValuesRegex)) {
                this.throwValidationException(1006, fileName, executeElement, "macro");
            }
            for (Attribute attribute : attributes) {
                attributeName = attribute.getName();
                if (attributeName.equals("macro") || attributeName.equals("line-number")) continue;
                this.throwValidationException(1005, fileName, executeElement, attributeName);
            }
        } else if (selenium != null) {
            if (Validator.isNull((String)selenium) || !selenium.matches(allowedExecuteAttributeValuesRegex)) {
                this.throwValidationException(1006, fileName, executeElement, "selenium");
            }
            for (Attribute attribute : attributes) {
                attributeName = attribute.getName();
                if (attributeName.equals("argument1") || attributeName.equals("argument2") || attributeName.equals("line-number") || attributeName.equals("selenium")) continue;
                this.throwValidationException(1005, fileName, executeElement, attributeName);
            }
        } else if (testCase != null) {
            if (Validator.isNull((String)testCase) || !testCase.matches(allowedExecuteAttributeValuesRegex)) {
                this.throwValidationException(1006, fileName, executeElement, "test-case");
            }
            for (Attribute attribute : attributes) {
                attributeName = attribute.getName();
                if (attributeName.equals("line-number") || attributeName.equals("test-case")) continue;
                this.throwValidationException(1005, fileName, executeElement, attributeName);
            }
        } else if (testCaseCommand != null) {
            if (Validator.isNull((String)testCaseCommand) || !testCaseCommand.matches(allowedExecuteAttributeValuesRegex)) {
                this.throwValidationException(1006, fileName, executeElement, "test-case-command");
            }
            if (testCaseCommand.contains("#")) {
                int x = testCaseCommand.lastIndexOf("#");
                Iterator testCaseName = testCaseCommand.substring(0, x);
                String testCaseCommandName = testCaseCommand.substring(x + 1);
                if (Validator.isNull((String)testCaseCommandName) || Validator.isNull(testCaseName)) {
                    this.throwValidationException(1015, fileName, executeElement, testCaseCommand);
                }
            } else {
                this.throwValidationException(1015, fileName, executeElement, testCaseCommand);
            }
            for (Attribute attribute : attributes) {
                attributeName = attribute.getName();
                if (attributeName.equals("line-number") || attributeName.equals("test-case-command")) continue;
                this.throwValidationException(1005, fileName, executeElement, attributeName);
            }
        } else if (testClass != null) {
            if (Validator.isNull((String)testClass) || !testClass.matches(allowedExecuteAttributeValuesRegex)) {
                this.throwValidationException(1006, fileName, executeElement, "test-class");
            }
            for (Attribute attribute : attributes) {
                attributeName = attribute.getName();
                if (attributeName.equals("line-number") || attributeName.equals("test-class")) continue;
                this.throwValidationException(1005, fileName, executeElement, attributeName);
            }
        } else {
            this.throwValidationException(0, fileName);
        }
        List elements = executeElement.elements();
        if (allowedExecuteChildElementNames.length == 0) {
            if (!elements.isEmpty()) {
                Element element = (Element)elements.get(0);
                String elementName = element.getName();
                this.throwValidationException(1002, fileName, element, elementName);
            }
        } else {
            String executeElementName = executeElement.getName();
            for (Element element : elements) {
                String elementName = element.getName();
                if (executeElementName.equals("condition")) {
                    this.throwValidationException(1002, fileName, element, elementName);
                }
                if (elementName.equals("var")) {
                    this.validateVarElement(fileName, element);
                    continue;
                }
                this.throwValidationException(1002, fileName, element, elementName);
            }
        }
    }

    protected void validateFunctionDocument(String fileName, Element rootElement) {
        List elements;
        if (!Validator.equals((Object)rootElement.getName(), (Object)"definition")) {
            this.throwValidationException(1000, fileName, rootElement);
        }
        if ((elements = rootElement.elements()).isEmpty()) {
            this.throwValidationException(1001, fileName, rootElement, new String[]{"command"});
        }
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("command")) {
                String attributeValue = element.attributeValue("name");
                if (attributeValue == null) {
                    this.throwValidationException(1003, fileName, element, "name");
                } else if (Validator.isNull((String)attributeValue)) {
                    this.throwValidationException(1006, fileName, element, "name");
                }
                this.validateBlockElement(fileName, element, new String[]{"execute", "if"}, new String[]{"function", "selenium"}, new String[0], new String[]{"condition"});
                continue;
            }
            this.throwValidationException(1002, fileName, element, elementName);
        }
    }

    protected void validateIfElement(String fileName, Element ifElement, String[] allowedBlockChildElementNames, String[] allowedExecuteAttributeNames, String[] allowedExecuteChildElementNames, String[] allowedIfConditionElementNames) {
        List elements = ifElement.elements();
        HashSet<String> elementNames = new HashSet<String>();
        boolean hasAllowedIfConditionElementNames = false;
        for (Element element : elements) {
            String elementName = element.getName();
            elementNames.add(elementName);
            if (ArrayUtil.contains((Object[])allowedIfConditionElementNames, (Object)elementName)) {
                hasAllowedIfConditionElementNames = true;
            }
            String ifElementName = ifElement.getName();
            if (elementName.equals("and") || elementName.equals("not") || elementName.equals("or")) {
                this.validateIfElement(fileName, element, allowedBlockChildElementNames, allowedExecuteAttributeNames, allowedExecuteChildElementNames, allowedIfConditionElementNames);
                continue;
            }
            if (elementName.equals("condition")) {
                this.validateExecuteElement(fileName, element, allowedExecuteAttributeNames, ".*(is|Is).+", allowedExecuteChildElementNames);
                continue;
            }
            if (elementName.equals("contains")) {
                this.validateSimpleElement(fileName, element, new String[]{"string", "substring"});
                continue;
            }
            if (elementName.equals("else")) {
                if (ifElementName.equals("while")) {
                    this.throwValidationException(1002, fileName, element, elementName);
                }
                this.validateBlockElement(fileName, element, allowedBlockChildElementNames, allowedExecuteAttributeNames, allowedExecuteChildElementNames, allowedIfConditionElementNames);
                continue;
            }
            if (elementName.equals("elseif")) {
                if (ifElementName.equals("while")) {
                    this.throwValidationException(1002, fileName, element, elementName);
                }
                this.validateIfElement(fileName, element, allowedBlockChildElementNames, allowedExecuteAttributeNames, allowedExecuteChildElementNames, allowedIfConditionElementNames);
                continue;
            }
            if (elementName.equals("equals")) {
                this.validateSimpleElement(fileName, element, new String[]{"arg1", "arg2"});
                continue;
            }
            if (elementName.equals("isset")) {
                this.validateSimpleElement(fileName, element, new String[]{"var"});
                continue;
            }
            if (elementName.equals("then")) {
                this.validateBlockElement(fileName, element, allowedBlockChildElementNames, allowedExecuteAttributeNames, allowedExecuteChildElementNames, allowedIfConditionElementNames);
                continue;
            }
            this.throwValidationException(1002, fileName, element, elementName);
        }
        if (!hasAllowedIfConditionElementNames) {
            this.throwValidationException(1001, fileName, ifElement, allowedIfConditionElementNames);
        }
        if (Validator.equals((Object)ifElement.getName(), (Object)"and") || Validator.equals((Object)ifElement.getName(), (Object)"not") || Validator.equals((Object)ifElement.getName(), (Object)"or")) {
            return;
        }
        if (!elementNames.contains("then")) {
            this.throwValidationException(1001, fileName, ifElement, new String[]{"then"});
        }
    }

    protected void validateMacroDocument(String fileName, Element rootElement) {
        List elements;
        if (!Validator.equals((Object)rootElement.getName(), (Object)"definition")) {
            this.throwValidationException(1000, fileName, rootElement);
        }
        if ((elements = rootElement.elements()).isEmpty()) {
            this.throwValidationException(1001, fileName, rootElement, new String[]{"command", "var"});
        }
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("command")) {
                String attributeValue = element.attributeValue("name");
                if (attributeValue == null) {
                    this.throwValidationException(1003, fileName, element, "name");
                } else if (Validator.isNull((String)attributeValue)) {
                    this.throwValidationException(1006, fileName, element, "name");
                }
                this.validateBlockElement(fileName, element, new String[]{"echo", "execute", "fail", "if", "var", "while"}, new String[]{"action", "macro"}, new String[]{"var"}, new String[]{"and", "condition", "contains", "equals", "isset", "not", "or"});
                continue;
            }
            if (elementName.equals("var")) {
                this.validateVarElement(fileName, element);
                continue;
            }
            this.throwValidationException(1002, fileName, element, elementName);
        }
    }

    protected void validatePathDocument(String fileName, Element rootElement) {
        Element bodyElement;
        Element tableElement;
        Element theadElement;
        Element trElement;
        Element tdElement;
        String tdText;
        Element headElement = rootElement.element("head");
        Element titleElement = headElement.element("title");
        String title = titleElement.getText();
        int x = fileName.lastIndexOf("/");
        int y = fileName.lastIndexOf(46);
        String shortFileName = fileName.substring(x + 1, y);
        if (title == null || !shortFileName.equals(title)) {
            this.throwValidationException(0, fileName);
        }
        if ((tdText = (tdElement = (trElement = (theadElement = (tableElement = (bodyElement = rootElement.element("body")).element("table")).element("thead")).element("tr")).element("td")).getText()) == null || !shortFileName.equals(tdText)) {
            this.throwValidationException(0, fileName);
        }
        Element tbodyElement = tableElement.element("tbody");
        List elements = tbodyElement.elements();
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("tr")) {
                this.validatePathTrElement(fileName, element);
                continue;
            }
            this.throwValidationException(1002, fileName, element, elementName);
        }
    }

    protected void validatePathTrElement(String fileName, Element trElement) {
        List elements = trElement.elements();
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("td")) continue;
            this.throwValidationException(1002, fileName, element, elementName);
        }
        if (elements.size() < 3) {
            this.throwValidationException(1001, fileName, trElement, new String[]{"td"});
        }
        if (elements.size() > 3) {
            Element element;
            element = (Element)elements.get(3);
            String elementName = element.getName();
            this.throwValidationException(1002, fileName, element, elementName);
        }
    }

    protected void validateSimpleElement(String fileName, Element element, String[] neededAttributes) {
        HashMap<String, Boolean> hasNeededAttributes = new HashMap<String, Boolean>();
        String[] stringArray = neededAttributes;
        int n = neededAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String neededAttribute = stringArray[n2];
            hasNeededAttributes.put(neededAttribute, false);
            ++n2;
        }
        List attributes = element.attributes();
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            String attributeValue = attribute.getValue();
            if (!_allowedNullAttributes.contains(attributeName) && Validator.isNull((String)attributeValue)) {
                this.throwValidationException(1006, fileName, element, attributeName);
            }
            if (hasNeededAttributes.containsKey(attributeName)) {
                hasNeededAttributes.put(attributeName, true);
            }
            if (attributeName.equals("line-number") || hasNeededAttributes.containsKey(attributeName)) continue;
            this.throwValidationException(1005, fileName, element, attributeName);
        }
        String[] stringArray2 = neededAttributes;
        int attributeName = neededAttributes.length;
        int n3 = 0;
        while (n3 < attributeName) {
            String neededAttribute = stringArray2[n3];
            if (!((Boolean)hasNeededAttributes.get(neededAttribute)).booleanValue()) {
                this.throwValidationException(1004, fileName, element, neededAttributes);
            }
            ++n3;
        }
        List childElements = element.elements();
        if (!childElements.isEmpty()) {
            Element childElement = (Element)childElements.get(0);
            String childElementName = childElement.getName();
            this.throwValidationException(1002, fileName, childElement, childElementName);
        }
    }

    protected void validateTestCaseDocument(String fileName, Element rootElement) {
        List elements;
        if (!Validator.equals((Object)rootElement.getName(), (Object)"definition")) {
            this.throwValidationException(1000, fileName, rootElement);
        }
        if ((elements = rootElement.elements()).isEmpty()) {
            this.throwValidationException(1001, fileName, rootElement, new String[]{"command"});
        }
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("command")) {
                String attributeValue = element.attributeValue("name");
                if (attributeValue == null) {
                    this.throwValidationException(1003, fileName, element, "name");
                } else if (Validator.isNull((String)attributeValue)) {
                    this.throwValidationException(1006, fileName, element, "name");
                }
                String priorityValue = element.attributeValue("priority");
                if (priorityValue == null) {
                    this.throwValidationException(1003, fileName, element, "priority");
                } else if (!(priorityValue.equals("1") || priorityValue.equals("2") || priorityValue.equals("3") || priorityValue.equals("4") || priorityValue.equals("5"))) {
                    this.throwValidationException(1006, fileName, element, "priority");
                }
                this.validateBlockElement(fileName, element, new String[]{"execute", "var"}, new String[]{"action", "macro"}, new String[]{"var"}, new String[0]);
                continue;
            }
            if (elementName.equals("set-up") || elementName.equals("tear-down")) {
                List attributes = element.attributes();
                for (Attribute attribute : attributes) {
                    String attributeName = attribute.getName();
                    if (attributeName.equals("line-number")) continue;
                    this.throwValidationException(1005, fileName, element, attributeName);
                }
                this.validateBlockElement(fileName, element, new String[]{"execute", "var"}, new String[]{"action", "macro"}, new String[]{"var"}, new String[0]);
                continue;
            }
            if (elementName.equals("var")) {
                this.validateVarElement(fileName, element);
                continue;
            }
            this.throwValidationException(1002, fileName, element, elementName);
        }
    }

    protected void validateVarElement(String fileName, Element element) {
        List childElements;
        List attributes = element.attributes();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            String attributeValue = attribute.getValue();
            if (!attributeName.equals("value") && Validator.isNull((String)attributeValue)) {
                this.throwValidationException(1006, fileName, element, attributeName);
            }
            if (!_allowedVarAttributes.contains(attributeName)) {
                this.throwValidationException(1005, fileName, element, attributeName);
            }
            attributeMap.put(attributeName, attributeValue);
        }
        if (!attributeMap.containsKey("name")) {
            this.throwValidationException(1004, fileName, element, new String[]{"name"});
        } else {
            String nameValue = (String)attributeMap.get("name");
            if (Validator.isNull((String)nameValue)) {
                this.throwValidationException(1006, fileName, element, "name");
            }
        }
        if (attributeMap.containsKey("locator")) {
            String[] disallowedAttributes;
            String[] stringArray = disallowedAttributes = new String[]{"locator-key", "path", "value"};
            int attributeValue = disallowedAttributes.length;
            int attributeName = 0;
            while (attributeName < attributeValue) {
                String disallowedAttribute = stringArray[attributeName];
                if (attributeMap.containsKey(disallowedAttribute)) {
                    this.throwValidationException(1005, fileName, element, disallowedAttribute);
                }
                ++attributeName;
            }
        } else if (attributeMap.containsKey("locator-key") && attributeMap.containsKey("path")) {
            if (attributeMap.containsKey("value")) {
                this.throwValidationException(1005, fileName, element, "value");
            }
        } else if (attributeMap.containsKey("locator-key")) {
            this.throwValidationException(1004, fileName, element, new String[]{"path"});
        } else if (attributeMap.containsKey("path")) {
            this.throwValidationException(1004, fileName, element, new String[]{"locator-key"});
        }
        String varText = element.getText();
        if ((attributeMap.containsKey("locator") || attributeMap.containsKey("locator-key") || attributeMap.containsKey("path")) && !Validator.isNull((String)varText)) {
            this.throwValidationException(1005, fileName, element, "value");
        }
        if (!attributeMap.containsKey("value") && Validator.isNull((String)varText)) {
            if (!(attributeMap.containsKey("locator") || attributeMap.containsKey("locator-key") || attributeMap.containsKey("path"))) {
                this.throwValidationException(1004, fileName, element, new String[]{"value"});
            }
        } else {
            String varValue = (String)attributeMap.get("value");
            if (Validator.isNull((String)varValue)) {
                varValue = varText;
            }
            Pattern pattern = Pattern.compile("\\$\\{([^\\}]*?)\\}");
            Matcher matcher = pattern.matcher(varValue);
            while (matcher.find()) {
                String statement = matcher.group(1);
                Pattern statementPattern = Pattern.compile("(.*)\\?(.*)\\(([^\\)]*?)\\)");
                Matcher statementMatcher = statementPattern.matcher(statement);
                if (statementMatcher.find()) {
                    String operand = statementMatcher.group(1);
                    String method = statementMatcher.group(2);
                    if (operand.equals("") || method.equals("")) {
                        this.throwValidationException(1006, fileName, element, "value");
                    }
                    if (_methodNames.contains(method)) continue;
                    this.throwValidationException(1013, fileName, element, method);
                    continue;
                }
                if (!statement.matches(".*[\\?\\(\\)\\}\\{].*")) continue;
                this.throwValidationException(1006, fileName, element, "value");
            }
        }
        if (!(childElements = element.elements()).isEmpty()) {
            Element childElement = (Element)childElements.get(0);
            String childElementName = childElement.getName();
            this.throwValidationException(1002, fileName, childElement, childElementName);
        }
    }
}

