/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SessionTreeJSClicks {
    private static Log _log = LogFactoryUtil.getLog(SessionTreeJSClicks.class);

    public static void closeLayoutNodes(HttpServletRequest request, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(request, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.closeNodes(request, treeId, layoutIds.toArray(new String[layoutIds.size()]));
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static void closeNode(HttpServletRequest request, String treeId, String nodeId) {
        try {
            String openNodesString = SessionTreeJSClicks.get(request, treeId);
            openNodesString = StringUtil.remove((String)openNodesString, (String)nodeId);
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static void closeNodes(HttpServletRequest request, String treeId) {
        try {
            String openNodesString = "";
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static void closeNodes(HttpServletRequest request, String treeId, String[] nodeIds) {
        try {
            String openNodesString = SessionTreeJSClicks.get(request, treeId);
            String[] stringArray = nodeIds;
            int n = nodeIds.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeId = stringArray[n2];
                openNodesString = StringUtil.remove((String)openNodesString, (String)nodeId);
                ++n2;
            }
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static String getOpenNodes(HttpServletRequest request, String treeId) {
        try {
            return SessionTreeJSClicks.get(request, treeId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
    }

    public static void openLayoutNodes(HttpServletRequest request, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(request, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.openNodes(request, treeId, layoutIds.toArray(new String[layoutIds.size()]));
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static void openNode(HttpServletRequest request, String treeId, String nodeId) {
        try {
            String openNodesString = SessionTreeJSClicks.get(request, treeId);
            openNodesString = StringUtil.add((String)openNodesString, (String)nodeId);
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static void openNodes(HttpServletRequest request, String treeId, String[] nodeIds) {
        try {
            String openNodesString = SessionTreeJSClicks.get(request, treeId);
            String[] stringArray = nodeIds;
            int n = nodeIds.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeId = stringArray[n2];
                openNodesString = StringUtil.add((String)openNodesString, (String)nodeId);
                ++n2;
            }
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected static String get(HttpServletRequest request, String key) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            return preferences.getValue(SessionTreeJSClicks.class.getName(), key);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
    }

    protected static List<String> getLayoutIds(HttpServletRequest request, boolean privateLayout, long parentLayoutId, List<String> layoutIds) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId);
        for (Layout layout : layouts) {
            layoutIds.add(String.valueOf(layout.getLayoutId()));
            SessionTreeJSClicks.getLayoutIds(request, privateLayout, layout.getLayoutId(), layoutIds);
        }
        return layoutIds;
    }

    protected static void put(HttpServletRequest request, String key, String value) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            preferences.setValue(SessionTreeJSClicks.class.getName(), key, value);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

