/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileVersionActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.service.TrashEntryLocalServiceUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class VerifyDocumentLibrary
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyDocumentLibrary.class);

    protected void addDLFileVersion(DLFileEntry dlFileEntry) throws SystemException {
        long fileVersionId = CounterLocalServiceUtil.increment();
        DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.createDLFileVersion((long)fileVersionId);
        dlFileVersion.setGroupId(dlFileEntry.getGroupId());
        dlFileVersion.setCompanyId(dlFileEntry.getCompanyId());
        long userId = dlFileEntry.getUserId();
        dlFileVersion.setUserId(userId);
        String userName = dlFileEntry.getUserName();
        dlFileVersion.setUserName(userName);
        dlFileVersion.setCreateDate(dlFileEntry.getModifiedDate());
        dlFileVersion.setModifiedDate(dlFileEntry.getModifiedDate());
        dlFileVersion.setRepositoryId(dlFileEntry.getRepositoryId());
        dlFileVersion.setFolderId(dlFileEntry.getFolderId());
        dlFileVersion.setFileEntryId(dlFileEntry.getFileEntryId());
        dlFileVersion.setExtension(dlFileEntry.getExtension());
        dlFileVersion.setMimeType(dlFileEntry.getMimeType());
        dlFileVersion.setTitle(dlFileEntry.getTitle());
        dlFileVersion.setDescription(dlFileEntry.getDescription());
        dlFileVersion.setExtraSettings(dlFileEntry.getExtraSettings());
        dlFileVersion.setFileEntryTypeId(dlFileEntry.getFileEntryTypeId());
        dlFileVersion.setVersion(dlFileEntry.getVersion());
        dlFileVersion.setSize(dlFileEntry.getSize());
        dlFileVersion.setStatus(0);
        dlFileVersion.setStatusByUserId(userId);
        dlFileVersion.setStatusByUserName(userName);
        dlFileVersion.setStatusDate(new Date());
        DLFileVersionLocalServiceUtil.updateDLFileVersion((DLFileVersion)dlFileVersion);
    }

    protected void checkDLFileEntryType() throws Exception {
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)0L);
        if (dlFileEntryType != null) {
            return;
        }
        Date now = new Date();
        dlFileEntryType = DLFileEntryTypeLocalServiceUtil.createDLFileEntryType((long)0L);
        dlFileEntryType.setCreateDate(now);
        dlFileEntryType.setModifiedDate(now);
        dlFileEntryType.setFileEntryTypeKey(StringUtil.toUpperCase((String)"basic-document"));
        dlFileEntryType.setName("basic-document", LocaleUtil.getDefault());
        DLFileEntryTypeLocalServiceUtil.updateDLFileEntryType((DLFileEntryType)dlFileEntryType);
    }

    protected void checkDuplicateTitles() throws Exception {
        DLFileEntryActionableDynamicQuery actionableDynamicQuery = new DLFileEntryActionableDynamicQuery(){

            public void performAction(Object object) {
                block6: {
                    DLFileEntry dlFileEntry = (DLFileEntry)object;
                    if (dlFileEntry.isInTrash()) {
                        return;
                    }
                    try {
                        DLFileEntryLocalServiceUtil.validateFile((long)dlFileEntry.getGroupId(), (long)dlFileEntry.getFolderId(), (long)dlFileEntry.getFileEntryId(), (String)dlFileEntry.getTitle(), (String)dlFileEntry.getExtension());
                    }
                    catch (Exception e1) {
                        if (!(e1 instanceof DuplicateFileException) && !(e1 instanceof DuplicateFolderNameException)) {
                            return;
                        }
                        try {
                            VerifyDocumentLibrary.this.renameDuplicateTitle(dlFileEntry);
                        }
                        catch (Exception e2) {
                            if (!_log.isWarnEnabled()) break block6;
                            _log.warn((Object)("Unable to rename duplicate title for file entry " + dlFileEntry.getFileEntryId() + ": " + e2.getMessage()), (Throwable)e2);
                        }
                    }
                }
            }
        };
        actionableDynamicQuery.performActions();
    }

    protected void checkFileEntryMimeTypes(final String originalMimeType) throws Exception {
        DLFileEntryActionableDynamicQuery actionableDynamicQuery = new DLFileEntryActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                InputStream inputStream = null;
                try {
                    inputStream = DLFileEntryLocalServiceUtil.getFileAsStream((long)dlFileEntry.getUserId(), (long)dlFileEntry.getFileEntryId(), (String)dlFileEntry.getVersion(), (boolean)false);
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to find file entry " + dlFileEntry.getName()), (Throwable)e2);
                    }
                    return;
                }
                String title = DLUtil.getTitleWithExtension((String)dlFileEntry.getTitle(), (String)dlFileEntry.getExtension());
                String mimeType = VerifyDocumentLibrary.this.getMimeType(inputStream, title);
                if (mimeType.equals(originalMimeType)) {
                    return;
                }
                dlFileEntry.setMimeType(mimeType);
                DLFileEntryLocalServiceUtil.updateDLFileEntry((DLFileEntry)dlFileEntry);
                DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
                dlFileVersion.setMimeType(mimeType);
                DLFileVersionLocalServiceUtil.updateDLFileVersion((DLFileVersion)dlFileVersion);
            }
        };
        actionableDynamicQuery.performActions();
    }

    protected void checkFileVersionMimeTypes(final String originalMimeType) throws Exception {
        DLFileVersionActionableDynamicQuery actionableDynamicQuery = new DLFileVersionActionableDynamicQuery(){

            protected void performAction(Object object) throws SystemException {
                DLFileVersion dlFileVersion = (DLFileVersion)object;
                InputStream inputStream = null;
                try {
                    inputStream = DLFileEntryLocalServiceUtil.getFileAsStream((long)dlFileVersion.getUserId(), (long)dlFileVersion.getFileEntryId(), (String)dlFileVersion.getVersion(), (boolean)false);
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchDLFileEntry((long)dlFileVersion.getFileEntryId());
                        if (dlFileEntry == null) {
                            _log.warn((Object)("Unable to find file entry associated with file version " + dlFileVersion.getFileVersionId()), (Throwable)e2);
                        } else {
                            _log.warn((Object)("Unable to find file version " + dlFileVersion.getVersion() + " for file " + "entry " + dlFileEntry.getName()), (Throwable)e2);
                        }
                    }
                    return;
                }
                String title = DLUtil.getTitleWithExtension((String)dlFileVersion.getTitle(), (String)dlFileVersion.getExtension());
                String mimeType = VerifyDocumentLibrary.this.getMimeType(inputStream, title);
                if (mimeType.equals(originalMimeType)) {
                    return;
                }
                dlFileVersion.setMimeType(mimeType);
                DLFileVersionLocalServiceUtil.updateDLFileVersion((DLFileVersion)dlFileVersion);
            }
        };
        actionableDynamicQuery.performActions();
    }

    protected void checkMimeTypes() throws Exception {
        String[] mimeTypes;
        String[] stringArray = mimeTypes = new String[]{"application/octet-stream", "text/xml; charset=\"utf-8\""};
        int n = mimeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String mimeType = stringArray[n2];
            this.checkFileEntryMimeTypes(mimeType);
            this.checkFileVersionMimeTypes(mimeType);
            ++n2;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Fixed file entries with invalid mime types");
        }
    }

    protected void checkMisversionedDLFileEntries() throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getMisversionedFileEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFileEntries.size() + " misversioned file entries"));
        }
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            this.copyDLFileEntry(dlFileEntry);
            this.addDLFileVersion(dlFileEntry);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Fixed misversioned file entries");
        }
    }

    protected void checkTitles() throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(DLFileEntry.class);
        Criterion criterion1 = RestrictionsFactoryUtil.like((String)"title", (Object)"%/%");
        Criterion criterion2 = RestrictionsFactoryUtil.like((String)"title", (Object)"%\\\\%");
        dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)criterion1, (Criterion)criterion2));
        List dlFileEntries = DLFileEntryLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            TrashEntry trashEntry = TrashEntryLocalServiceUtil.fetchEntry((String)dlFileEntry.getModelClassName(), (long)dlFileEntry.getFileEntryId());
            if (trashEntry != null) continue;
            String title = dlFileEntry.getTitle();
            String newTitle = title.replace("/", "");
            newTitle = newTitle.replace("\\", "_");
            this.renameTitle(dlFileEntry, newTitle);
        }
        this.checkDuplicateTitles();
    }

    protected void copyDLFileEntry(DLFileEntry dlFileEntry) throws PortalException, SystemException {
        String version;
        String name;
        long dataRepositoryId;
        long companyId = dlFileEntry.getCompanyId();
        if (DLStoreUtil.hasFile((long)companyId, (long)(dataRepositoryId = dlFileEntry.getDataRepositoryId()), (String)(name = dlFileEntry.getName()), (String)(version = dlFileEntry.getVersion()))) {
            return;
        }
        FileVersionVersionComparator comparator = new FileVersionVersionComparator();
        List dlFileVersions = dlFileEntry.getFileVersions(0);
        if (dlFileVersions.isEmpty()) {
            dlFileVersions = dlFileEntry.getFileVersions(-1);
        }
        if (dlFileVersions.isEmpty()) {
            DLStoreUtil.addFile((long)companyId, (long)dataRepositoryId, (String)name, (byte[])new byte[0]);
            return;
        }
        dlFileVersions = ListUtil.copy((List)dlFileVersions);
        Collections.sort(dlFileVersions, comparator);
        DLFileVersion dlFileVersion = (DLFileVersion)dlFileVersions.get(0);
        DLStoreUtil.copyFileVersion((long)companyId, (long)dataRepositoryId, (String)name, (String)dlFileVersion.getVersion(), (String)version);
    }

    @Override
    protected void doVerify() throws Exception {
        this.checkMisversionedDLFileEntries();
        this.checkDLFileEntryType();
        this.checkMimeTypes();
        this.checkTitles();
        this.removeOrphanedDLFileEntries();
        this.updateClassNameId();
        this.updateFileEntryAssets();
        this.updateFolderAssets();
        this.verifyTree();
    }

    protected String getMimeType(InputStream inputStream, String title) {
        String mimeType = null;
        try {
            mimeType = MimeTypesUtil.getContentType((InputStream)inputStream, (String)title);
        }
        finally {
            StreamUtil.cleanUp((InputStream)inputStream);
        }
        return mimeType;
    }

    protected void updateClassNameId() {
        block2: {
            try {
                this.runSQL("update DLFileEntry set classNameId = 0 where classNameId is null");
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to fix file entries where class name ID is null", (Throwable)e2);
            }
        }
    }

    protected void removeOrphanedDLFileEntries() throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getOrphanedFileEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no group"));
        }
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            try {
                DLFileEntryLocalServiceUtil.deleteFileEntry((long)dlFileEntry.getFileEntryId());
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to remove file entry " + dlFileEntry.getFileEntryId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Removed orphaned file entries");
        }
    }

    protected void renameDuplicateTitle(DLFileEntry dlFileEntry) throws PortalException, SystemException {
        String title = dlFileEntry.getTitle();
        String titleExtension = "";
        String titleWithoutExtension = dlFileEntry.getTitle();
        if (title.endsWith(".".concat(dlFileEntry.getExtension()))) {
            titleExtension = dlFileEntry.getExtension();
            titleWithoutExtension = FileUtil.stripExtension((String)title);
        }
        int i2 = 1;
        while (true) {
            String uniqueTitle = String.valueOf(titleWithoutExtension) + "_" + String.valueOf(i2);
            if (Validator.isNotNull((String)titleExtension)) {
                uniqueTitle = uniqueTitle.concat(".".concat(titleExtension));
            }
            try {
                DLFileEntryLocalServiceUtil.validateFile((long)dlFileEntry.getGroupId(), (long)dlFileEntry.getFolderId(), (long)dlFileEntry.getFileEntryId(), (String)uniqueTitle, (String)dlFileEntry.getExtension());
                this.renameTitle(dlFileEntry, uniqueTitle);
                return;
            }
            catch (PortalException pe) {
                if (!(pe instanceof DuplicateFolderNameException) && !(pe instanceof DuplicateFileException)) {
                    throw pe;
                }
                ++i2;
                continue;
            }
            break;
        }
    }

    protected void renameTitle(DLFileEntry dlFileEntry, String newTitle) throws PortalException, SystemException {
        String title = dlFileEntry.getTitle();
        dlFileEntry.setTitle(newTitle);
        DLFileEntryLocalServiceUtil.updateDLFileEntry((DLFileEntry)dlFileEntry);
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        dlFileVersion.setTitle(newTitle);
        DLFileVersionLocalServiceUtil.updateDLFileVersion((DLFileVersion)dlFileVersion);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invalid title " + title + " renamed to " + newTitle + " for file entry " + dlFileEntry.getFileEntryId()));
        }
    }

    protected void updateFileEntryAssets() throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getNoAssetFileEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no asset"));
        }
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileEntry.getFileVersion());
            try {
                DLAppHelperLocalServiceUtil.updateAsset((long)dlFileEntry.getUserId(), (FileEntry)fileEntry, (FileVersion)fileVersion, null, null, null);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for file entry " + dlFileEntry.getFileEntryId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for file entries");
        }
    }

    protected void updateFolderAssets() throws Exception {
        List dlFolders = DLFolderLocalServiceUtil.getNoAssetFolders();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFolders.size() + " folders with no asset"));
        }
        for (DLFolder dlFolder : dlFolders) {
            LiferayFolder folder = new LiferayFolder(dlFolder);
            try {
                DLAppHelperLocalServiceUtil.updateAsset((long)dlFolder.getUserId(), (Folder)folder, null, null, null);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for folder " + dlFolder.getFolderId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for folders");
        }
    }

    protected void verifyTree() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            DLFileEntryLocalServiceUtil.rebuildTree((long)companyId);
            DLFileShortcutLocalServiceUtil.rebuildTree((long)companyId);
            DLFileVersionLocalServiceUtil.rebuildTree((long)companyId);
            DLFolderLocalServiceUtil.rebuildTree((long)companyId);
            ++n2;
        }
    }
}

