/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xsl;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Locale;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSLErrorListener
implements ErrorListener {
    private int _columnNumber;
    private int _lineNumber;
    private Locale _locale;
    private String _location;
    private String _message;

    public XSLErrorListener(Locale locale) {
        this._locale = locale;
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        this.setLocation(exception);
        throw exception;
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        this.setLocation(exception);
        throw exception;
    }

    public int getColumnNumber() {
        return this._columnNumber;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getLocation() {
        return this._location;
    }

    public String getMessage() {
        return this._message;
    }

    public String getMessageAndLocation() {
        return String.valueOf(this._message) + " " + this._location;
    }

    public void setLocation(Throwable exception) {
        SourceLocator locator = null;
        Throwable cause = exception;
        Throwable rootCause = null;
        while (cause != null) {
            SourceLocator causeLocator;
            if (cause instanceof SAXParseException) {
                locator = new SAXSourceLocator((SAXParseException)cause);
                rootCause = cause;
            } else if (cause instanceof TransformerException && (causeLocator = ((TransformerException)cause).getLocator()) != null) {
                locator = causeLocator;
                rootCause = cause;
            }
            cause = cause instanceof TransformerException ? ((TransformerException)cause).getCause() : (cause instanceof WrappedRuntimeException ? ((WrappedRuntimeException)cause).getException() : (cause instanceof SAXException ? ((SAXException)cause).getException() : null));
        }
        this._message = rootCause.getMessage();
        if (locator != null) {
            this._lineNumber = locator.getLineNumber();
            this._columnNumber = locator.getColumnNumber();
            StringBundler sb = new StringBundler(8);
            sb.append(LanguageUtil.get((Locale)this._locale, (String)"line"));
            sb.append(" #");
            sb.append(locator.getLineNumber());
            sb.append("; ");
            sb.append(LanguageUtil.get((Locale)this._locale, (String)"column"));
            sb.append(" #");
            sb.append(locator.getColumnNumber());
            sb.append("; ");
            this._location = sb.toString();
        } else {
            this._location = "";
        }
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        this.setLocation(exception);
        throw exception;
    }
}

