/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.amazonrankings.util;

import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.amazonrankings.model.AmazonRankings;
import com.liferay.portlet.amazonrankings.util.AmazonRankingsWebCacheItem;
import java.text.DateFormat;
import java.util.Calendar;

public class AmazonRankingsUtil {
    private static final String _TIMESTAMP = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public static String getAmazonAccessKeyId() {
        return PropsValues.AMAZON_ACCESS_KEY_ID;
    }

    public static String getAmazonAssociateTag() {
        return PropsValues.AMAZON_ASSOCIATE_TAG;
    }

    public static AmazonRankings getAmazonRankings(String isbn) {
        if (!Validator.isDigit((String)isbn)) {
            return null;
        }
        AmazonRankingsWebCacheItem wci = new AmazonRankingsWebCacheItem(isbn);
        return (AmazonRankings)WebCachePoolUtil.get((String)(String.valueOf(AmazonRankingsUtil.class.getName()) + "." + isbn), (WebCacheItem)wci);
    }

    public static String getAmazonSecretAccessKey() {
        return PropsValues.AMAZON_SECRET_ACCESS_KEY;
    }

    public static String getTimestamp() {
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_TIMESTAMP);
        dateFormat.setTimeZone(TimeZoneUtil.getDefault());
        Calendar calendar = Calendar.getInstance();
        return dateFormat.format(calendar.getTime());
    }

    public static boolean isEnabled() {
        return !Validator.isNull((String)PropsValues.AMAZON_ACCESS_KEY_ID) && !Validator.isNull((String)PropsValues.AMAZON_ASSOCIATE_TAG) && !Validator.isNull((String)PropsValues.AMAZON_SECRET_ACCESS_KEY);
    }
}

