/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.comparator.ModelResourceComparator;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryProperty;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagPropertyLocalServiceUtil;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.portlet.asset.service.permission.AssetTagPermission;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.assetpublisher.util.AssetSearcher;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class AssetUtil {
    public static final String CLASSNAME_SEPARATOR = "_CLASSNAME_";
    public static final char[] INVALID_CHARACTERS = new char[]{'&', '\'', '@', '\\', ']', '}', ':', ',', '=', '>', '/', '<', '\n', '[', '{', '%', '|', '+', '#', '`', '?', '\"', '\r', ';', '/', '*', '~'};
    private static Log _log = LogFactoryUtil.getLog(AssetUtil.class);

    public static Set<String> addLayoutTags(HttpServletRequest request, List<AssetTag> tags) {
        Set<String> layoutTags = AssetUtil.getLayoutTagNames(request);
        for (AssetTag tag : tags) {
            layoutTags.add(tag.getName());
        }
        return layoutTags;
    }

    public static void addPortletBreadcrumbEntries(long assetCategoryId, HttpServletRequest request, PortletURL portletURL) throws Exception {
        AssetCategory assetCategory = AssetCategoryLocalServiceUtil.getCategory((long)assetCategoryId);
        List ancestorCategories = assetCategory.getAncestors();
        Collections.reverse(ancestorCategories);
        for (AssetCategory ancestorCategory : ancestorCategories) {
            portletURL.setParameter("categoryId", String.valueOf(ancestorCategory.getCategoryId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorCategory.getTitleCurrentValue(), (String)portletURL.toString());
        }
        portletURL.setParameter("categoryId", String.valueOf(assetCategoryId));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)assetCategory.getTitleCurrentValue(), (String)portletURL.toString());
    }

    public static String checkViewURL(AssetEntry assetEntry, boolean viewInContext, String viewURL, String currentURL, ThemeDisplay themeDisplay) {
        return AssetUtil.checkViewURL(assetEntry, viewInContext, viewURL, currentURL, themeDisplay, true);
    }

    public static String checkViewURL(AssetEntry assetEntry, boolean viewInContext, String viewURL, String currentURL, ThemeDisplay themeDisplay, boolean checkInheritRedirect) {
        if (Validator.isNotNull((String)viewURL)) {
            if (checkInheritRedirect) {
                viewURL = HttpUtil.setParameter((String)viewURL, (String)"inheritRedirect", (boolean)viewInContext);
            }
            String assetEntryLayoutUuid = assetEntry.getLayoutUuid();
            Layout layout = themeDisplay.getLayout();
            if (!viewInContext || Validator.isNotNull((String)assetEntryLayoutUuid) && !assetEntryLayoutUuid.equals(layout.getUuid())) {
                viewURL = HttpUtil.setParameter((String)viewURL, (String)"redirect", (String)currentURL);
            }
        }
        return viewURL;
    }

    public static long[] filterCategoryIds(PermissionChecker permissionChecker, long[] categoryIds) throws PortalException, SystemException {
        ArrayList<Long> viewableCategoryIds = new ArrayList<Long>();
        long[] lArray = categoryIds;
        int n = categoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long categoryId = lArray[n2];
            AssetCategory category = AssetCategoryLocalServiceUtil.fetchCategory((long)categoryId);
            if (category != null && AssetCategoryPermission.contains(permissionChecker, categoryId, "VIEW")) {
                viewableCategoryIds.add(categoryId);
            }
            ++n2;
        }
        return ArrayUtil.toArray((Long[])viewableCategoryIds.toArray(new Long[viewableCategoryIds.size()]));
    }

    public static long[] filterTagIds(PermissionChecker permissionChecker, long[] tagIds) throws PortalException, SystemException {
        ArrayList<Long> viewableTagIds = new ArrayList<Long>();
        long[] lArray = tagIds;
        int n = tagIds.length;
        int n2 = 0;
        while (n2 < n) {
            long tagId = lArray[n2];
            if (AssetTagPermission.contains(permissionChecker, tagId, "VIEW")) {
                viewableTagIds.add(tagId);
            }
            ++n2;
        }
        return ArrayUtil.toArray((Long[])viewableTagIds.toArray(new Long[viewableTagIds.size()]));
    }

    public static long[][] filterTagIdsArray(PermissionChecker permissionChecker, long[][] tagIdsArray) throws PortalException, SystemException {
        ArrayList<long[]> viewableTagIdsArray = new ArrayList<long[]>();
        int i2 = 0;
        while (i2 < tagIdsArray.length) {
            long[] tagIds = tagIdsArray[i2];
            ArrayList<Long> viewableTagIds = new ArrayList<Long>();
            long[] lArray = tagIds;
            int n = tagIds.length;
            int n2 = 0;
            while (n2 < n) {
                long tagId = lArray[n2];
                if (AssetTagPermission.contains(permissionChecker, tagId, "VIEW")) {
                    viewableTagIds.add(tagId);
                }
                ++n2;
            }
            viewableTagIdsArray.add(ArrayUtil.toArray((Long[])viewableTagIds.toArray(new Long[viewableTagIds.size()])));
            ++i2;
        }
        return (long[][])viewableTagIdsArray.toArray((T[])new long[viewableTagIdsArray.size()][]);
    }

    public static PortletURL getAddPortletURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String className, long classTypeId, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        String referringPortletResource;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null) {
            return null;
        }
        liferayPortletRequest.setAttribute("ASSET_RENDERER_FACTORY_CLASS_TYPE_ID", (Object)classTypeId);
        PortletURL addPortletURL = assetRendererFactory.getURLAdd(liferayPortletRequest, liferayPortletResponse);
        if (addPortletURL == null) {
            return null;
        }
        if (redirect != null) {
            addPortletURL.setParameter("redirect", redirect);
        }
        if (Validator.isNotNull((String)(referringPortletResource = ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"portletResource")))) {
            addPortletURL.setParameter("referringPortletResource", referringPortletResource);
        } else {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            addPortletURL.setParameter("referringPortletResource", portletDisplay.getId());
            if (allAssetCategoryIds != null) {
                HashMap<Long, String> assetVocabularyAssetCategoryIds = new HashMap<Long, String>();
                long[] lArray = allAssetCategoryIds;
                int n = allAssetCategoryIds.length;
                int n2 = 0;
                while (n2 < n) {
                    long assetCategoryId = lArray[n2];
                    AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)assetCategoryId);
                    if (assetCategory != null) {
                        long assetVocabularyId = assetCategory.getVocabularyId();
                        if (assetVocabularyAssetCategoryIds.containsKey(assetVocabularyId)) {
                            String assetCategoryIds = (String)assetVocabularyAssetCategoryIds.get(assetVocabularyId);
                            assetVocabularyAssetCategoryIds.put(assetVocabularyId, String.valueOf(assetCategoryIds) + "," + assetCategoryId);
                        } else {
                            assetVocabularyAssetCategoryIds.put(assetVocabularyId, String.valueOf(assetCategoryId));
                        }
                    }
                    ++n2;
                }
                for (Map.Entry entry : assetVocabularyAssetCategoryIds.entrySet()) {
                    long assetVocabularyId = (Long)entry.getKey();
                    String assetCategoryIds = (String)entry.getValue();
                    addPortletURL.setParameter("assetCategoryIds_" + assetVocabularyId, assetCategoryIds);
                }
            }
            if (allAssetTagNames != null) {
                addPortletURL.setParameter("assetTagNames", StringUtil.merge((Object[])allAssetTagNames));
            }
        }
        if (classTypeId > 0L) {
            addPortletURL.setParameter("classTypeId", String.valueOf(classTypeId));
            if (className.equals(DLFileEntry.class.getName())) {
                addPortletURL.setParameter("cmd", "add");
                addPortletURL.setParameter("folderId", String.valueOf(0L));
                addPortletURL.setParameter("fileEntryTypeId", String.valueOf(classTypeId));
            }
            if (className.equals(JournalArticle.class.getName())) {
                DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)classTypeId);
                addPortletURL.setParameter("structureId", ddmStructure.getStructureKey());
            }
        }
        addPortletURL.setPortletMode(PortletMode.VIEW);
        addPortletURL.setWindowState(LiferayWindowState.POP_UP);
        return addPortletURL;
    }

    public static Map<String, PortletURL> getAddPortletURLs(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long[] classNameIds, long[] classTypeIds, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TreeMap<String, PortletURL> addPortletURLs = new TreeMap<String, PortletURL>((Comparator<String>)new ModelResourceComparator(themeDisplay.getLocale()));
        if (Validator.isNull((String)redirect)) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            LiferayPortletURL redirectURL = liferayPortletResponse.createLiferayPortletURL(themeDisplay.getPlid(), portletDisplay.getId(), "RENDER_PHASE", false);
            redirectURL.setParameter("struts_action", "/asset_publisher/add_asset_redirect");
            redirectURL.setParameter("redirect", themeDisplay.getURLCurrent());
            redirectURL.setWindowState(LiferayWindowState.POP_UP);
            redirect = redirectURL.toString();
        }
        long[] lArray = classNameIds;
        int n = classNameIds.length;
        int n2 = 0;
        while (n2 < n) {
            long classNameId = lArray[n2];
            String className = PortalUtil.getClassName((long)classNameId);
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)assetRendererFactory.getPortletId());
            if (portlet.isActive()) {
                PortletURL addPortletURL;
                Map classTypes = assetRendererFactory.getClassTypes(new long[]{themeDisplay.getCompanyGroupId(), themeDisplay.getScopeGroupId()}, themeDisplay.getLocale());
                if ((classTypeIds.length == 0 || classTypes.isEmpty()) && (addPortletURL = AssetUtil.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, className, 0L, allAssetCategoryIds, allAssetTagNames, redirect)) != null) {
                    addPortletURLs.put(className, addPortletURL);
                }
                Iterator iterator = classTypes.keySet().iterator();
                while (iterator.hasNext()) {
                    PortletURL addPortletURL2;
                    long classTypeId = (Long)iterator.next();
                    if (!ArrayUtil.contains((long[])classTypeIds, (long)classTypeId) && classTypeIds.length != 0 || (addPortletURL2 = AssetUtil.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, className, classTypeId, allAssetCategoryIds, allAssetTagNames, redirect)) == null) continue;
                    String mesage = String.valueOf(className) + CLASSNAME_SEPARATOR + (String)classTypes.get(classTypeId);
                    addPortletURLs.put(mesage, addPortletURL2);
                }
            }
            ++n2;
        }
        return addPortletURLs;
    }

    public static List<AssetEntry> getAssetEntries(Hits hits) {
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        Document[] documentArray = hits.getDocs();
        int n = documentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Document document = documentArray[n2];
            String className = GetterUtil.getString((String)document.get("entryClassName"));
            long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
                assetEntries.add(assetEntry);
            }
            catch (Exception exception) {}
            ++n2;
        }
        return assetEntries;
    }

    public static String getAssetKeywords(String className, long classPK) throws SystemException {
        List tags = AssetTagLocalServiceUtil.getTags((String)className, (long)classPK);
        List categories = AssetCategoryLocalServiceUtil.getCategories((String)className, (long)classPK);
        StringBuffer sb = new StringBuffer();
        sb.append(ListUtil.toString((List)tags, (Accessor)AssetTag.NAME_ACCESSOR));
        if (!tags.isEmpty()) {
            sb.append(",");
        }
        sb.append(ListUtil.toString((List)categories, (Accessor)AssetCategory.NAME_ACCESSOR));
        return sb.toString();
    }

    public static Set<String> getLayoutTagNames(HttpServletRequest request) {
        HashSet tagNames = (HashSet)request.getAttribute("ASSET_LAYOUT_TAG_NAMES");
        if (tagNames == null) {
            tagNames = new HashSet();
            request.setAttribute("ASSET_LAYOUT_TAG_NAMES", tagNames);
        }
        return tagNames;
    }

    public static boolean hasSubtype(String subtypeClassName, Map<String, PortletURL> addPortletURLs) {
        for (Map.Entry<String, PortletURL> entry : addPortletURLs.entrySet()) {
            String className = entry.getKey();
            if (!className.startsWith(subtypeClassName) || className.equals(subtypeClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidWord(String word) {
        char[] wordCharArray;
        if (Validator.isNull((String)word)) {
            return false;
        }
        char[] cArray = wordCharArray = word.toCharArray();
        int n = wordCharArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            char[] cArray2 = INVALID_CHARACTERS;
            int n3 = INVALID_CHARACTERS.length;
            int n4 = 0;
            while (n4 < n3) {
                char invalidChar = cArray2[n4];
                if (c2 == invalidChar) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Word " + word + " is not valid because " + c2 + " is not allowed"));
                    }
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    public static Hits search(HttpServletRequest request, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)request);
        return AssetUtil.search(searchContext, assetEntryQuery, start, end);
    }

    public static Hits search(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        String paginationType;
        Indexer searcher = AssetSearcher.getInstance();
        AssetSearcher assetSearcher = (AssetSearcher)searcher;
        assetSearcher.setAssetEntryQuery(assetEntryQuery);
        Layout layout = assetEntryQuery.getLayout();
        if (layout != null) {
            searchContext.setAttribute("layoutUuid", (Serializable)((Object)layout.getUuid()));
        }
        String ddmStructureFieldName = (String)((Object)assetEntryQuery.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = assetEntryQuery.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            searchContext.setAttribute("ddmStructureFieldName", (Serializable)((Object)ddmStructureFieldName));
            searchContext.setAttribute("ddmStructureFieldValue", ddmStructureFieldValue);
        }
        if (!(paginationType = GetterUtil.getString((String)assetEntryQuery.getPaginationType(), (String)"more")).equals("none") && !paginationType.equals("simple")) {
            searchContext.setAttribute("paginationType", (Serializable)((Object)paginationType));
        }
        searchContext.setClassTypeIds(assetEntryQuery.getClassTypeIds());
        searchContext.setEnd(end);
        searchContext.setGroupIds(assetEntryQuery.getGroupIds());
        if (Validator.isNotNull((String)assetEntryQuery.getKeywords())) {
            searchContext.setLike(true);
        }
        searchContext.setSorts(AssetUtil.getSorts(assetEntryQuery, searchContext.getLocale()));
        searchContext.setStart(start);
        return assetSearcher.search(searchContext);
    }

    public static String substituteCategoryPropertyVariables(long groupId, long categoryId, String s) throws SystemException {
        String result = s;
        AssetCategory category = null;
        if (categoryId > 0L) {
            category = AssetCategoryLocalServiceUtil.fetchCategory((long)categoryId);
        }
        if (category != null) {
            List categoryProperties = AssetCategoryPropertyLocalServiceUtil.getCategoryProperties((long)categoryId);
            for (AssetCategoryProperty categoryProperty : categoryProperties) {
                result = StringUtil.replace((String)result, (String)("[$" + categoryProperty.getKey() + "$]"), (String)categoryProperty.getValue());
            }
        }
        return StringUtil.stripBetween((String)result, (String)"[$", (String)"$]");
    }

    public static String substituteTagPropertyVariables(long groupId, String tagName, String s) throws PortalException, SystemException {
        String result = s;
        AssetTag tag = null;
        if (tagName != null) {
            try {
                tag = AssetTagLocalServiceUtil.getTag((long)groupId, (String)tagName);
            }
            catch (NoSuchTagException noSuchTagException) {}
        }
        if (tag != null) {
            List tagProperties = AssetTagPropertyLocalServiceUtil.getTagProperties((long)tag.getTagId());
            for (AssetTagProperty tagProperty : tagProperties) {
                result = StringUtil.replace((String)result, (String)("[$" + tagProperty.getKey() + "$]"), (String)tagProperty.getValue());
            }
        }
        return StringUtil.stripBetween((String)result, (String)"[$", (String)"$]");
    }

    public static String toWord(String text) {
        if (Validator.isNull((String)text)) {
            return text;
        }
        char[] textCharArray = text.toCharArray();
        int i2 = 0;
        while (i2 < textCharArray.length) {
            char c2 = textCharArray[i2];
            char[] cArray = INVALID_CHARACTERS;
            int n = INVALID_CHARACTERS.length;
            int n2 = 0;
            while (n2 < n) {
                char invalidChar = cArray[n2];
                if (c2 == invalidChar) {
                    textCharArray[i2] = 32;
                    break;
                }
                ++n2;
            }
            ++i2;
        }
        return new String(textCharArray);
    }

    protected static Sort getSort(String orderByType, String sortField, Locale locale) throws Exception {
        if (Validator.isNull((String)orderByType)) {
            orderByType = "asc";
        }
        int sortType = AssetUtil.getSortType(sortField);
        if (sortField.startsWith("ddm/")) {
            String[] sortFields = sortField.split("/");
            long ddmStructureId = GetterUtil.getLong((String)sortFields[1]);
            String fieldName = sortFields[2];
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
            String fieldType = ddmStructure.getFieldType(fieldName);
            sortType = AssetUtil.getSortType(fieldType);
            sortField = sortField.concat("_").concat(LocaleUtil.toLanguageId((Locale)locale));
        } else if (sortField.equals("modifiedDate")) {
            sortField = "modified";
        } else if (sortField.equals("title")) {
            sortField = DocumentImpl.getSortableFieldName((String)"localized_title_".concat(LocaleUtil.toLanguageId((Locale)locale)));
        }
        return SortFactoryUtil.getSort(AssetEntry.class, (int)sortType, (String)sortField, (String)orderByType);
    }

    protected static Sort[] getSorts(AssetEntryQuery assetEntryQuery, Locale locale) throws Exception {
        Sort sort1 = AssetUtil.getSort(assetEntryQuery.getOrderByType1(), assetEntryQuery.getOrderByCol1(), locale);
        Sort sort2 = AssetUtil.getSort(assetEntryQuery.getOrderByType2(), assetEntryQuery.getOrderByCol2(), locale);
        return new Sort[]{sort1, sort2};
    }

    protected static int getSortType(String sortField) {
        int sortType = 3;
        if (sortField.equals("createDate") || sortField.equals("expirationDate") || sortField.equals("publishDate") || sortField.equals("ddm-date") || sortField.equals("modifiedDate")) {
            sortType = 6;
        } else if (sortField.equals("priority") || sortField.equals("ratings") || sortField.equals("ddm-decimal") || sortField.equals("ddm-number")) {
            sortType = 7;
        } else if (sortField.equals("viewCount") || sortField.equals("ddm-integer")) {
            sortType = 4;
        }
        return sortType;
    }
}

