/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public class RSSAction
extends com.liferay.portal.struts.RSSAction {
    protected String exportToRSS(PortletRequest portletRequest, PortletResponse portletResponse, String name, String description, String format, double version, String displayStyle, String linkBehavior, List<AssetEntry> assetEntries) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setDescription(GetterUtil.getString((String)description, (String)name));
        ArrayList<SyndEntryImpl> syndEntries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(syndEntries);
        for (AssetEntry assetEntry : assetEntries) {
            String link = this.getEntryURL(portletRequest, portletResponse, linkBehavior, assetEntry);
            if (Validator.isBlank((String)link)) continue;
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            syndEntry.setLink(link);
            String author = PortalUtil.getUserName((BaseModel)assetEntry);
            syndEntry.setAuthor(author);
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            String value = null;
            String languageId = LanguageUtil.getLanguageId((PortletRequest)portletRequest);
            value = displayStyle.equals("title") ? "" : assetEntry.getSummary(languageId, true);
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            syndEntry.setPublishedDate(assetEntry.getPublishDate());
            syndEntry.setTitle(assetEntry.getTitle(languageId, true));
            syndEntry.setUpdatedDate(assetEntry.getModifiedDate());
            syndEntry.setUri(syndEntry.getLink());
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)format, (double)version));
        ArrayList<SyndLinkImpl> syndLinks = new ArrayList<SyndLinkImpl>();
        syndFeed.setLinks(syndLinks);
        SyndLinkImpl selfSyndLink = new SyndLinkImpl();
        syndLinks.add(selfSyndLink);
        String feedURL = this.getFeedURL(portletRequest);
        selfSyndLink.setHref(feedURL);
        selfSyndLink.setRel("self");
        SyndLinkImpl alternateSyndLink = new SyndLinkImpl();
        syndLinks.add(alternateSyndLink);
        alternateSyndLink.setHref(PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay));
        alternateSyndLink.setRel("alternate");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        return RSSUtil.export((SyndFeed)syndFeed);
    }

    protected List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletPreferences portletPreferences) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int rssDelta = GetterUtil.getInteger((String)portletPreferences.getValue("rssDelta", "20"));
        return AssetPublisherUtil.getAssetEntries((PortletPreferences)portletPreferences, (Layout)themeDisplay.getLayout(), (long)themeDisplay.getScopeGroupId(), (int)rssDelta, (boolean)true);
    }

    protected String getAssetPublisherURL(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        StringBundler sb = new StringBundler(7);
        String layoutFriendlyURL = GetterUtil.getString((String)PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay));
        if (!layoutFriendlyURL.startsWith("http://") && !layoutFriendlyURL.startsWith("https://")) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(layoutFriendlyURL);
        sb.append("/-/");
        sb.append("asset_publisher/");
        sb.append(portletDisplay.getInstanceId());
        sb.append("/");
        return sb.toString();
    }

    protected String getEntryURL(PortletRequest portletRequest, PortletResponse portletResponse, String linkBehavior, AssetEntry assetEntry) throws Exception {
        if (linkBehavior.equals("viewInPortlet")) {
            return this.getEntryURLViewInContext(portletRequest, portletResponse, assetEntry);
        }
        return this.getEntryURLAssetPublisher(portletRequest, portletResponse, assetEntry);
    }

    protected String getEntryURLAssetPublisher(PortletRequest portletRequest, PortletResponse portletResponse, AssetEntry assetEntry) throws Exception {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
        if (assetRendererFactory == null) {
            return "";
        }
        StringBundler sb = new StringBundler(4);
        sb.append(this.getAssetPublisherURL(portletRequest));
        sb.append(assetRendererFactory.getType());
        sb.append("/id/");
        sb.append(assetEntry.getEntryId());
        return sb.toString();
    }

    protected String getEntryURLViewInContext(PortletRequest portletRequest, PortletResponse portletResponse, AssetEntry assetEntry) throws Exception {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
        if (assetRendererFactory == null) {
            return "";
        }
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        String viewInContextURL = assetRenderer.getURLViewInContext((LiferayPortletRequest)portletRequest, (LiferayPortletResponse)portletResponse, null);
        if (Validator.isNotNull((String)viewInContextURL) && !viewInContextURL.startsWith("http://") && !viewInContextURL.startsWith("https://")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            viewInContextURL = String.valueOf(themeDisplay.getPortalURL()) + viewInContextURL;
        }
        return viewInContextURL;
    }

    protected String getFeedURL(PortletRequest portletRequest) throws Exception {
        String feedURL = this.getAssetPublisherURL(portletRequest);
        return feedURL.concat("rss");
    }

    @Override
    protected byte[] getRSS(ResourceRequest portletRequest, ResourceResponse portletResponse) throws Exception {
        PortletPreferences portletPreferences = portletRequest.getPreferences();
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (!selectionStyle.equals("dynamic")) {
            return new byte[0];
        }
        String assetLinkBehavior = portletPreferences.getValue("assetLinkBehavior", "showFullContent");
        String rssDisplayStyle = portletPreferences.getValue("rssDisplayStyle", "abstract");
        String rssFeedType = portletPreferences.getValue("rssFeedType", RSSUtil.FEED_TYPE_DEFAULT);
        String rssName = portletPreferences.getValue("rssName", null);
        String format = RSSUtil.getFeedTypeFormat((String)rssFeedType);
        double version = RSSUtil.getFeedTypeVersion((String)rssFeedType);
        String rss = this.exportToRSS((PortletRequest)portletRequest, (PortletResponse)portletResponse, rssName, null, format, version, rssDisplayStyle, assetLinkBehavior, this.getAssetEntries((PortletRequest)portletRequest, portletPreferences));
        return rss.getBytes("UTF-8");
    }
}

