/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PrimitiveLongList;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.persistence.PortletPreferencesActionableDynamicQuery;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.StrictPortletPreferencesImpl;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.assetpublisher.util.AssetEntryQueryProcessor;
import com.liferay.portlet.assetpublisher.util.AssetPublisher;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.sites.util.SitesUtil;
import com.liferay.util.ContentUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AssetPublisherImpl
implements AssetPublisher {
    private static Log _log = LogFactoryUtil.getLog(AssetPublisherImpl.class);
    private Map<String, AssetEntryQueryProcessor> _assetEntryQueryProcessor = new ConcurrentHashMap<String, AssetEntryQueryProcessor>();
    private Accessor<AssetEntry, String> _titleAccessor = new Accessor<AssetEntry, String>(){

        public String get(AssetEntry assetEntry) {
            return assetEntry.getTitle(LocaleUtil.getSiteDefault());
        }
    };

    public AssetPublisherImpl() {
        String[] stringArray = PropsValues.ASSET_PUBLISHER_ASSET_ENTRY_QUERY_PROCESSORS;
        int n = PropsValues.ASSET_PUBLISHER_ASSET_ENTRY_QUERY_PROCESSORS.length;
        int n2 = 0;
        while (n2 < n) {
            String assetEntryQueryProcessorClassName = stringArray[n2];
            try {
                AssetEntryQueryProcessor assetEntryQueryProcessor = (AssetEntryQueryProcessor)InstanceFactory.newInstance((String)assetEntryQueryProcessorClassName);
                this.registerAssetQueryProcessor(assetEntryQueryProcessorClassName, assetEntryQueryProcessor);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            ++n2;
        }
    }

    public void addAndStoreSelection(PortletRequest portletRequest, String className, long classPK, int assetEntryOrder) throws Exception {
        String referringPortletResource = ParamUtil.getString((PortletRequest)portletRequest, (String)"referringPortletResource");
        if (Validator.isNull((String)referringPortletResource)) {
            return;
        }
        String rootPortletId = PortletConstants.getRootPortletId((String)referringPortletResource);
        if (!rootPortletId.equals("101")) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)themeDisplay.getRefererPlid());
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)referringPortletResource);
        if (portletPreferences instanceof StrictPortletPreferencesImpl) {
            return;
        }
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (selectionStyle.equals("dynamic")) {
            return;
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
        this.addSelection(themeDisplay, portletPreferences, referringPortletResource, assetEntry.getEntryId(), assetEntryOrder, className);
        portletPreferences.store();
    }

    public void addRecentFolderId(PortletRequest portletRequest, String className, long classPK) {
        this._getRecentFolderIds(portletRequest).put(className, classPK);
    }

    public void addSelection(PortletRequest portletRequest, PortletPreferences portletPreferences, String portletId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long assetEntryId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"assetEntryId");
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"assetEntryOrder");
        String assetEntryType = ParamUtil.getString((PortletRequest)portletRequest, (String)"assetEntryType");
        this.addSelection(themeDisplay, portletPreferences, portletId, assetEntryId, assetEntryOrder, assetEntryType);
    }

    public void addSelection(ThemeDisplay themeDisplay, PortletPreferences portletPreferences, String portletId, long assetEntryId, int assetEntryOrder, String assetEntryType) throws Exception {
        long plid;
        String assetEntryXml;
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((long)assetEntryId);
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        if (!ArrayUtil.contains((Object[])assetEntryXmls, (Object)(assetEntryXml = this._getAssetEntryXml(assetEntryType, assetEntry.getClassUuid())))) {
            if (assetEntryOrder > -1) {
                assetEntryXmls[assetEntryOrder] = assetEntryXml;
            } else {
                assetEntryXmls = (String[])ArrayUtil.append((Object[])assetEntryXmls, (Object)assetEntryXml);
            }
            portletPreferences.setValues("assetEntryXml", (String[])assetEntryXmls);
        }
        if ((plid = themeDisplay.getRefererPlid()) == 0L) {
            plid = themeDisplay.getPlid();
        }
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        assetEntries.add(assetEntry);
        this.notifySubscribers(portletPreferences, plid, portletId, assetEntries);
    }

    public void addUserAttributes(User user, String[] customUserAttributeNames, AssetEntryQuery assetEntryQuery) throws Exception {
        if (user == null || customUserAttributeNames.length == 0) {
            return;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)user.getCompanyId());
        long[] allCategoryIds = assetEntryQuery.getAllCategoryIds();
        PrimitiveLongList allCategoryIdsList = new PrimitiveLongList(allCategoryIds.length + customUserAttributeNames.length);
        allCategoryIdsList.addAll(allCategoryIds);
        String[] stringArray = customUserAttributeNames;
        int n = customUserAttributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String customUserAttributeName = stringArray[n2];
            ExpandoBridge userCustomAttributes = user.getExpandoBridge();
            Serializable userCustomFieldValue = null;
            try {
                userCustomFieldValue = userCustomAttributes.getAttribute(customUserAttributeName);
            }
            catch (Exception exception) {}
            if (userCustomFieldValue != null) {
                String userCustomFieldValueString = userCustomFieldValue.toString();
                List assetCategories = AssetCategoryLocalServiceUtil.search((long)companyGroup.getGroupId(), (String)userCustomFieldValueString, (String[])new String[0], (int)-1, (int)-1);
                for (AssetCategory assetCategory : assetCategories) {
                    allCategoryIdsList.add(assetCategory.getCategoryId());
                }
            }
            ++n2;
        }
        assetEntryQuery.setAllCategoryIds(allCategoryIdsList.getArray());
    }

    public void checkAssetEntries() throws Exception {
        PortletPreferencesActionableDynamicQuery actionableDynamicQuery = new PortletPreferencesActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"portletId");
                String portletId = "101_INSTANCE_%";
                dynamicQuery.add(property.like((Object)portletId));
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                AssetPublisherImpl.this._checkAssetEntries((com.liferay.portal.model.PortletPreferences)object);
            }
        };
        actionableDynamicQuery.performActions();
    }

    public long[] getAssetCategoryIds(PortletPreferences portletPreferences) throws Exception {
        Object[] queryValues;
        long[] assetCategoryIds = new long[]{};
        int i2 = 0;
        while (!ArrayUtil.isEmpty((Object[])(queryValues = portletPreferences.getValues("queryValues" + i2, null)))) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i2, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i2, ""));
            String queryName = portletPreferences.getValue("queryName" + i2, "");
            if (Validator.equals((Object)queryName, (Object)"assetCategories") && queryContains && queryAndOperator) {
                assetCategoryIds = GetterUtil.getLongValues((String[])queryValues);
            }
            ++i2;
        }
        return assetCategoryIds;
    }

    public List<AssetEntry> getAssetEntries(PortletPreferences portletPreferences, Layout layout, long scopeGroupId, int max, boolean checkPermission) throws PortalException, SystemException {
        long[] groupIds = this.getGroupIds(portletPreferences, scopeGroupId, layout);
        AssetEntryQuery assetEntryQuery = this.getAssetEntryQuery(portletPreferences, groupIds);
        assetEntryQuery.setGroupIds(groupIds);
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyAssetType", null), (boolean)true);
        if (!anyAssetType) {
            long[] availableClassNameIds = AssetRendererFactoryRegistryUtil.getClassNameIds((long)layout.getCompanyId());
            long[] classNameIds = this.getClassNameIds(portletPreferences, availableClassNameIds);
            assetEntryQuery.setClassNameIds(classNameIds);
        }
        long[] classTypeIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("classTypeIds", null));
        assetEntryQuery.setClassTypeIds(classTypeIds);
        boolean enablePermissions = GetterUtil.getBoolean((String)portletPreferences.getValue("enablePermissions", null));
        assetEntryQuery.setEnablePermissions(enablePermissions);
        assetEntryQuery.setEnd(max);
        boolean excludeZeroViewCount = GetterUtil.getBoolean((String)portletPreferences.getValue("excludeZeroViewCount", null));
        assetEntryQuery.setExcludeZeroViewCount(excludeZeroViewCount);
        boolean showOnlyLayoutAssets = GetterUtil.getBoolean((String)portletPreferences.getValue("showOnlyLayoutAssets", null));
        if (showOnlyLayoutAssets) {
            assetEntryQuery.setLayout(layout);
        }
        String orderByColumn1 = GetterUtil.getString((String)portletPreferences.getValue("orderByColumn1", "modifiedDate"));
        assetEntryQuery.setOrderByCol1(orderByColumn1);
        String orderByColumn2 = GetterUtil.getString((String)portletPreferences.getValue("orderByColumn2", "title"));
        assetEntryQuery.setOrderByCol2(orderByColumn2);
        String orderByType1 = GetterUtil.getString((String)portletPreferences.getValue("orderByType1", "DESC"));
        assetEntryQuery.setOrderByType1(orderByType1);
        String orderByType2 = GetterUtil.getString((String)portletPreferences.getValue("orderByType2", "ASC"));
        assetEntryQuery.setOrderByType2(orderByType2);
        assetEntryQuery.setStart(0);
        if (checkPermission) {
            return AssetEntryServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery);
        }
        return AssetEntryLocalServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery);
    }

    public List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, long[] allCategoryIds, String[] assetEntryXmls, String[] allTagNames, boolean deleteMissingAssetEntries, boolean checkPermission) throws Exception {
        List<AssetEntry> assetEntries = this.getAssetEntries(portletRequest, portletPreferences, permissionChecker, groupIds, assetEntryXmls, deleteMissingAssetEntries, checkPermission);
        if (assetEntries.isEmpty() || ArrayUtil.isEmpty((long[])allCategoryIds) && ArrayUtil.isEmpty((Object[])allTagNames)) {
            return assetEntries;
        }
        if (!ArrayUtil.isEmpty((long[])allCategoryIds)) {
            assetEntries = this._filterAssetCategoriesAssetEntries(assetEntries, allCategoryIds);
        }
        if (!ArrayUtil.isEmpty((Object[])allTagNames)) {
            assetEntries = this._filterAssetTagNamesAssetEntries(assetEntries, allTagNames);
        }
        return assetEntries;
    }

    public List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletPreferences portletPreferences, PermissionChecker permissionChecker, long[] groupIds, String[] assetEntryXmls, boolean deleteMissingAssetEntries, boolean checkPermission) throws Exception {
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        ArrayList<String> missingAssetEntryUuids = new ArrayList<String>();
        String[] stringArray = assetEntryXmls;
        int n = assetEntryXmls.length;
        int n2 = 0;
        while (n2 < n) {
            String assetEntryXml = stringArray[n2];
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            String assetEntryUuid = rootElement.elementText("asset-entry-uuid");
            AssetEntry assetEntry = null;
            long[] lArray = groupIds;
            int n3 = groupIds.length;
            int n4 = 0;
            while (n4 < n3) {
                long groupId = lArray[n4];
                assetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)groupId, (String)assetEntryUuid);
                if (assetEntry != null) break;
                ++n4;
            }
            if (assetEntry == null) {
                if (deleteMissingAssetEntries) {
                    missingAssetEntryUuids.add(assetEntryUuid);
                }
            } else if (assetEntry.isVisible()) {
                AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
                AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
                if (!assetRendererFactory.isActive(permissionChecker.getCompanyId())) {
                    if (deleteMissingAssetEntries) {
                        missingAssetEntryUuids.add(assetEntryUuid);
                    }
                } else if (!checkPermission || assetRenderer.isDisplayable() && assetRenderer.hasViewPermission(permissionChecker)) {
                    assetEntries.add(assetEntry);
                }
            }
            ++n2;
        }
        if (deleteMissingAssetEntries) {
            AssetPublisherUtil.removeAndStoreSelection(missingAssetEntryUuids, (PortletPreferences)portletPreferences);
            if (!missingAssetEntryUuids.isEmpty()) {
                SessionMessages.add((PortletRequest)portletRequest, (String)"deletedMissingAssetEntries", missingAssetEntryUuids);
            }
        }
        return assetEntries;
    }

    public AssetEntryQuery getAssetEntryQuery(PortletPreferences portletPreferences, long[] scopeGroupIds) throws PortalException, SystemException {
        Object[] queryValues22;
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        long[] allAssetCategoryIds = new long[]{};
        long[] anyAssetCategoryIds = new long[]{};
        long[] notAllAssetCategoryIds = new long[]{};
        long[] notAnyAssetCategoryIds = new long[]{};
        Object[] allAssetTagNames = new String[]{};
        Object[] anyAssetTagNames = new String[]{};
        Object[] notAllAssetTagNames = new String[]{};
        Object[] notAnyAssetTagNames = new String[]{};
        int i2 = 0;
        while (!ArrayUtil.isEmpty((Object[])(queryValues22 = portletPreferences.getValues("queryValues" + i2, null)))) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i2, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i2, ""));
            String queryName = portletPreferences.getValue("queryName" + i2, "");
            if (Validator.equals((Object)queryName, (Object)"assetCategories")) {
                long[] assetCategoryIds = GetterUtil.getLongValues((String[])queryValues22);
                if (queryContains && queryAndOperator) {
                    allAssetCategoryIds = assetCategoryIds;
                } else if (queryContains && !queryAndOperator) {
                    anyAssetCategoryIds = assetCategoryIds;
                } else if (!queryContains && queryAndOperator) {
                    notAllAssetCategoryIds = assetCategoryIds;
                } else {
                    notAnyAssetCategoryIds = assetCategoryIds;
                }
            } else if (queryContains && queryAndOperator) {
                allAssetTagNames = queryValues22;
            } else if (queryContains && !queryAndOperator) {
                anyAssetTagNames = queryValues22;
            } else if (!queryContains && queryAndOperator) {
                notAllAssetTagNames = queryValues22;
            } else {
                notAnyAssetTagNames = queryValues22;
            }
            ++i2;
        }
        assetEntryQuery.setAllCategoryIds(allAssetCategoryIds);
        String[] stringArray = allAssetTagNames;
        int n = allAssetTagNames.length;
        int queryValues22 = 0;
        while (queryValues22 < n) {
            String assetTagName = stringArray[queryValues22];
            long[] allAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String)assetTagName);
            assetEntryQuery.addAllTagIdsArray(allAssetTagIds);
            ++queryValues22;
        }
        assetEntryQuery.setAnyCategoryIds(anyAssetCategoryIds);
        long[] anyAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String[])anyAssetTagNames);
        assetEntryQuery.setAnyTagIds(anyAssetTagIds);
        assetEntryQuery.setNotAllCategoryIds(notAllAssetCategoryIds);
        String[] stringArray2 = notAllAssetTagNames;
        int n2 = notAllAssetTagNames.length;
        n = 0;
        while (n < n2) {
            String assetTagName = stringArray2[n];
            long[] notAllAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String)assetTagName);
            assetEntryQuery.addNotAllTagIdsArray(notAllAssetTagIds);
            ++n;
        }
        assetEntryQuery.setNotAnyCategoryIds(notAnyAssetCategoryIds);
        long[] notAnyAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String[])notAnyAssetTagNames);
        assetEntryQuery.setNotAnyTagIds(notAnyAssetTagIds);
        return assetEntryQuery;
    }

    public String[] getAssetTagNames(PortletPreferences portletPreferences, long scopeGroupId) throws Exception {
        Object[] queryValues;
        Object[] allAssetTagNames = new String[]{};
        int i2 = 0;
        while (!ArrayUtil.isEmpty((Object[])(queryValues = portletPreferences.getValues("queryValues" + i2, null)))) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i2, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i2, ""));
            String queryName = portletPreferences.getValue("queryName" + i2, "");
            if (!Validator.equals((Object)queryName, (Object)"assetCategories") && queryContains && queryAndOperator) {
                allAssetTagNames = queryValues;
            }
            ++i2;
        }
        return allAssetTagNames;
    }

    public String getClassName(AssetRendererFactory assetRendererFactory) {
        Class<?> clazz = assetRendererFactory.getClass();
        String className = clazz.getName();
        int pos = className.lastIndexOf(".");
        return className.substring(pos + 1);
    }

    public long[] getClassNameIds(PortletPreferences portletPreferences, long[] availableClassNameIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyAssetType", Boolean.TRUE.toString()));
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (anyAssetType || selectionStyle.equals("manual")) {
            return availableClassNameIds;
        }
        long defaultClassNameId = GetterUtil.getLong((String)portletPreferences.getValue("anyAssetType", null));
        if (defaultClassNameId > 0L) {
            return new long[]{defaultClassNameId};
        }
        long[] classNameIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("classNameIds", null));
        if (ArrayUtil.isNotEmpty((long[])classNameIds)) {
            return classNameIds;
        }
        return availableClassNameIds;
    }

    public Long[] getClassTypeIds(PortletPreferences portletPreferences, String className, Long[] availableClassTypeIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyClassType" + className, Boolean.TRUE.toString()));
        if (anyAssetType) {
            return availableClassTypeIds;
        }
        long defaultClassTypeId = GetterUtil.getLong((String)portletPreferences.getValue("anyClassType" + className, null));
        if (defaultClassTypeId > 0L) {
            return new Long[]{defaultClassTypeId};
        }
        Long[] classTypeIds = ArrayUtil.toArray((long[])StringUtil.split((String)portletPreferences.getValue("classTypeIds" + className, null), (long)0L));
        if (classTypeIds != null) {
            return classTypeIds;
        }
        return availableClassTypeIds;
    }

    public Map<Locale, String> getEmailAssetEntryAddedBodyMap(PortletPreferences portletPreferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)portletPreferences, (String)"emailAssetEntryAddedBody");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getSiteDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get((String)"asset.publisher.email.asset.entry.added.body")));
        return map;
    }

    public boolean getEmailAssetEntryAddedEnabled(PortletPreferences portletPreferences) {
        String emailAssetEntryAddedEnabled = portletPreferences.getValue("emailAssetEntryAddedEnabled", "");
        if (Validator.isNotNull((String)emailAssetEntryAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailAssetEntryAddedEnabled);
        }
        return PropsValues.ASSET_PUBLISHER_EMAIL_ASSET_ENTRY_ADDED_ENABLED;
    }

    public Map<Locale, String> getEmailAssetEntryAddedSubjectMap(PortletPreferences portletPreferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)portletPreferences, (String)"emailAssetEntryAddedSubject");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getSiteDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get((String)"asset.publisher.email.asset.entry.added.subject")));
        return map;
    }

    public String getEmailFromAddress(PortletPreferences portletPreferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)portletPreferences, (long)companyId, (String)PropsValues.ASSET_PUBLISHER_EMAIL_FROM_ADDRESS);
    }

    public String getEmailFromName(PortletPreferences portletPreferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromName((PortletPreferences)portletPreferences, (long)companyId, (String)PropsValues.ASSET_PUBLISHER_EMAIL_FROM_NAME);
    }

    public long getGroupIdFromScopeId(String scopeId, long siteGroupId, boolean privateLayout) throws PortalException, SystemException {
        if (scopeId.startsWith("ChildGroup_")) {
            String scopeIdSuffix = scopeId.substring("ChildGroup_".length());
            long childGroupId = GetterUtil.getLong((String)scopeIdSuffix);
            Group childGroup = GroupLocalServiceUtil.getGroup((long)childGroupId);
            if (!childGroup.hasAncestor(siteGroupId)) {
                throw new PrincipalException();
            }
            return childGroupId;
        }
        if (scopeId.startsWith("Group_")) {
            String scopeIdSuffix = scopeId.substring("Group_".length());
            if (scopeIdSuffix.equals("default")) {
                return siteGroupId;
            }
            long scopeGroupId = GetterUtil.getLong((String)scopeIdSuffix);
            Group scopeGroup = GroupLocalServiceUtil.fetchGroup((long)scopeGroupId);
            if (scopeGroup == null) {
                throw new PrincipalException();
            }
            return scopeGroupId;
        }
        if (scopeId.startsWith("LayoutUuid_")) {
            String layoutUuid = scopeId.substring("LayoutUuid_".length());
            Layout scopeIdLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)layoutUuid, (long)siteGroupId, (boolean)privateLayout);
            Group scopeIdGroup = null;
            scopeIdGroup = scopeIdLayout.hasScopeGroup() ? scopeIdLayout.getScopeGroup() : GroupLocalServiceUtil.addGroup((long)PrincipalThreadLocal.getUserId(), (long)0L, (String)Layout.class.getName(), (long)scopeIdLayout.getPlid(), (long)0L, (String)String.valueOf(scopeIdLayout.getPlid()), null, (int)0, (boolean)true, (int)0, null, (boolean)false, (boolean)true, null);
            return scopeIdGroup.getGroupId();
        }
        if (scopeId.startsWith("Layout_")) {
            String scopeIdSuffix = scopeId.substring("Layout_".length());
            long scopeIdLayoutId = GetterUtil.getLong((String)scopeIdSuffix);
            Layout scopeIdLayout = LayoutLocalServiceUtil.getLayout((long)siteGroupId, (boolean)privateLayout, (long)scopeIdLayoutId);
            Group scopeIdGroup = scopeIdLayout.getScopeGroup();
            return scopeIdGroup.getGroupId();
        }
        if (scopeId.startsWith("ParentGroup_")) {
            String scopeIdSuffix = scopeId.substring("ParentGroup_".length());
            long parentGroupId = GetterUtil.getLong((String)scopeIdSuffix);
            Group parentGroup = GroupLocalServiceUtil.getGroup((long)parentGroupId);
            if (!SitesUtil.isContentSharingWithChildrenEnabled((Group)parentGroup)) {
                throw new PrincipalException();
            }
            Group group = GroupLocalServiceUtil.getGroup((long)siteGroupId);
            if (!group.hasAncestor(parentGroupId)) {
                throw new PrincipalException();
            }
            return parentGroupId;
        }
        throw new IllegalArgumentException("Invalid scope ID " + scopeId);
    }

    public long[] getGroupIds(PortletPreferences portletPreferences, long scopeGroupId, Layout layout) {
        String[] scopeIds = portletPreferences.getValues("scopeIds", new String[]{"Group_" + scopeGroupId});
        ArrayList<Long> groupIds = new ArrayList<Long>();
        String[] stringArray = scopeIds;
        int n = scopeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String scopeId = stringArray[n2];
            try {
                long groupId = this.getGroupIdFromScopeId(scopeId, scopeGroupId, layout.isPrivateLayout());
                groupIds.add(groupId);
            }
            catch (Exception exception) {}
            ++n2;
        }
        return ArrayUtil.toLongArray(groupIds);
    }

    public long getRecentFolderId(PortletRequest portletRequest, String className) {
        Long classPK = this._getRecentFolderIds(portletRequest).get(className);
        if (classPK == null) {
            return 0L;
        }
        return classPK;
    }

    public String getScopeId(Group group, long scopeGroupId) throws PortalException, SystemException {
        String key = null;
        if (group.isLayout()) {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK());
            key = "LayoutUuid_" + layout.getUuid();
        } else {
            Group scopeGroup;
            key = group.isLayoutPrototype() || group.getGroupId() == scopeGroupId ? "Group_default" : ((scopeGroup = GroupLocalServiceUtil.getGroup((long)scopeGroupId)).hasAncestor(group.getGroupId()) && SitesUtil.isContentSharingWithChildrenEnabled((Group)group) ? "ParentGroup_" + group.getGroupId() : (group.hasAncestor(scopeGroup.getGroupId()) ? "ChildGroup_" + group.getGroupId() : "Group_" + group.getGroupId()));
        }
        return key;
    }

    public boolean isScopeIdSelectable(PermissionChecker permissionChecker, String scopeId, long companyGroupId, Layout layout) throws PortalException, SystemException {
        long groupId = this.getGroupIdFromScopeId(scopeId, layout.getGroupId(), layout.isPrivateLayout());
        if (scopeId.startsWith("ChildGroup_")) {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (!group.hasAncestor(layout.getGroupId())) {
                return false;
            }
        } else {
            if (scopeId.startsWith("ParentGroup_")) {
                Group siteGroup = layout.getGroup();
                if (!siteGroup.hasAncestor(groupId)) {
                    return false;
                }
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                if (SitesUtil.isContentSharingWithChildrenEnabled((Group)group)) {
                    return true;
                }
                if (!PrefsPropsUtil.getBoolean((long)layout.getCompanyId(), (String)"sites.content.sharing.through.administrators.enabled")) {
                    return false;
                }
                return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"UPDATE");
            }
            if (groupId != companyGroupId) {
                return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"UPDATE");
            }
        }
        return true;
    }

    public boolean isSubscribed(long companyId, long userId, long plid, String portletId) throws PortalException, SystemException {
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)com.liferay.portal.model.PortletPreferences.class.getName(), (long)this._getPortletPreferencesId(plid, portletId));
    }

    public void notifySubscribers(PortletPreferences portletPreferences, long plid, String portletId, List<AssetEntry> assetEntries) throws PortalException, SystemException {
        if (!this.getEmailAssetEntryAddedEnabled(portletPreferences) || assetEntries.isEmpty()) {
            return;
        }
        AssetEntry assetEntry = assetEntries.get(0);
        String fromName = this.getEmailFromName(portletPreferences, assetEntry.getCompanyId());
        String fromAddress = this.getEmailFromAddress(portletPreferences, assetEntry.getCompanyId());
        Map<Locale, String> localizedSubjectMap = this.getEmailAssetEntryAddedSubjectMap(portletPreferences);
        Map<Locale, String> localizedBodyMap = this.getEmailAssetEntryAddedBodyMap(portletPreferences);
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(assetEntry.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ASSET_ENTRIES$]", ListUtil.toString(assetEntries, this._titleAccessor, (String)", ")});
        subscriptionSender.setContextUserPrefix("ASSET_PUBLISHER");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("asset_entry", new Object[]{assetEntry.getEntryId()});
        subscriptionSender.setPortletId("101");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.addPersistedSubscribers(com.liferay.portal.model.PortletPreferences.class.getName(), this._getPortletPreferencesId(plid, portletId));
        subscriptionSender.flushNotificationsAsync();
    }

    public void processAssetEntryQuery(User user, PortletPreferences portletPreferences, AssetEntryQuery assetEntryQuery) throws Exception {
        for (AssetEntryQueryProcessor assetEntryQueryProcessor : this._assetEntryQueryProcessor.values()) {
            assetEntryQueryProcessor.processAssetEntryQuery(user, portletPreferences, assetEntryQuery);
        }
    }

    public void registerAssetQueryProcessor(String assetQueryProcessorClassName, AssetEntryQueryProcessor assetQueryProcessor) {
        if (assetQueryProcessor == null) {
            return;
        }
        this._assetEntryQueryProcessor.put(assetQueryProcessorClassName, assetQueryProcessor);
    }

    public void removeAndStoreSelection(List<String> assetEntryUuids, PortletPreferences portletPreferences) throws Exception {
        if (assetEntryUuids.size() == 0) {
            return;
        }
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        List assetEntryXmlsList = ListUtil.fromArray((Object[])assetEntryXmls);
        Iterator itr = assetEntryXmlsList.iterator();
        while (itr.hasNext()) {
            String assetEntryXml = (String)itr.next();
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            String assetEntryUuid = rootElement.elementText("asset-entry-uuid");
            if (!assetEntryUuids.contains(assetEntryUuid)) continue;
            itr.remove();
        }
        portletPreferences.setValues("assetEntryXml", assetEntryXmlsList.toArray(new String[assetEntryXmlsList.size()]));
        portletPreferences.store();
    }

    public void removeRecentFolderId(PortletRequest portletRequest, String className, long classPK) {
        if (this.getRecentFolderId(portletRequest, className) == classPK) {
            this._getRecentFolderIds(portletRequest).remove(className);
        }
    }

    public void subscribe(PermissionChecker permissionChecker, long groupId, long plid, String portletId) throws PortalException, SystemException {
        PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)plid, (String)portletId, (String)"SUBSCRIBE");
        SubscriptionLocalServiceUtil.addSubscription((long)permissionChecker.getUserId(), (long)groupId, (String)com.liferay.portal.model.PortletPreferences.class.getName(), (long)this._getPortletPreferencesId(plid, portletId));
    }

    public void unregisterAssetQueryProcessor(String assetQueryProcessorClassName) {
        this._assetEntryQueryProcessor.remove(assetQueryProcessorClassName);
    }

    public void unsubscribe(PermissionChecker permissionChecker, long plid, String portletId) throws PortalException, SystemException {
        PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)plid, (String)portletId, (String)"SUBSCRIBE");
        SubscriptionLocalServiceUtil.deleteSubscription((long)permissionChecker.getUserId(), (String)com.liferay.portal.model.PortletPreferences.class.getName(), (long)this._getPortletPreferencesId(plid, portletId));
    }

    private void _checkAssetEntries(com.liferay.portal.model.PortletPreferences portletPreferencesModel) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)portletPreferencesModel.getPlid());
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)layout.getCompanyId(), (long)portletPreferencesModel.getOwnerId(), (int)portletPreferencesModel.getOwnerType(), (long)portletPreferencesModel.getPlid(), (String)portletPreferencesModel.getPortletId(), (String)portletPreferencesModel.getPreferences());
        if (!this.getEmailAssetEntryAddedEnabled(portletPreferences)) {
            return;
        }
        List<AssetEntry> assetEntries = this.getAssetEntries(portletPreferences, layout, layout.getGroupId(), PropsValues.ASSET_PUBLISHER_DYNAMIC_SUBSCRIPTION_LIMIT, false);
        if (assetEntries.isEmpty()) {
            return;
        }
        long[] notifiedAssetEntryIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("notifiedAssetEntryIds", null));
        ArrayList<AssetEntry> newAssetEntries = new ArrayList<AssetEntry>();
        int i2 = 0;
        while (i2 < assetEntries.size()) {
            AssetEntry assetEntry = assetEntries.get(i2);
            if (!ArrayUtil.contains((long[])notifiedAssetEntryIds, (long)assetEntry.getEntryId())) {
                newAssetEntries.add(assetEntry);
            }
            ++i2;
        }
        this.notifySubscribers(portletPreferences, portletPreferencesModel.getPlid(), portletPreferencesModel.getPortletId(), newAssetEntries);
        try {
            portletPreferences.setValues("notifiedAssetEntryIds", StringUtil.split((String)ListUtil.toString(assetEntries, (Accessor)AssetEntry.ENTRY_ID_ACCESSOR)));
            portletPreferences.store();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (PortletException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    private List<AssetEntry> _filterAssetCategoriesAssetEntries(List<AssetEntry> assetEntries, long[] assetCategoryIds) throws Exception {
        ArrayList<AssetEntry> filteredAssetEntries = new ArrayList<AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            if (!ArrayUtil.containsAll((long[])assetEntry.getCategoryIds(), (long[])assetCategoryIds)) continue;
            filteredAssetEntries.add(assetEntry);
        }
        return filteredAssetEntries;
    }

    private List<AssetEntry> _filterAssetTagNamesAssetEntries(List<AssetEntry> assetEntries, String[] assetTagNames) throws Exception {
        ArrayList<AssetEntry> filteredAssetEntries = new ArrayList<AssetEntry>();
        for (AssetEntry assetEntry : assetEntries) {
            List assetTags = assetEntry.getTags();
            Object[] assetEntryAssetTagNames = new String[assetTags.size()];
            int i2 = 0;
            while (i2 < assetTags.size()) {
                AssetTag assetTag = (AssetTag)assetTags.get(i2);
                assetEntryAssetTagNames[i2] = assetTag.getName();
                ++i2;
            }
            if (!ArrayUtil.containsAll((Object[])assetEntryAssetTagNames, (Object[])assetTagNames)) continue;
            filteredAssetEntries.add(assetEntry);
        }
        return filteredAssetEntries;
    }

    private String _getAssetEntryXml(String assetEntryType, String assetEntryUuid) {
        String xml;
        block2: {
            xml = null;
            try {
                Document document = SAXReaderUtil.createDocument((String)"UTF-8");
                Element assetEntryElement = document.addElement("asset-entry");
                Element assetEntryTypeElement = assetEntryElement.addElement("asset-entry-type");
                assetEntryTypeElement.addText(assetEntryType);
                Element assetEntryUuidElement = assetEntryElement.addElement("asset-entry-uuid");
                assetEntryUuidElement.addText(assetEntryUuid);
                xml = document.formattedString("");
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)ioe);
            }
        }
        return xml;
    }

    private long _getPortletPreferencesId(long plid, String portletId) throws PortalException, SystemException {
        com.liferay.portal.model.PortletPreferences portletPreferencesModel = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)0L, (int)3, (long)plid, (String)portletId);
        return portletPreferencesModel.getPortletPreferencesId();
    }

    private Map<String, Long> _getRecentFolderIds(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String key = AssetPublisherUtil.class + "_" + themeDisplay.getScopeGroupId();
        HashMap<String, Long> recentFolderIds = (HashMap<String, Long>)session.getAttribute(key);
        if (recentFolderIds == null) {
            recentFolderIds = new HashMap<String, Long>();
        }
        session.setAttribute(key, recentFolderIds);
        return recentFolderIds;
    }
}

