/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.lar.FolderUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FolderStagedModelDataHandler
extends BaseStagedModelDataHandler<Folder> {
    public static final String[] CLASS_NAMES = new String[]{DLFolder.class.getName(), Folder.class.getName(), LiferayFolder.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(FolderStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        Folder folder = FolderUtil.fetchByUUID_R(uuid, groupId);
        if (folder != null) {
            DLAppLocalServiceUtil.deleteFolder((long)folder.getFolderId());
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Folder folder) {
        return folder.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder);
        String folderPath = ExportImportPathUtil.getModelPath((StagedModel)folder);
        if (!folder.isDefaultRepository()) {
            Repository repository = RepositoryLocalServiceUtil.getRepository((long)folder.getRepositoryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)repository, (String)"strong");
            portletDataContext.addClassedModel(folderElement, folderPath, (ClassedModel)folder);
            long liferayRepositoryClassNameId = PortalUtil.getClassNameId((String)LiferayRepository.class.getName());
            if (repository.getClassNameId() != liferayRepositoryClassNameId) {
                return;
            }
        }
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)folder.getParentFolder(), (String)"parent");
        }
        this.exportFolderFileEntryTypes(portletDataContext, folderElement, folder);
        portletDataContext.addClassedModel(folderElement, folderPath, (ClassedModel)folder, DLFolder.class);
    }

    protected void doImportCompanyStagedModel(PortletDataContext portletDataContext, String uuid, long folderId) throws Exception {
        Folder existingFolder = FolderUtil.fetchByUUID_R(uuid, portletDataContext.getCompanyGroupId());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        folderIds.put(folderId, existingFolder.getFolderId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        if (!folder.isDefaultRepository()) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, Repository.class, (long)folder.getRepositoryId());
            return;
        }
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, DLFolder.class, (long)folder.getParentFolderId());
        }
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)folder, DLFolder.class);
        serviceContext.setUserId(userId);
        Folder importedFolder = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Folder existingFolder = FolderUtil.fetchByUUID_R(folder.getUuid(), portletDataContext.getScopeGroupId());
            if (existingFolder == null) {
                String name = this.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                serviceContext.setUuid(folder.getUuid());
                importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                String name = this.getFolderName(folder.getUuid(), portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                importedFolder = DLAppLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            String name = this.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
            importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        Element folderElement = portletDataContext.getImportDataElement((StagedModel)folder);
        this.importFolderFileEntryTypes(portletDataContext, folderElement, folder, importedFolder, serviceContext);
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder, DLFolder.class);
        folderIds.put(folder.getFolderId(), importedFolder.getFolderId());
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, Folder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Folder existingFolder = FolderUtil.fetchByUUID_R(folder.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFolder == null || !(existingFolder.getModel() instanceof DLFolder)) {
            return;
        }
        DLFolder dlFolder = (DLFolder)existingFolder.getModel();
        if (!dlFolder.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFolder.class.getName());
        if (trashHandler.isRestorable(existingFolder.getFolderId())) {
            trashHandler.restoreTrashEntry(userId, existingFolder.getFolderId());
        }
    }

    protected void exportFolderFileEntryTypes(PortletDataContext portletDataContext, Element folderElement, Folder folder) throws Exception {
        if (!folder.isDefaultRepository()) {
            return;
        }
        List dlFileEntryTypes = DLFileEntryTypeLocalServiceUtil.getFolderFileEntryTypes((long[])new long[]{portletDataContext.getCompanyGroupId(), portletDataContext.getScopeGroupId()}, (long)folder.getFolderId(), (boolean)false);
        long defaultFileEntryTypeId = DLFileEntryTypeLocalServiceUtil.getDefaultFileEntryTypeId((long)folder.getFolderId());
        String defaultFileEntryTypeUuid = "";
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            if (dlFileEntryType.getFileEntryTypeId() == 0L) {
                folderElement.addAttribute("basic-document", "true");
                continue;
            }
            if (defaultFileEntryTypeId == dlFileEntryType.getFileEntryTypeId()) {
                defaultFileEntryTypeUuid = dlFileEntryType.getUuid();
            }
            if (!dlFileEntryType.isExportable()) continue;
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)dlFileEntryType, (String)"strong");
        }
        folderElement.addAttribute("defaultFileEntryTypeUuid", defaultFileEntryTypeUuid);
    }

    protected String getFolderName(String uuid, long groupId, long parentFolderId, String name, int count) throws Exception {
        Folder folder = FolderUtil.fetchByR_P_N(groupId, parentFolderId, name);
        if (folder == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(folder.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getFolderName(uuid, groupId, parentFolderId, name, ++count);
    }

    protected void importFolderFileEntryTypes(PortletDataContext portletDataContext, Element folderElement, Folder folder, Folder importedFolder, ServiceContext serviceContext) throws Exception {
        if (!folder.isDefaultRepository()) {
            return;
        }
        ArrayList<Long> currentFolderFileEntryTypeIds = new ArrayList<Long>();
        String defaultFileEntryTypeUuid = GetterUtil.getString((String)folderElement.attributeValue("defaultFileEntryTypeUuid"));
        long defaultFileEntryTypeId = 0L;
        List referenceElements = portletDataContext.getReferenceElements((StagedModel)folder, DLFileEntryType.class);
        for (Element referenceElement : referenceElements) {
            long referenceDlFileEntryTypeId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            String referenceDlFileEntryTypeUuid = referenceElement.attributeValue("uuid");
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, DLFileEntryType.class, (long)referenceDlFileEntryTypeId);
            Map dlFileEntryTypeIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntryType.class);
            long dlFileEntryTypeId = MapUtil.getLong((Map)dlFileEntryTypeIds, (long)referenceDlFileEntryTypeId, (long)referenceDlFileEntryTypeId);
            DLFileEntryType existingDLFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)dlFileEntryTypeId);
            if (existingDLFileEntryType == null) continue;
            currentFolderFileEntryTypeIds.add(existingDLFileEntryType.getFileEntryTypeId());
            if (!defaultFileEntryTypeUuid.equals(referenceDlFileEntryTypeUuid)) continue;
            defaultFileEntryTypeId = existingDLFileEntryType.getFileEntryTypeId();
        }
        if (GetterUtil.getBoolean((String)folderElement.attributeValue("basic-document"))) {
            currentFolderFileEntryTypeIds.add(0L);
        }
        if (!currentFolderFileEntryTypeIds.isEmpty()) {
            DLFolder dlFolder = (DLFolder)importedFolder.getModel();
            dlFolder.setDefaultFileEntryTypeId(defaultFileEntryTypeId);
            dlFolder.setOverrideFileEntryTypes(true);
            DLFolderLocalServiceUtil.updateDLFolder((DLFolder)dlFolder);
            DLFileEntryTypeLocalServiceUtil.updateFolderFileEntryTypes((DLFolder)dlFolder, currentFolderFileEntryTypeIds, (long)defaultFileEntryTypeId, (ServiceContext)serviceContext);
        }
    }

    protected void validateExport(PortletDataContext portletDataContext, Folder folder) throws PortletDataException {
        block7: {
            if (folder.getGroupId() != portletDataContext.getGroupId() && folder.getGroupId() != portletDataContext.getScopeGroupId()) {
                PortletDataException pde = new PortletDataException(4);
                pde.setStagedModel((StagedModel)folder);
                throw pde;
            }
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFolder.class.getName());
            if (trashHandler != null) {
                try {
                    if (trashHandler.isInTrash(folder.getFolderId()) || trashHandler.isInTrashContainer(folder.getFolderId())) {
                        throw new PortletDataException(8);
                    }
                }
                catch (PortletDataException pde) {
                    throw pde;
                }
                catch (Exception e2) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e2, (Throwable)e2);
                    }
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)("Unable to check trash status for folder " + folder.getFolderId()));
                }
            }
        }
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        DLFolder dlFolder = DLFolderLocalServiceUtil.fetchDLFolderByUuidAndGroupId((String)uuid, (long)groupId);
        return dlFolder != null;
    }
}

