/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileEntryTypeException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.NoSuchMetadataSetException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryTypeLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.RequiredStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureXsdException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DLFileEntryTypeLocalServiceImpl
extends DLFileEntryTypeLocalServiceBaseImpl {
    public DLFileEntryType addFileEntryType(long userId, long groupId, String fileEntryTypeKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileEntryTypeId;
        long ddmStructureId;
        User user = this.userPersistence.findByPrimaryKey(userId);
        fileEntryTypeKey = Validator.isNull((String)fileEntryTypeKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)fileEntryTypeKey.trim());
        String fileEntryTypeUuid = serviceContext.getUuid();
        if (Validator.isNull((String)fileEntryTypeUuid)) {
            fileEntryTypeUuid = PortalUUIDUtil.generate();
        }
        if ((ddmStructureId = this.updateDDMStructure(userId, fileEntryTypeUuid, fileEntryTypeId = this.counterLocalService.increment(), groupId, nameMap, descriptionMap, serviceContext)) > 0L) {
            ddmStructureIds = ArrayUtil.append((long[])ddmStructureIds, (long)ddmStructureId);
        }
        Date now = new Date();
        this.validate(fileEntryTypeId, groupId, fileEntryTypeKey, ddmStructureIds);
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.create(fileEntryTypeId);
        dlFileEntryType.setUuid(fileEntryTypeUuid);
        dlFileEntryType.setGroupId(groupId);
        dlFileEntryType.setCompanyId(user.getCompanyId());
        dlFileEntryType.setUserId(user.getUserId());
        dlFileEntryType.setUserName(user.getFullName());
        dlFileEntryType.setCreateDate(serviceContext.getCreateDate(now));
        dlFileEntryType.setModifiedDate(serviceContext.getModifiedDate(now));
        dlFileEntryType.setFileEntryTypeKey(fileEntryTypeKey);
        dlFileEntryType.setNameMap(nameMap);
        dlFileEntryType.setDescriptionMap(descriptionMap);
        this.dlFileEntryTypePersistence.update((BaseModel)dlFileEntryType);
        this.dlFileEntryTypePersistence.addDDMStructures(fileEntryTypeId, ddmStructureIds);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFileEntryTypeResources(dlFileEntryType, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return dlFileEntryType;
    }

    public DLFileEntryType addFileEntryType(long userId, long groupId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getSiteDefault(), description);
        return this.addFileEntryType(userId, groupId, null, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    public void cascadeFileEntryTypes(long userId, DLFolder dlFolder) throws PortalException, SystemException {
        long[] groupIds = PortalUtil.getSiteAndCompanyGroupIds((long)dlFolder.getGroupId());
        List<DLFileEntryType> dlFileEntryTypes = this.getFolderFileEntryTypes(groupIds, dlFolder.getFolderId(), true);
        List<Long> fileEntryTypeIds = this.getFileEntryTypeIds(dlFileEntryTypes);
        long defaultFileEntryTypeId = this.getDefaultFileEntryTypeId(dlFolder.getFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(dlFolder.getCompanyId());
        serviceContext.setScopeGroupId(dlFolder.getGroupId());
        serviceContext.setUserId(userId);
        this.cascadeFileEntryTypes(userId, dlFolder.getGroupId(), dlFolder.getFolderId(), defaultFileEntryTypeId, fileEntryTypeIds, serviceContext);
    }

    @SystemEvent(action=1, type=1)
    public void deleteFileEntryType(DLFileEntryType dlFileEntryType) throws PortalException, SystemException {
        if (this.dlFileEntryPersistence.countByFileEntryTypeId(dlFileEntryType.getFileEntryTypeId()) > 0) {
            throw new RequiredStructureException(1);
        }
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(dlFileEntryType.getGroupId(), PortalUtil.getClassNameId(DLFileEntryMetadata.class), DLUtil.getDDMStructureKey((DLFileEntryType)dlFileEntryType));
        if (ddmStructure == null) {
            ddmStructure = this.ddmStructureLocalService.fetchStructure(dlFileEntryType.getGroupId(), PortalUtil.getClassNameId(DLFileEntryMetadata.class), DLUtil.getDeprecatedDDMStructureKey((DLFileEntryType)dlFileEntryType));
        }
        if (ddmStructure != null) {
            this.ddmStructureLocalService.deleteStructure(ddmStructure.getStructureId());
        }
        this.dlFileEntryTypePersistence.remove((BaseModel)dlFileEntryType);
    }

    public void deleteFileEntryType(long fileEntryTypeId) throws PortalException, SystemException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
        this.deleteFileEntryType(dlFileEntryType);
    }

    public void deleteFileEntryTypes(long groupId) throws PortalException, SystemException {
        List dlFileEntryTypes = this.dlFileEntryTypePersistence.findByGroupId(groupId);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            this.deleteFileEntryType(dlFileEntryType);
        }
    }

    public DLFileEntryType fetchFileEntryType(long fileEntryTypeId) throws SystemException {
        return this.dlFileEntryTypePersistence.fetchByPrimaryKey(fileEntryTypeId);
    }

    public DLFileEntryType fetchFileEntryType(long groupId, String fileEntryTypeKey) throws SystemException {
        fileEntryTypeKey = StringUtil.toUpperCase((String)fileEntryTypeKey.trim());
        return this.dlFileEntryTypePersistence.fetchByG_F(groupId, fileEntryTypeKey);
    }

    public long getDefaultFileEntryTypeId(long folderId) throws PortalException, SystemException {
        if ((folderId = this.getFileEntryTypesPrimaryFolderId(folderId)) != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            return dlFolder.getDefaultFileEntryTypeId();
        }
        return 0L;
    }

    public DLFileEntryType getFileEntryType(long fileEntryTypeId) throws PortalException, SystemException {
        return this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
    }

    public DLFileEntryType getFileEntryType(long groupId, String fileEntryTypeKey) throws PortalException, SystemException {
        fileEntryTypeKey = StringUtil.toUpperCase((String)fileEntryTypeKey.trim());
        return this.dlFileEntryTypePersistence.findByG_F(groupId, fileEntryTypeKey);
    }

    public List<DLFileEntryType> getFileEntryTypes(long[] groupIds) throws SystemException {
        return this.dlFileEntryTypePersistence.findByGroupId(groupIds);
    }

    public List<DLFileEntryType> getFolderFileEntryTypes(long[] groupIds, long folderId, boolean inherited) throws PortalException, SystemException {
        if (!inherited) {
            return this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        }
        ArrayList<DLFileEntryType> dlFileEntryTypes = null;
        if ((folderId = this.getFileEntryTypesPrimaryFolderId(folderId)) != 0L) {
            dlFileEntryTypes = this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        }
        if (dlFileEntryTypes == null || dlFileEntryTypes.isEmpty()) {
            dlFileEntryTypes = new ArrayList<DLFileEntryType>(this.getFileEntryTypes(groupIds));
            DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.fetchByPrimaryKey(0L);
            dlFileEntryTypes.add(0, dlFileEntryType);
        }
        return dlFileEntryTypes;
    }

    public List<DLFileEntryType> search(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.dlFileEntryTypeFinder.findByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, String keywords, boolean includeBasicFileEntryType) throws SystemException {
        return this.dlFileEntryTypeFinder.countByKeywords(companyId, groupIds, keywords, includeBasicFileEntryType);
    }

    public void unsetFolderFileEntryTypes(long folderId) throws SystemException {
        List dlFileEntryTypes = this.dlFolderPersistence.getDLFileEntryTypes(folderId);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            this.dlFolderPersistence.removeDLFileEntryType(folderId, dlFileEntryType);
        }
    }

    public DLFileEntry updateFileEntryFileEntryType(DLFileEntry dlFileEntry, ServiceContext serviceContext) throws PortalException, SystemException {
        List<DLFileEntryType> dlFileEntryTypes;
        List<Long> fileEntryTypeIds;
        long groupId = serviceContext.getScopeGroupId();
        long folderId = 0L;
        DLFolder dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(dlFileEntry.getFolderId());
        if (dlFolder != null) {
            groupId = dlFolder.getGroupId();
            folderId = dlFolder.getFolderId();
        }
        if ((fileEntryTypeIds = this.getFileEntryTypeIds(dlFileEntryTypes = this.getFolderFileEntryTypes(PortalUtil.getSiteAndCompanyGroupIds((long)groupId), folderId, true))).contains(dlFileEntry.getFileEntryTypeId())) {
            return dlFileEntry;
        }
        long defaultFileEntryTypeId = this.getDefaultFileEntryTypeId(folderId);
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
        if (dlFileVersion.isPending()) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
        }
        return this.dlFileEntryLocalService.updateFileEntry(serviceContext.getUserId(), dlFileEntry.getFileEntryId(), null, null, null, null, null, false, defaultFileEntryTypeId, null, null, null, 0L, serviceContext);
    }

    public void updateFileEntryType(long userId, long fileEntryTypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.findByPrimaryKey(fileEntryTypeId);
        long ddmStructureId = this.updateDDMStructure(userId, dlFileEntryType.getUuid(), fileEntryTypeId, dlFileEntryType.getGroupId(), nameMap, descriptionMap, serviceContext);
        if (ddmStructureId > 0L) {
            ddmStructureIds = ArrayUtil.append((long[])ddmStructureIds, (long)ddmStructureId);
        }
        this.validate(fileEntryTypeId, dlFileEntryType.getGroupId(), dlFileEntryType.getFileEntryTypeKey(), ddmStructureIds);
        dlFileEntryType.setModifiedDate(serviceContext.getModifiedDate(null));
        dlFileEntryType.setNameMap(nameMap);
        dlFileEntryType.setDescriptionMap(descriptionMap);
        this.dlFileEntryTypePersistence.update((BaseModel)dlFileEntryType);
        this.dlFileEntryTypePersistence.setDDMStructures(fileEntryTypeId, ddmStructureIds);
    }

    public void updateFileEntryType(long userId, long fileEntryTypeId, String name, String description, long[] ddmStructureIds, ServiceContext serviceContext) throws PortalException, SystemException {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getSiteDefault(), name);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getSiteDefault(), description);
        this.updateFileEntryType(userId, fileEntryTypeId, nameMap, descriptionMap, ddmStructureIds, serviceContext);
    }

    public void updateFolderFileEntryTypes(DLFolder dlFolder, List<Long> fileEntryTypeIds, long defaultFileEntryTypeId, ServiceContext serviceContext) throws PortalException, SystemException {
        List<Long> originalFileEntryTypeIds = this.getFileEntryTypeIds(this.dlFolderPersistence.getDLFileEntryTypes(dlFolder.getFolderId()));
        if (fileEntryTypeIds.equals(originalFileEntryTypeIds)) {
            return;
        }
        for (Long fileEntryTypeId : fileEntryTypeIds) {
            if (originalFileEntryTypeIds.contains(fileEntryTypeId)) continue;
            this.dlFolderPersistence.addDLFileEntryType(dlFolder.getFolderId(), fileEntryTypeId.longValue());
        }
        for (Long originalFileEntryTypeId : originalFileEntryTypeIds) {
            if (fileEntryTypeIds.contains(originalFileEntryTypeId)) continue;
            this.dlFolderPersistence.removeDLFileEntryType(dlFolder.getFolderId(), originalFileEntryTypeId.longValue());
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(dlFolder.getCompanyId(), dlFolder.getGroupId(), DLFolder.class.getName(), dlFolder.getFolderId(), originalFileEntryTypeId.longValue());
        }
    }

    protected void addFileEntryTypeResources(DLFileEntryType dlFileEntryType, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(dlFileEntryType.getCompanyId(), dlFileEntryType.getGroupId(), dlFileEntryType.getUserId(), DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addFileEntryTypeResources(DLFileEntryType dlFileEntryType, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(dlFileEntryType.getCompanyId(), dlFileEntryType.getGroupId(), dlFileEntryType.getUserId(), DLFileEntryType.class.getName(), dlFileEntryType.getFileEntryTypeId(), groupPermissions, guestPermissions);
    }

    protected void cascadeFileEntryTypes(long userId, long groupId, long folderId, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, ServiceContext serviceContext) throws PortalException, SystemException {
        List dlFileEntries = this.dlFileEntryPersistence.findByG_F(groupId, folderId);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            Long fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
            if (fileEntryTypeIds.contains(fileEntryTypeId)) continue;
            DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getLatestFileVersion(dlFileEntry.getFileEntryId(), true);
            if (dlFileVersion.isPending()) {
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(dlFileVersion.getCompanyId(), groupId, DLFileEntry.class.getName(), dlFileVersion.getFileVersionId());
            }
            this.dlFileEntryLocalService.updateFileEntry(userId, dlFileEntry.getFileEntryId(), null, null, null, null, null, false, defaultFileEntryTypeId, null, null, null, 0L, serviceContext);
        }
        List subFolders = this.dlFolderPersistence.findByG_M_P_H(groupId, false, folderId, false);
        for (DLFolder subFolder : subFolders) {
            long subFolderId = subFolder.getFolderId();
            if (subFolder.isOverrideFileEntryTypes()) continue;
            this.cascadeFileEntryTypes(userId, groupId, subFolderId, defaultFileEntryTypeId, fileEntryTypeIds, serviceContext);
        }
    }

    protected void fixDDMStructureKey(String fileEntryTypeUuid, long fileEntryTypeId, long groupId) throws SystemException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(groupId, PortalUtil.getClassNameId(DLFileEntryMetadata.class), DLUtil.getDeprecatedDDMStructureKey((long)fileEntryTypeId));
        if (ddmStructure != null) {
            ddmStructure.setStructureKey(DLUtil.getDDMStructureKey((String)fileEntryTypeUuid));
            this.ddmStructureLocalService.updateDDMStructure(ddmStructure);
        }
    }

    protected List<Long> getFileEntryTypeIds(List<DLFileEntryType> dlFileEntryTypes) {
        SortedArrayList fileEntryTypeIds = new SortedArrayList();
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
        }
        return fileEntryTypeIds;
    }

    protected long getFileEntryTypesPrimaryFolderId(long folderId) throws NoSuchFolderException, SystemException {
        while (folderId != 0L) {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            if (dlFolder.isOverrideFileEntryTypes()) break;
            folderId = dlFolder.getParentFolderId();
        }
        return folderId;
    }

    protected long updateDDMStructure(long userId, String fileEntryTypeUuid, long fileEntryTypeId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException, SystemException {
        this.fixDDMStructureKey(fileEntryTypeUuid, fileEntryTypeId, groupId);
        String ddmStructureKey = DLUtil.getDDMStructureKey((String)fileEntryTypeUuid);
        String xsd = ParamUtil.getString((ServiceContext)serviceContext, (String)"xsd");
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(groupId, PortalUtil.getClassNameId(DLFileEntryMetadata.class), ddmStructureKey);
        if (ddmStructure != null && Validator.isNull((String)xsd)) {
            xsd = ddmStructure.getXsd();
        }
        try {
            ddmStructure = ddmStructure == null ? this.ddmStructureLocalService.addStructure(userId, groupId, 0L, PortalUtil.getClassNameId(DLFileEntryMetadata.class), ddmStructureKey, nameMap, descriptionMap, xsd, "xml", 1, serviceContext) : this.ddmStructureLocalService.updateStructure(ddmStructure.getStructureId(), ddmStructure.getParentStructureId(), nameMap, descriptionMap, xsd, serviceContext);
            return ddmStructure.getStructureId();
        }
        catch (StructureXsdException structureXsdException) {
            if (ddmStructure != null) {
                this.ddmStructureLocalService.deleteStructure(ddmStructure.getStructureId());
            }
            return 0L;
        }
    }

    protected void validate(long fileEntryTypeId, long groupId, String fileEntryTypeKey, long[] ddmStructureIds) throws PortalException, SystemException {
        DLFileEntryType dlFileEntryType = this.dlFileEntryTypePersistence.fetchByG_F(groupId, fileEntryTypeKey);
        if (dlFileEntryType != null && dlFileEntryType.getFileEntryTypeId() != fileEntryTypeId) {
            throw new DuplicateFileEntryTypeException(fileEntryTypeKey);
        }
        if (ddmStructureIds.length == 0) {
            throw new NoSuchMetadataSetException();
        }
        long[] lArray = ddmStructureIds;
        int n = ddmStructureIds.length;
        int n2 = 0;
        while (n2 < n) {
            long ddmStructureId = lArray[n2];
            DDMStructure ddmStructure = this.ddmStructurePersistence.fetchByPrimaryKey(ddmStructureId);
            if (ddmStructure == null) {
                throw new NoSuchMetadataSetException("{ddmStructureId=" + ddmStructureId);
            }
            ++n2;
        }
    }
}

