/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.TreePathUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.base.DLFileVersionLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.comparator.FileVersionVersionComparator;
import java.util.Collections;
import java.util.List;

public class DLFileVersionLocalServiceImpl
extends DLFileVersionLocalServiceBaseImpl {
    public DLFileVersion getFileVersion(long fileVersionId) throws PortalException, SystemException {
        return this.dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
    }

    public DLFileVersion getFileVersion(long fileEntryId, String version) throws PortalException, SystemException {
        return this.dlFileVersionPersistence.findByF_V(fileEntryId, version);
    }

    public DLFileVersion getFileVersionByUuidAndGroupId(String uuid, long groupId) throws SystemException {
        return this.dlFileVersionPersistence.fetchByUUID_G(uuid, groupId);
    }

    public List<DLFileVersion> getFileVersions(long fileEntryId, int status) throws SystemException {
        List dlFileVersions = null;
        dlFileVersions = status == -1 ? this.dlFileVersionPersistence.findByFileEntryId(fileEntryId) : this.dlFileVersionPersistence.findByF_S(fileEntryId, status);
        dlFileVersions = ListUtil.copy((List)dlFileVersions);
        Collections.sort(dlFileVersions, new FileVersionVersionComparator());
        return dlFileVersions;
    }

    public int getFileVersionsCount(long fileEntryId, int status) throws SystemException {
        return this.dlFileVersionPersistence.countByF_S(fileEntryId, status);
    }

    public DLFileVersion getLatestFileVersion(long fileEntryId, boolean excludeWorkingCopy) throws PortalException, SystemException {
        List dlFileVersions = this.dlFileVersionPersistence.findByFileEntryId(fileEntryId);
        if (dlFileVersions.isEmpty()) {
            throw new NoSuchFileVersionException("No file versions found for fileEntryId " + fileEntryId);
        }
        dlFileVersions = ListUtil.copy((List)dlFileVersions);
        Collections.sort(dlFileVersions, new FileVersionVersionComparator());
        DLFileVersion dlFileVersion = (DLFileVersion)dlFileVersions.get(0);
        String version = dlFileVersion.getVersion();
        if (excludeWorkingCopy && version.equals("PWC")) {
            return (DLFileVersion)dlFileVersions.get(1);
        }
        return dlFileVersion;
    }

    public DLFileVersion getLatestFileVersion(long userId, long fileEntryId) throws PortalException, SystemException {
        boolean excludeWorkingCopy = true;
        if (this.dlFileEntryLocalService.isFileEntryCheckedOut(fileEntryId)) {
            excludeWorkingCopy = !this.dlFileEntryLocalService.hasFileEntryLock(userId, fileEntryId);
        }
        return this.getLatestFileVersion(fileEntryId, excludeWorkingCopy);
    }

    public void rebuildTree(long companyId) throws SystemException {
        this.dlFolderLocalService.rebuildTree(companyId);
        Session session = this.dlFileVersionPersistence.openSession();
        try {
            TreePathUtil.rebuildTree((Session)session, (long)companyId, (String)"DLFileVersion", (String)"DLFolder", (String)"folderId", (boolean)true);
        }
        finally {
            this.dlFileVersionPersistence.closeSession(session);
            this.dlFileVersionPersistence.clearCache();
        }
    }
}

