/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.documentlibrary.store.FileSystemStore;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AdvancedFileSystemStore
extends FileSystemStore {
    private static final String _HOOK_EXTENSION = "afsh";

    @Override
    public String[] getFileNames(long companyId, long repositoryId) {
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        String[] directories = FileUtil.listDirs((File)repositoryDir);
        ArrayList<String> fileNames = new ArrayList<String>();
        String[] stringArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            String directory = stringArray[n2];
            fileNames.addAll(this.getAdvancedFileNames(companyId, repositoryId, String.valueOf(repositoryDir.getPath()) + "/" + directory));
            ++n2;
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws PortalException, SystemException {
        String[] fileNameVersions;
        super.updateFile(companyId, repositoryId, fileName, newFileName);
        File newFileNameDir = this.getFileNameDir(companyId, repositoryId, newFileName);
        String[] stringArray = fileNameVersions = FileUtil.listFiles((File)newFileNameDir);
        int n = fileNameVersions.length;
        int n2 = 0;
        while (n2 < n) {
            File newFileNameVersionFile;
            File fileNameVersionFile;
            boolean renamed;
            String fileNameVersion = stringArray[n2];
            String ext = FileUtil.getExtension((String)fileNameVersion);
            if (!ext.equals(_HOOK_EXTENSION) && !(renamed = FileUtil.move((File)(fileNameVersionFile = new File(newFileNameDir + "/" + fileNameVersion)), (File)(newFileNameVersionFile = new File(newFileNameDir + "/" + FileUtil.stripExtension((String)fileNameVersion) + "." + _HOOK_EXTENSION))))) {
                throw new SystemException("File name version file was not renamed from " + fileNameVersionFile.getPath() + " to " + newFileNameVersionFile.getPath());
            }
            ++n2;
        }
    }

    protected void buildPath(StringBundler sb, String fileNameFragment) {
        int fileNameFragmentLength = fileNameFragment.length();
        if (fileNameFragmentLength <= 2 || this.getDepth(sb.toString()) > 3) {
            return;
        }
        int i2 = 0;
        while (i2 < fileNameFragmentLength) {
            if (i2 + 2 < fileNameFragmentLength) {
                sb.append(fileNameFragment.substring(i2, i2 + 2));
                sb.append("/");
                if (this.getDepth(sb.toString()) > 3) {
                    return;
                }
            }
            i2 += 2;
        }
    }

    protected List<String> getAdvancedFileNames(long companyId, long repositoryId, String fileName) {
        ArrayList<String> fileNames = new ArrayList<String>();
        String shortFileName = FileUtil.getShortFileName((String)fileName);
        if (shortFileName.equals("DLFE") || Validator.isNumber((String)shortFileName)) {
            String[] curFileNames;
            String[] stringArray = curFileNames = FileUtil.listDirs((String)fileName);
            int n = curFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String curFileName = stringArray[n2];
                fileNames.addAll(this.getAdvancedFileNames(companyId, repositoryId, String.valueOf(fileName) + "/" + curFileName));
                ++n2;
            }
        } else {
            if (shortFileName.endsWith(_HOOK_EXTENSION)) {
                shortFileName = FileUtil.stripExtension((String)shortFileName);
            }
            fileNames.add(shortFileName);
        }
        return fileNames;
    }

    protected int getDepth(String path) {
        String[] fragments = StringUtil.split((String)path, (char)'/');
        return fragments.length;
    }

    @Override
    protected File getDirNameDir(long companyId, long repositoryId, String dirName) {
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        return new File(repositoryDir + "/" + dirName);
    }

    @Override
    protected File getFileNameDir(long companyId, long repositoryId, String fileName) {
        if (fileName.indexOf(47) != -1) {
            return this.getDirNameDir(companyId, repositoryId, fileName);
        }
        String ext = "." + FileUtil.getExtension((String)fileName);
        if (ext.equals(".")) {
            ext = String.valueOf(ext) + _HOOK_EXTENSION;
        }
        StringBundler sb = new StringBundler();
        String fileNameFragment = FileUtil.stripExtension((String)fileName);
        if (fileNameFragment.startsWith("DLFE-")) {
            fileNameFragment = fileNameFragment.substring(5);
            sb.append("DLFE/");
        }
        this.buildPath(sb, fileNameFragment);
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        File fileNameDir = new File(repositoryDir + "/" + sb.toString() + "/" + fileNameFragment + ext);
        File parentFile = fileNameDir.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return fileNameDir;
    }

    @Override
    protected File getFileNameVersionFile(long companyId, long repositoryId, String fileName, String version) {
        int pos;
        String ext = "." + FileUtil.getExtension((String)fileName);
        if (ext.equals(".")) {
            ext = String.valueOf(ext) + _HOOK_EXTENSION;
        }
        if ((pos = fileName.lastIndexOf(47)) == -1) {
            StringBundler sb = new StringBundler();
            String fileNameFragment = FileUtil.stripExtension((String)fileName);
            if (fileNameFragment.startsWith("DLFE-")) {
                fileNameFragment = fileNameFragment.substring(5);
                sb.append("DLFE/");
            }
            this.buildPath(sb, fileNameFragment);
            File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
            return new File(repositoryDir + "/" + sb.toString() + "/" + fileNameFragment + ext + "/" + fileNameFragment + "_" + version + ext);
        }
        File fileNameDir = this.getDirNameDir(companyId, repositoryId, fileName);
        String fileNameFragment = FileUtil.stripExtension((String)fileName.substring(pos + 1));
        return new File(fileNameDir + "/" + fileNameFragment + "_" + version + ext);
    }

    @Override
    protected String getHeadVersionLabel(long companyId, long repositoryId, String fileName) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            return "1.0";
        }
        String[] versionLabels = FileUtil.listFiles((File)fileNameDir);
        String headVersionLabel = "1.0";
        int i2 = 0;
        while (i2 < versionLabels.length) {
            String versionLabel;
            String versionLabelFragment = versionLabels[i2];
            int x = versionLabelFragment.lastIndexOf(95);
            int y = versionLabelFragment.lastIndexOf(46);
            if (x > -1) {
                versionLabelFragment = versionLabelFragment.substring(x + 1, y);
            }
            if (DLUtil.compareVersions((String)(versionLabel = versionLabelFragment), (String)headVersionLabel) > 0) {
                headVersionLabel = versionLabel;
            }
            ++i2;
        }
        return headVersionLabel;
    }
}

