/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.jcr.JCRFactory;
import com.liferay.portal.jcr.JCRFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DuplicateDirectoryException;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.NoSuchDirectoryException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.store.BaseStore;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.commons.lang.StringUtils;

public class JCRStore
extends BaseStore {
    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                if (repositoryNode.hasNode(dirName)) {
                    throw new DuplicateDirectoryException(dirName);
                }
                String[] dirNameArray = StringUtil.split((String)dirName, (char)'/');
                Node dirNode = repositoryNode;
                int i2 = 0;
                while (i2 < dirNameArray.length) {
                    if (Validator.isNotNull((String)dirNameArray[i2])) {
                        dirNode = dirNode.hasNode(dirNameArray[i2]) ? dirNode.getNode(dirNameArray[i2]) : dirNode.addNode(dirNameArray[i2], "nt:folder");
                    }
                    ++i2;
                }
                session.save();
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws PortalException, SystemException {
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Workspace workspace = session.getWorkspace();
                VersionManager versionManager = workspace.getVersionManager();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                if (fileName.contains("/")) {
                    String path = fileName.substring(0, fileName.lastIndexOf("/"));
                    fileName = fileName.substring(path.length() + 1);
                    repositoryNode = this.getFolderNode(repositoryNode, path);
                }
                if (repositoryNode.hasNode(fileName)) {
                    throw new DuplicateFileException(fileName);
                }
                Node fileNode = repositoryNode.addNode(fileName, "nt:file");
                Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
                contentNode.addMixin("mix:versionable");
                contentNode.setProperty("jcr:mimeType", "text/plain");
                ValueFactory valueFactory = session.getValueFactory();
                Binary binary = valueFactory.createBinary(is);
                contentNode.setProperty("jcr:data", binary);
                contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                session.save();
                Version version = versionManager.checkin(contentNode.getPath());
                VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
                versionHistory.addVersionLabel(version.getName(), "1.0", false);
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public void checkRoot(long companyId) throws SystemException {
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                this.getRootNode(session, companyId);
                session.save();
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                Node dirNode = repositoryNode.getNode(dirName);
                dirNode.remove();
                session.save();
            }
            catch (PathNotFoundException pathNotFoundException) {
                throw new NoSuchDirectoryException(dirName);
            }
            catch (RepositoryException re) {
                String message = GetterUtil.getString((String)re.getMessage());
                if (message.contains("failed to resolve path")) {
                    throw new NoSuchDirectoryException(dirName);
                }
                throw new PortalException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        Node contentNode;
        Node fileNode;
        Node repositoryNode;
        Node rootNode;
        VersionManager versionManager;
        Workspace workspace;
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                workspace = session.getWorkspace();
                versionManager = workspace.getVersionManager();
                rootNode = this.getRootNode(session, companyId);
                repositoryNode = this.getFolderNode(rootNode, repositoryId);
                fileNode = repositoryNode.getNode(fileName);
                contentNode = fileNode.getNode("jcr:content");
                versionManager.checkout(contentNode.getPath());
                contentNode.setProperty("jcr:mimeType", "text/plain");
                contentNode.setProperty("jcr:data", "");
                contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                session.save();
                Version version = versionManager.checkin(contentNode.getPath());
                VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
                versionHistory.addVersionLabel(version.getName(), "0.0", false);
            }
            catch (PathNotFoundException pathNotFoundException) {
                throw new NoSuchFileException(fileName);
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
        try {
            try {
                session = JCRFactoryUtil.createSession();
                workspace = session.getWorkspace();
                versionManager = workspace.getVersionManager();
                rootNode = this.getRootNode(session, companyId);
                repositoryNode = this.getFolderNode(rootNode, repositoryId);
                fileNode = repositoryNode.getNode(fileName);
                contentNode = fileNode.getNode("jcr:content");
                VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
                VersionIterator itr = versionHistory.getAllVersions();
                while (itr.hasNext()) {
                    Version version = itr.nextVersion();
                    if (itr.getPosition() == itr.getSize()) break;
                    if (StringUtils.equals((String)"jcr:rootVersion", (String)version.getName())) continue;
                    versionHistory.removeVersion(version.getName());
                }
                session.save();
            }
            catch (PathNotFoundException pathNotFoundException) {
                throw new NoSuchFileException(fileName);
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Node rootNode2 = this.getRootNode(session, companyId);
                Node repositoryNode2 = this.getFolderNode(rootNode2, repositoryId);
                Node fileNode2 = repositoryNode2.getNode(fileName);
                fileNode2.remove();
                session.save();
            }
            catch (PathNotFoundException pathNotFoundException) {
                throw new NoSuchFileException(fileName);
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Workspace workspace = session.getWorkspace();
                VersionManager versionManager = workspace.getVersionManager();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                Node fileNode = repositoryNode.getNode(fileName);
                Node contentNode = fileNode.getNode("jcr:content");
                VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
                if (!versionHistory.hasVersionLabel(versionLabel)) {
                    throw new NoSuchFileException("{fileName=" + fileName + ", versionLabel=" + versionLabel + "}");
                }
                Version version = versionHistory.getVersionByLabel(versionLabel);
                Version linearPredecessorVersion = version.getLinearPredecessor();
                if (version.getLinearSuccessor() == null) {
                    Version restoreVersion = linearPredecessorVersion;
                    if (Validator.equals((Object)"jcr:rootVersion", (Object)linearPredecessorVersion.getName())) {
                        versionManager.checkout(contentNode.getPath());
                        restoreVersion = versionManager.checkin(contentNode.getPath());
                    }
                    versionManager.restore(restoreVersion, true);
                }
                versionHistory.removeVersion(version.getName());
                session.save();
            }
            catch (PathNotFoundException pathNotFoundException) {
                throw new NoSuchFileException("{fileName=" + fileName + ", versionLabel=" + versionLabel + "}");
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node contentNode = this.getFileContentNode(session, companyId, repositoryId, fileName, versionLabel);
            Property property = contentNode.getProperty("jcr:data");
            Value value = property.getValue();
            Binary binary = value.getBinary();
            if (session instanceof Map) {
                Map mapSession = (Map)session;
                mapSession.put(fileName, binary);
            }
            InputStream inputStream = binary.getStream();
            return inputStream;
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public String[] getFileNames(long companyId, long repositoryId) throws SystemException {
        ArrayList<String> fileNames = new ArrayList<String>();
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                NodeIterator itr = repositoryNode.getNodes();
                while (itr.hasNext()) {
                    Node node = (Node)itr.next();
                    NodeType primaryNodeType = node.getPrimaryNodeType();
                    String primaryNodeTypeName = primaryNodeType.getName();
                    if (!primaryNodeTypeName.equals("nt:file")) continue;
                    fileNames.add(node.getName());
                }
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        ArrayList<String> fileNames = new ArrayList<String>();
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                Node dirNode = repositoryNode.getNode(dirName);
                NodeIterator itr = dirNode.getNodes();
                while (itr.hasNext()) {
                    Node node = (Node)itr.next();
                    NodeType primaryNodeType = node.getPrimaryNodeType();
                    String primaryNodeTypeName = primaryNodeType.getName();
                    if (!primaryNodeTypeName.equals("nt:file")) continue;
                    fileNames.add(String.valueOf(dirName) + "/" + node.getName());
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                throw new NoSuchDirectoryException(dirName);
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        long size;
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Node contentNode = this.getFileContentNode(session, companyId, repositoryId, fileName, "");
                size = contentNode.getProperty("jcr:data").getLength();
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
        return size;
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) throws SystemException {
        Session session = null;
        try {
            session = JCRFactoryUtil.createSession();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            repositoryNode.getNode(dirName);
            return true;
        }
        catch (PathNotFoundException pathNotFoundException) {
            return false;
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        try {
            this.getFileContentNode(companyId, repositoryId, fileName, versionLabel);
        }
        catch (NoSuchFileException noSuchFileException) {
            return false;
        }
        return true;
    }

    public void move(String srcDir, String destDir) throws SystemException {
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                session.move(srcDir, destDir);
                session.save();
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException, SystemException {
        Session session = null;
        try {
            try {
                Node newRepositoryNode;
                session = JCRFactoryUtil.createSession();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                if (fileName.contains("/")) {
                    String path = fileName.substring(0, fileName.lastIndexOf("/"));
                    fileName = fileName.substring(path.length() + 1);
                    repositoryNode = this.getFolderNode(repositoryNode, path);
                }
                if ((newRepositoryNode = this.getFolderNode(rootNode, newRepositoryId)).hasNode(fileName)) {
                    throw new DuplicateFileException(fileName);
                }
                Node fileNode = repositoryNode.getNode(fileName);
                Node contentNode = fileNode.getNode("jcr:content");
                String contentNodePath = contentNode.getPath();
                Node newFileNode = newRepositoryNode.addNode(fileName, "nt:file");
                String newContentNodePath = newFileNode.getPath().concat("/").concat("jcr:content");
                session.move(contentNodePath, newContentNodePath);
                fileNode.remove();
                session.save();
            }
            catch (PathNotFoundException pathNotFoundException) {
                throw new NoSuchFileException(fileName);
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws PortalException, SystemException {
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                if (fileName.contains("/")) {
                    String path = fileName.substring(0, fileName.lastIndexOf("/"));
                    fileName = fileName.substring(path.length() + 1);
                    repositoryNode = this.getFolderNode(repositoryNode, path);
                }
                if (repositoryNode.hasNode(newFileName)) {
                    throw new DuplicateFileException(newFileName);
                }
                Node fileNode = repositoryNode.getNode(fileName);
                Node contentNode = fileNode.getNode("jcr:content");
                String contentNodePath = contentNode.getPath();
                Node newFileNode = repositoryNode.addNode(newFileName, "nt:file");
                String newContentNodePath = newFileNode.getPath().concat("/").concat("jcr:content");
                session.move(contentNodePath, newContentNodePath);
                fileNode.remove();
                session.save();
            }
            catch (PathNotFoundException pathNotFoundException) {
                throw new NoSuchFileException(fileName);
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String versionLabel, InputStream is) throws PortalException, SystemException {
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                Workspace workspace = session.getWorkspace();
                VersionManager versionManager = workspace.getVersionManager();
                Node rootNode = this.getRootNode(session, companyId);
                Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
                if (fileName.contains("/")) {
                    String path = fileName.substring(0, fileName.lastIndexOf("/"));
                    fileName = fileName.substring(path.length() + 1);
                    repositoryNode = this.getFolderNode(repositoryNode, path);
                }
                Node fileNode = repositoryNode.getNode(fileName);
                Node contentNode = fileNode.getNode("jcr:content");
                versionManager.checkout(contentNode.getPath());
                contentNode.setProperty("jcr:mimeType", "text/plain");
                ValueFactory valueFactory = session.getValueFactory();
                Binary binary = valueFactory.createBinary(is);
                contentNode.setProperty("jcr:data", binary);
                contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                session.save();
                Version version = versionManager.checkin(contentNode.getPath());
                VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
                versionHistory.addVersionLabel(version.getName(), versionLabel, PropsValues.DL_STORE_JCR_MOVE_VERSION_LABELS);
            }
            catch (PathNotFoundException pathNotFoundException) {
                throw new NoSuchFileException("{fileName=" + fileName + ", versionLabel=" + versionLabel + "}");
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
    }

    protected Node getFileContentNode(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        Node contentNode = null;
        Session session = null;
        try {
            try {
                session = JCRFactoryUtil.createSession();
                contentNode = this.getFileContentNode(session, companyId, repositoryId, fileName, versionLabel);
            }
            catch (RepositoryException re) {
                throw new SystemException((Throwable)re);
            }
        }
        finally {
            JCRFactoryUtil.closeSession(session);
        }
        return contentNode;
    }

    protected Node getFileContentNode(Session session, long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException, SystemException {
        Node contentNode = null;
        try {
            Workspace workspace = session.getWorkspace();
            VersionManager versionManager = workspace.getVersionManager();
            Node rootNode = this.getRootNode(session, companyId);
            Node repositoryNode = this.getFolderNode(rootNode, repositoryId);
            Node fileNode = repositoryNode.getNode(fileName);
            contentNode = fileNode.getNode("jcr:content");
            if (Validator.isNotNull((String)versionLabel)) {
                VersionHistory versionHistory = versionManager.getVersionHistory(contentNode.getPath());
                if (!versionHistory.hasVersionLabel(versionLabel)) {
                    throw new NoSuchFileException("{fileName=" + fileName + ", versionLabel=" + versionLabel + "}");
                }
                Version version = versionHistory.getVersionByLabel(versionLabel);
                contentNode = version.getNode("jcr:frozenNode");
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            throw new NoSuchFileException("{fileName=" + fileName + ", versionLabel=" + versionLabel + "}");
        }
        catch (RepositoryException re) {
            throw new SystemException((Throwable)re);
        }
        return contentNode;
    }

    protected Node getFolderNode(Node node, long name) throws RepositoryException {
        return this.getFolderNode(node, String.valueOf(name));
    }

    protected Node getFolderNode(Node node, String name) throws RepositoryException {
        if (name.contains("/")) {
            String[] nameParts = name.split("/", 2);
            node = this.getFolderNode(node, nameParts[0]);
            return this.getFolderNode(node, nameParts[1]);
        }
        Node folderNode = null;
        folderNode = node.hasNode(name) ? node.getNode(name) : node.addNode(name, "nt:folder");
        return folderNode;
    }

    protected Node getRootNode(Session session, long companyId) throws RepositoryException {
        Node companyNode = this.getFolderNode(session.getRootNode(), companyId);
        return this.getFolderNode(companyNode, JCRFactory.NODE_DOCUMENTLIBRARY);
    }
}

