/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import java.util.Map;

public class DDLRecordStagedModelDataHandler
extends BaseStagedModelDataHandler<DDLRecord> {
    public static final String[] CLASS_NAMES = new String[]{DDLRecord.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        DDLRecord record = DDLRecordLocalServiceUtil.fetchDDLRecordByUuidAndGroupId((String)uuid, (long)groupId);
        if (record != null) {
            DDLRecordLocalServiceUtil.deleteRecord((DDLRecord)record);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDLRecord record) {
        return record.getUuid();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDLRecord record) throws Exception {
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)record, (StagedModel)record.getRecordSet(), (String)"strong");
        DDLRecordVersion recordVersion = record.getRecordVersion();
        Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
        String fieldsPath = ExportImportPathUtil.getModelPath((StagedModel)record, (String)"fields.xml");
        portletDataContext.addZipEntry(fieldsPath, (Object)fields);
        Element recordElement = portletDataContext.getExportDataElement((ClassedModel)record);
        recordElement.addAttribute("fields-path", fieldsPath);
        portletDataContext.addClassedModel(recordElement, ExportImportPathUtil.getModelPath((StagedModel)record), (ClassedModel)record);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDLRecord record) throws Exception {
        long userId = portletDataContext.getUserId(record.getUserUuid());
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)record, DDLRecordSet.class, (long)record.getRecordSetId());
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        long recordSetId = MapUtil.getLong((Map)recordSetIds, (long)record.getRecordSetId(), (long)record.getRecordSetId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)record);
        Element recordElement = portletDataContext.getImportDataElement((StagedModel)record);
        Fields fields = (Fields)portletDataContext.getZipEntryAsObject(recordElement.attributeValue("fields-path"));
        DDLRecord importedRecord = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DDLRecord existingRecord = DDLRecordLocalServiceUtil.fetchDDLRecordByUuidAndGroupId((String)record.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingRecord == null) {
                serviceContext.setUuid(record.getUuid());
                importedRecord = DDLRecordLocalServiceUtil.addRecord((long)userId, (long)portletDataContext.getScopeGroupId(), (long)recordSetId, (int)record.getDisplayIndex(), (Fields)fields, (ServiceContext)serviceContext);
            } else {
                importedRecord = DDLRecordLocalServiceUtil.updateRecord((long)userId, (long)existingRecord.getRecordId(), (boolean)false, (int)record.getDisplayIndex(), (Fields)fields, (boolean)true, (ServiceContext)serviceContext);
            }
        } else {
            importedRecord = DDLRecordLocalServiceUtil.addRecord((long)userId, (long)portletDataContext.getScopeGroupId(), (long)recordSetId, (int)record.getDisplayIndex(), (Fields)fields, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)record, (ClassedModel)importedRecord);
    }

    protected void validateExport(PortletDataContext portletDataContext, DDLRecord record) throws PortletDataException {
        int status = -1;
        try {
            status = record.getStatus();
        }
        catch (Exception e2) {
            throw new PortletDataException((Throwable)e2);
        }
        if (!ArrayUtil.contains((int[])this.getExportableStatuses(), (int)status)) {
            PortletDataException pde = new PortletDataException(9);
            pde.setStagedModel((StagedModel)record);
            throw pde;
        }
    }
}

