/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.asset.JournalArticleAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import com.liferay.portlet.journal.trash.JournalBaseTrashHandler;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.trash.DuplicateEntryException;
import com.liferay.portlet.trash.model.TrashEntry;
import javax.portlet.PortletRequest;

public class JournalArticleTrashHandler
extends JournalBaseTrashHandler {
    public void checkDuplicateEntry(long classPK, long containerModelId, String newName) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        this.checkDuplicateEntry(classPK, 0L, containerModelId, article.getArticleId(), newName);
    }

    public void checkDuplicateTrashEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException, SystemException {
        this.checkDuplicateEntry(trashEntry.getClassPK(), trashEntry.getEntryId(), containerModelId, trashEntry.getTypeSettingsProperty("title"), newName);
    }

    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        JournalArticleLocalServiceUtil.deleteArticle((long)article.getGroupId(), (String)article.getArticleId(), null);
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        long parentFolderId = article.getFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException, SystemException {
        JournalArticle article = (JournalArticle)trashedModel;
        return this.getContainerModel(article.getFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        return JournalUtil.getJournalControlPanelLink(portletRequest, article.getFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        return JournalUtil.getAbsolutePath(portletRequest, article.getFolderId());
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        return article.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        return new JournalArticleAssetRenderer(article);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        if (trashActionId.equals("MOVE")) {
            return JournalFolderPermission.contains(permissionChecker, groupId, classPK, "ADD_ARTICLE");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        return article.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        return article.isInTrashContainer();
    }

    public boolean isRestorable(long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        if (article.getFolderId() > 0L && JournalFolderLocalServiceUtil.fetchFolder((long)article.getFolderId()) == null) {
            return false;
        }
        return !article.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        JournalArticleLocalServiceUtil.moveArticle((long)article.getGroupId(), (String)article.getArticleId(), (long)containerModelId);
    }

    public void moveTrashEntry(long userId, long classPK, long containerId, ServiceContext serviceContext) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        JournalArticleLocalServiceUtil.moveArticleFromTrash((long)userId, (long)article.getGroupId(), (JournalArticle)article, (long)containerId, (ServiceContext)serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        JournalArticleLocalServiceUtil.restoreArticleFromTrash((long)userId, (JournalArticle)article);
    }

    public void updateTitle(long classPK, String name) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        article.setArticleId(name);
        JournalArticleLocalServiceUtil.updateJournalArticle((JournalArticle)article);
        JournalArticleResource articleResource = JournalArticleResourceLocalServiceUtil.getArticleResource((long)article.getResourcePrimKey());
        articleResource.setArticleId(name);
        JournalArticleResourceLocalServiceUtil.updateJournalArticleResource((JournalArticleResource)articleResource);
    }

    protected void checkDuplicateEntry(long classPK, long trashEntryId, long containerModelId, String originalTitle, String newName) throws PortalException, SystemException {
        JournalArticleResource originalArticleResource;
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        JournalArticleResource journalArticleResource = article.getArticleResource();
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((originalArticleResource = JournalArticleResourceLocalServiceUtil.fetchArticleResource((long)article.getGroupId(), (String)originalTitle)) != null && journalArticleResource.getPrimaryKey() != originalArticleResource.getPrimaryKey()) {
            DuplicateEntryException dee = new DuplicateEntryException();
            JournalArticle duplicateArticle = JournalArticleLocalServiceUtil.getArticle((long)originalArticleResource.getGroupId(), (String)originalTitle);
            dee.setDuplicateEntryId(duplicateArticle.getResourcePrimKey());
            dee.setOldName(duplicateArticle.getArticleId());
            dee.setTrashEntryId(trashEntryId);
            throw dee;
        }
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException, SystemException {
        JournalArticle article = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
        return article.getGroupId();
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        return JournalArticlePermission.contains(permissionChecker, classPK, actionId);
    }
}

