/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.HitsOpenSearchImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalContentSearch;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.List;
import javax.portlet.PortletURL;

public class JournalOpenSearchImpl
extends HitsOpenSearchImpl {
    public static final String SEARCH_PATH = "/c/journal/open_search";
    public static final String TITLE = "Liferay Journal Search: ";

    public Indexer getIndexer() {
        return IndexerRegistryUtil.getIndexer(JournalArticle.class);
    }

    public String getPortletId() {
        return "15";
    }

    public String getSearchPath() {
        return SEARCH_PATH;
    }

    public String getTitle(String keywords) {
        return TITLE + keywords;
    }

    protected String getLayoutURL(ThemeDisplay themeDisplay, String articleId) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        List contentSearches = JournalContentSearchLocalServiceUtil.getArticleContentSearches((String)articleId);
        for (JournalContentSearch contentSearch : contentSearches) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)contentSearch.getGroupId(), (boolean)contentSearch.isPrivateLayout(), (long)contentSearch.getLayoutId(), (String)"VIEW") || contentSearch.isPrivateLayout() && !GroupLocalServiceUtil.hasUserGroup((long)themeDisplay.getUserId(), (long)contentSearch.getGroupId())) continue;
            Layout hitLayout = LayoutLocalServiceUtil.getLayout((long)contentSearch.getGroupId(), (boolean)contentSearch.isPrivateLayout(), (long)contentSearch.getLayoutId());
            return PortalUtil.getLayoutURL((Layout)hitLayout, (ThemeDisplay)themeDisplay);
        }
        return null;
    }

    protected String getURL(ThemeDisplay themeDisplay, long groupId, Document result, PortletURL portletURL) throws Exception {
        String articleId = result.get("articleId");
        JournalArticle article = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId);
        if (Validator.isNotNull((String)article.getLayoutUuid())) {
            String groupFriendlyURL = PortalUtil.getGroupFriendlyURL((Group)GroupLocalServiceUtil.getGroup((long)article.getGroupId()), (boolean)false, (ThemeDisplay)themeDisplay);
            return groupFriendlyURL.concat("/-/").concat(article.getUrlTitle());
        }
        Layout layout = themeDisplay.getLayout();
        List hitLayoutIds = JournalContentSearchLocalServiceUtil.getLayoutIds((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (String)articleId);
        for (Long hitLayoutId : hitLayoutIds) {
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)hitLayoutId, (String)"VIEW")) continue;
            Layout hitLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)hitLayoutId);
            return PortalUtil.getLayoutURL((Layout)hitLayout, (ThemeDisplay)themeDisplay);
        }
        String layoutURL = this.getLayoutURL(themeDisplay, articleId);
        if (layoutURL != null) {
            return layoutURL;
        }
        portletURL.setParameter("struts_action", "/journal/view_article");
        portletURL.setParameter("groupId", String.valueOf(groupId));
        portletURL.setParameter("articleId", articleId);
        String version = result.get("version");
        portletURL.setParameter("version", version);
        return portletURL.toString();
    }
}

