/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocaleTransformerListener
extends BaseTransformerListener {
    private static Log _log = LogFactoryUtil.getLog(LocaleTransformerListener.class);

    public String onScript(String script, String xml, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return StringUtil.replace((String)script, (String)"@language_id@", (String)languageId);
    }

    public String onXml(String xml, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        return this.filterByLanguage(xml, languageId);
    }

    protected void filterByLanguage(Element root, String languageId, String defaultLanguageId) {
        Element defaultLanguageElement = null;
        boolean hasLanguageIdElement = false;
        List elements = root.elements();
        int listIndex = elements.size() - 1;
        while (listIndex >= 0) {
            Element element = (Element)elements.get(listIndex);
            String tempLanguageId = element.attributeValue("language-id", languageId);
            if (StringUtil.equalsIgnoreCase((String)tempLanguageId, (String)languageId)) {
                hasLanguageIdElement = true;
                this.filterByLanguage(element, languageId, defaultLanguageId);
            } else {
                if (StringUtil.equalsIgnoreCase((String)tempLanguageId, (String)defaultLanguageId)) {
                    defaultLanguageElement = element;
                }
                root.remove(element);
            }
            --listIndex;
        }
        if (!hasLanguageIdElement && defaultLanguageElement != null) {
            root.add(defaultLanguageElement);
            this.filterByLanguage(defaultLanguageElement, languageId, defaultLanguageId);
        }
    }

    protected String filterByLanguage(String xml, String languageId) {
        if (xml == null) {
            return xml;
        }
        try {
            Document document = SAXReaderUtil.read((String)xml);
            Element rootElement = document.getRootElement();
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            String[] availableLocales = StringUtil.split((String)rootElement.attributeValue("available-locales", defaultLanguageId));
            String defaultLocale = rootElement.attributeValue("default-locale", defaultLanguageId);
            boolean supportedLocale = false;
            String[] stringArray = availableLocales;
            int n = availableLocales.length;
            int n2 = 0;
            while (n2 < n) {
                String availableLocale = stringArray[n2];
                if (StringUtil.equalsIgnoreCase((String)availableLocale, (String)languageId)) {
                    supportedLocale = true;
                    break;
                }
                ++n2;
            }
            if (!supportedLocale) {
                this.filterByLanguage(rootElement, defaultLocale, defaultLanguageId);
            } else {
                this.filterByLanguage(rootElement, languageId, defaultLanguageId);
            }
            xml = DDMXMLUtil.formatXML((Document)document);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return xml;
    }
}

